<?php
/* 
 * Copyright (C) 2013 ethicweb                  <infos@ethicweb.com>
 *
 */
/**
 *	\file       relanceTiers/relance_tiers.php
 */
// Dolibarr environment
$res = @include("../main.inc.php"); // From htdocs directory
if (! $res) {
    $res = @include("../../main.inc.php"); // From "custom" directory
}
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once(DOL_DOCUMENT_ROOT."/core/lib/functions2.lib.php");
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';


require_once 'core/modules/relanceTiers/modules_relanceTiers.php';
require_once 'core/modules/courrier/modules_courrier.php';
dol_include_once('/relanceTiers/class/relancearchive.class.php');

function isEmail($email) {
    return preg_match('|^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]{2,})+$|i', $email);
};

	function converToDoppleDecimal($var){
	if(strpos($var,".")===FALSE)return $var.".00";
	else if(strlen($var) - strpos($var,".") == 2)
	return $var."0";
	else if(strlen($var) - strpos($var,".") == 1)
	return $var."00";
	else return substr($var,0,strpos($var,'.')+3);
	
	}
	
$langs->load("banks");
$langs->load("categories");
$langs->load("prelevementSEPA@prelevementSEPA");
$langs->load("widthdrawals");
$langs->load("companies");
$langs->load("bills");
$langs->load("relanceTiers@relanceTiers");

global $db,$conf;

// Security check
if ($user->societe_id) $socid=$user->societe_id;
$result = restrictedArea($user, 'societe', '', '');

// Get supervariables
$action = GETPOST('action','alpha');
function envoi_mail_retard($email,$message_txt,$title,$pdf,$from,$from_mail){


	if (!preg_match("#^[a-z0-9._-]+@(hotmail|gmail|live|msn).[a-z]{2,4}$#", $email)) // On filtre les serveurs qui présentent des bogues.
	{
		$passage_ligne = "\r\n";
	}
	else
	{
		$passage_ligne = "\n";
	}
	
	 
	//=====Lecture et mise en forme de la pièce jointe.
	$fichier   = fopen($pdf, "r");
	$attachement = fread($fichier, filesize($pdf));
	$attachement = chunk_split(base64_encode($attachement));
	fclose($fichier);
	//==========
	 
	//=====Création de la boundary.
	$boundary = "-----=".md5(rand());
	$boundary_alt = "-----=".md5(rand());
	//==========
	 
	//=====Définition du sujet.
	$sujet = utf8_decode($title);
	//=========
	 
	//=====Création du header de l'e-mail.
	$header = "From: \"".$from."\" <".$from_mail.">".$passage_ligne;
	$header.= "Reply-to: \"".$from."\" <".$from_mail.">".$passage_ligne;
	$header.= "MIME-Version: 1.0".$passage_ligne;
	$header.= "Content-Type: multipart/mixed;".$passage_ligne." boundary=\"".$boundary."\"".$passage_ligne;
	//==========
	 
	//=====Création du message.
	$message = $passage_ligne."--".$boundary.$passage_ligne;
	$message.= "Content-Type: multipart/alternative;".$passage_ligne." boundary=\"".$boundary_alt."\"".$passage_ligne;
	
	$message.= $passage_ligne."--".$boundary_alt.$passage_ligne;
	//=====Ajout du message au format texte.
	$message.= "Content-Type: text/plain; charset=\"UTF-8\"".$passage_ligne;
	$message.= "Content-Transfer-Encoding: 8bit".$passage_ligne;
	$message.= $passage_ligne.$message_txt.$passage_ligne;
	//==========
	 
	 
	//=====On ferme la boundary alternative.
	$message.= $passage_ligne."--".$boundary_alt."--".$passage_ligne;
	//==========
	 
	 
	 
	$message.= $passage_ligne."--".$boundary.$passage_ligne;
	 
	//=====Ajout de la pièce jointe.
	$message.= "Content-Type: application/pdf; name=\"Votre_releve.pdf\"".$passage_ligne;
	$message.= "Content-Transfer-Encoding: base64".$passage_ligne;
	$message.= "Content-Disposition: attachment; filename=\"Votre_releve.pdf\"".$passage_ligne;
	$message.= $passage_ligne.$attachement.$passage_ligne.$passage_ligne;
	$message.= $passage_ligne."--".$boundary."--".$passage_ligne; 
	//========== 
	//=====Envoi de l'e-mail.
	mail($email,$sujet,$message,$header);
	//==========

}

///////////////////////////////////////////////////
// TRAITEMENT POST
/////////////////////////////////////
		$nb_mess=0;
$i=1;
	$errMess='';
if(isset($_POST['envoi_'.$i]))
{

	if($_POST['type_relance']==2 || $_POST['type_relance']==3) // MAIL
	{
		while(isset($_POST['envoi_'.$i])){
			$socid=$_POST['envoi_'.$i];
			if($_POST['do_'.$i]){
				$sql="SELECT nom,
					SUM(amount) as som,
					relance_lvl,
					relance_total,
					date_relance,
					max(if(paye=0,DATEDIFF(CURDATE(),date),0)) as retard,
					max(dateprel) as lastprel,
					sum(if(fac=1 and paye=0,1,0)) as nb_non_paye,
					socid,
							contact_relance,
							email,
							SUM(-1*amount) as somdue
					FROM(
						SELECT 
							pf.amount,
							f.paye,
							0 as fac,
							f.date_lim_reglement as date, 
							p.datep as dateprel, 
							s.rowid as socid,
							s.nom as nom,
							s.date_relance,
							s.relance_lvl,
									s.email,
							s.contact_relance,
							s.relance_total,
							p.rowid
								FROM `llx_societe` s 
								inner join llx_facture f on f.fk_soc=s.rowid 
								inner join llx_paiement_facture pf on  pf.fk_facture=f.rowid 
								inner join llx_paiement p on pf.fk_paiement=p.rowid 
								inner join llx_c_paiement ty on ty.id=p.fk_paiement 
								WHERE s.rowid=".$socid."
								AND f.fk_statut =1
								AND paye = 0
								AND f.date_lim_reglement < CURDATE()
						UNION ALL 
						SELECT 
							f.total_ttc*(-1) as amount,
							f.paye,
							1 as fac,
							f.date_lim_reglement as date,
							\"0000-00-00\" as dateprel,
							s.rowid as socid,
							s.nom as nom,
							s.date_relance,
							s.relance_lvl,
									s.email,
							s.contact_relance,
							s.relance_total,
							f.rowid
								FROM `llx_societe` s 
								inner join llx_facture f on f.fk_soc=s.rowid 
								WHERE s.rowid=".$socid."
								AND f.fk_statut =1
								AND paye = 0
								AND f.total_ttc > 0 
								AND f.date_lim_reglement < CURDATE()
		UNION ALL 
		SELECT 
			f.total_ttc*(-1) as amount,
			1 AS paye,
			3 as fac,
			f.datef as date,
			\"0000-00-00\" as dateprel,
			s.rowid as socid,
			s.nom as nom,
			s.date_relance,
			s.relance_lvl,
					s.email,
			s.contact_relance,
			s.relance_total,
							f.rowid
				FROM `llx_societe` s 
				inner join llx_facture f on f.fk_soc=s.rowid 
				WHERE s.rowid=".$socid."
								AND f.paye =0
					AND f.fk_statut =1
			AND f.total_ttc < 0 
		UNION ALL 
		SELECT 
			r.amount_ttc as amount,
			1 as paye,
			3 as fac,
			r.datec as date,
			\"0000-00-00\" as dateprel,
			s.rowid as socid,
			s.nom as nom,
			s.date_relance,
			s.relance_lvl,
					s.email,
			s.contact_relance,
			s.relance_total,
							r.rowid
				FROM `llx_societe` s 
				inner join llx_societe_remise_except r on s.rowid=r.fk_soc
				WHERE s.rowid=".$socid."
								AND r.fk_facture IS NULL
				AND r.fk_facture_line IS NULL
				AND r.fk_facture_source IS NULL
		UNION ALL 
		SELECT 
			r.amount_ttc as amount,
			1 as paye,
			3 as fac,
			r.datec as date,
			\"0000-00-00\" as dateprel,
			s.rowid as socid,
			s.nom as nom,
			s.date_relance,
			s.relance_lvl,
					s.email,
			s.contact_relance,
			s.relance_total,
							r.rowid
				FROM `llx_societe` s 
				inner join llx_societe_remise_except r on s.rowid=r.fk_soc
				inner join llx_facture f on f.rowid=r.fk_facture_source
				WHERE s.rowid=".$socid."
								AND r.fk_facture IS NULL
				AND r.fk_facture_line IS NULL
		UNION ALL 
		SELECT 
			r.amount_ttc as amount,
			1 as paye,
			3 as fac,
			r.datec as date,
			\"0000-00-00\" as dateprel,
			s.rowid as socid,
			s.nom as nom,
			s.date_relance,
			s.relance_lvl,
					s.email,
			s.contact_relance,
			s.relance_total,
							r.rowid
				FROM `llx_societe` s 
				inner join llx_facture f on f.fk_soc=s.rowid 
				inner join llx_societe_remise_except r on s.rowid=r.fk_soc
				inner join llx_facture f2 on f2.rowid=r.fk_facture_source
				WHERE s.rowid=".$socid."
								AND f.paye =0
					AND f.fk_statut =1
					AND f.total_ttc>0
				AND f.date_lim_reglement < CURDATE()
					AND r.fk_facture = f.rowid
					AND r.fk_facture_line IS NULL
						) as a
						JOIN (SELECT @csum := 0) b
					GROUP BY socid
					HAVING nb_non_paye>0
					AND retard >0";
				$resql=$db->query($sql);
				if ($resql)
				{
					$row = $db->fetch_row($resql);
					if($row)
					{
						$error=0;
						$lvl=$row[2];
						switch($lvl){
							case 1:
								$text=$conf->global->RELANCE_TEXT_MAIL_1;
								$title=$conf->global->RELANCE_TITLE_MAIL_1;
							break;
							
							case 2:
								$text=$conf->global->RELANCE_TEXT_MAIL_2;
								$title=$conf->global->RELANCE_TITLE_MAIL_2;
							break;
							
							case 3:
								$text=$conf->global->RELANCE_TEXT_MAIL_3;
								$title=$conf->global->RELANCE_TITLE_MAIL_3;
							break;
							
							default:
							$error=1;
							break;
						}
						
						if(!$error)
						{
						//echo "pas d'erreur";exit();
							$text=str_replace(array("[name]","[balance]","[nb_invoice_unpaid]","[late]","[somme_due]"),array($row[0],converToDoppleDecimal($row[1]).' '.$conf->currency.'',$row[7],$row[5]." ".$langs->trans("jour")."(s)",converToDoppleDecimal($row[11]).' '.$conf->currency.''),$text);
							$title=str_replace(array("[name]","[balance]","[nb_invoice_unpaid]","[late]","[somme_due]"),array($row[0],converToDoppleDecimal($row[1]).' '.$conf->currency.'',$row[7],$row[5]." ".$langs->trans("jour")."(s)",converToDoppleDecimal($row[11]).' '.$conf->currency.''),$title);
							
												
							$soc = new Societe($db);
							$soc->fetch($socid);
							
							if($_POST['type_relance']==2)
								$result=relanceTiers_pdf_create($db, $soc, "crabe", $outputlangs, $hidedetails, $hidedesc, $hideref, "0");
							else
								$result=relanceTiers_pdf_create($db, $soc, "crabe", $outputlangs, $hidedetails, $hidedesc, $hideref, "1");
							
							if($row[9]!=0)
							{
								$sqlcontact='SELECT email FROM llx_socpeople WHERE rowid='.$row[9].';';
								$resqlcontact=$db->query($sqlcontact);
								if ($resqlcontact)
								{
									$rowcontact = $db->fetch_row($resqlcontact);
									$email=$rowcontact[0];
								}
							}
							else
							$email = $row[10];
							
							if(isEmail($email)){
							
								$sql_temp='UPDATE llx_societe SET 
								relance_lvl = IF(relance_lvl=relance_lvlmax,relance_lvlmax,relance_lvl+1),
								relance_total = relance_total+1,
								date_relance = NOW()
								WHERE rowid = '.$socid.';';
								$resql_temp=$db->query($sql_temp);					
							
							
								envoi_mail_retard($email,$text,$title,DOL_DATA_ROOT."/relanceTiers/receipts/".$socid."/".$socid.".pdf",$conf->global->MAIN_INFO_SOCIETE_NOM,$conf->global->MAIN_INFO_SOCIETE_MAIL);
								if(isEmail($conf->global->RELANCE_EMAIL_COPIE))envoi_mail_retard($conf->global->RELANCE_EMAIL_COPIE,'Copie du mail envoyé au client : '.$row[0].' à l\'adresse : '.$email.'
		'.$text,$title,DOL_DATA_ROOT."/relanceTiers/receipts/".$socid."/".$socid.".pdf",$conf->global->MAIN_INFO_SOCIETE_NOM,$conf->global->MAIN_INFO_SOCIETE_MAIL);
								else $errMess .= "\nMail envoyé au tiers ".$row[0]."  mais sans copie, l'adresse \"".$conf->global->RELANCE_EMAIL_COPIE."\" n'est pas correcte.<br />";
								$nb_mess++;
							}
						}
						else{
						//echo '\nUne erreur est survenue lors de l\'envoi du mail de relance au tiers '.$row[0].'<br />';exit();
							$errMess .= '\nUne erreur est survenue lors de l\'envoi du mail de relance au tiers '.$row[0].'<br />';
						}
					}
				}


			}$i++;
		}

		$dll = $_SERVER['PHP_SELF'];
	}
	else if($_POST['type_relance']==1) // COURRIER 
	{
	
		$object_array=array();
		while(isset($_POST['envoi_'.$i])){
			$socid=$_POST['envoi_'.$i];
			if($_POST['do_'.$i]){
				$object=new Societe($db);
				$object->fetch($socid);
				$object->modelpdf       = 'generic_invoice_odt:'.dol_buildpath('/custom/relanceTiers/tpl/template_courrier.odt');
				$object_push=array($object);
				$object_array=array_merge($object_array,$object_push);
				
			}
			$i++;
		}
$i=1;
		$result = courrierRelance_pdf_create($db, $object_array, $object->modelpdf, $langs);
		while(isset($_POST['envoi_'.$i])){
			$socid=$_POST['envoi_'.$i];
			if($_POST['do_'.$i]){
				
				$sql_temp='UPDATE llx_societe SET 
				relance_lvl = IF(relance_lvl=relance_lvlmax,relance_lvlmax,relance_lvl+1),
				relance_total = relance_total+1,
				date_relance = NOW()
				WHERE rowid = '.$socid.';';
				$resql_temp=$db->query($sql_temp);	
			}
			$i++;
		}
		
		$dll = 'document.php?modulepart=relanceODT&file=relance_'.date('Y_m_d').'_courrier.odt';
		
	}
	else if($_POST['type_relance']==0) // COURRIER VISUEL UNIQUEMENT
	{
	
		$object_array=array();
		while(isset($_POST['envoi_'.$i])){
			$socid=$_POST['envoi_'.$i];
			if($_POST['do_'.$i]){
				$object=new Societe($db);
				$object->fetch($socid);
				$object->modelpdf       = 'generic_invoice_odt:'.dol_buildpath('/custom/relanceTiers/tpl/template_courrier.odt');
				$object_push=array($object);
				$object_array=array_merge($object_array,$object_push);
			}
			$i++;
		}
		$result = courrierRelance_pdf_create($db, $object_array, $object->modelpdf, $langs);
		
		
		$dll = 'document.php?modulepart=relanceODT&file=relance_'.date('Y_m_d').'_courrier.odt';
		
	}
	$j=1;
	while(isset($_POST["envoi_$j"])){
		if(isset($_POST["do_$j"])){
			$socid=$_POST['envoi_'.$j];

			$relanceRes = $db->query('SELECT relance_lvl FROM llx_societe WHERE rowid = '.$socid.';');
			$relance_lvl = 0;
			if($relanceRes){
				list($relance_lvl) = $db->fetch_row($relanceRes);
			}

			$relanceArchive = new Relancearchive($db);
			$relanceArchive->date_relance = dol_mktime(0, 0, 0, date('m'), date('d'), date('Y'));
			$type_relance = GETPOST('type_relance','int');
			switch ($type_relance) {
				case 0:
					$relanceArchive->type_relance =$langs->trans('ODTvisu');
					break;
				case 1:
					$relanceArchive->type_relance =$langs->trans('ODTenvoi');
					break;
				case 2:
					$relanceArchive->type_relance =$langs->trans('Mailenvoi');
					break;
				case 3:
					$relanceArchive->type_relance =$langs->trans('Mailenvoinonpaye');
					break;
				default:
					$relanceArchive->type_relance = 'test';
					break;
			}
			$relanceArchive->niveau_relance=$relance_lvl;
			$relanceArchive->description=$langs->trans('AutoRelance');
			$relanceArchive->fk_soc = $socid;

			$relanceArchive->create($user);
		}
		$j++;
	}

	Header('Location: '.$dll);
}


/*
 * Actions
 */
// Change customer bank information to withdraw
if ($action == 'modify')
{
}




/*
 * View
 */

llxHeader('', $langs->trans("RelanceTiers"));



if(file_exists(DOL_DOCUMENT_ROOT.'/relanceTiers'))
{
$h=0;
$head[$h][0] = DOL_URL_ROOT.'/relanceTiers/relance_tiers.php';
$head[$h][1] = $langs->trans("RelanceTiers");
$h++;
}
else
{
$h=0;
$head[$h][0] = DOL_URL_ROOT.'/custom/relanceTiers/relance_tiers.php';
$head[$h][1] = $langs->trans("RelanceTiers");
$h++;
}


dol_fiche_head($head, '', $langs->trans("RelanceTiers"),0,'');


if(isset($_POST['envoi_1']))print '<div style="color:'.($nb_mess==0?'red':'green').'">'.$nb_mess.' '.$langs->trans("messEnvoye")."</div>".
'<div style="color:red">'.$errMess.'</div>';

?>

<script type="text/javascript">
$(document).ready(function() {
	$("#checkall").click(function() {
		$(".checkformerge").attr('checked', true);
	});
	$("#checknone").click(function() {
		$(".checkformerge").attr('checked', false);
	});
});
</script>



<?php
///////////////////////////////////////////////////
// VUE
/////////////////////////////////////
if($user->rights->relanceTiers->lire == 1){
$sql="SELECT nom,
SUM(amount) as som,
relance_lvl,
relance_total,
date_relance,
max(if(paye=0,DATEDIFF(CURDATE(),date),0)) as retard,
max(dateprel) as lastprel,
sum(if(fac=1 and paye=0,1,0)) as nb_non_paye,
socid,
		contact_relance,
		email,
		relance_lvlmax
FROM(
	SELECT 
		pf.amount,
		f.paye,
    	0 as fac,
		f.date_lim_reglement as date, 
		p.datep as dateprel, 
		s.rowid as socid,
		s.nom as nom,
		s.date_relance,
		s.relance_lvl,
				s.email,
		s.contact_relance,
		s.relance_total,
							p.rowid,
		s.relance_lvlmax
			FROM `llx_societe` s 
			inner join llx_facture f on f.fk_soc=s.rowid 
			inner join llx_paiement_facture pf on  pf.fk_facture=f.rowid 
			inner join llx_paiement p on pf.fk_paiement=p.rowid 
			inner join llx_c_paiement ty on ty.id=p.fk_paiement 
								WHERE f.fk_statut =1
								AND f.paye =0
								AND f.date_lim_reglement < CURDATE()
								AND s.entity = $conf->entity
	UNION ALL 
	SELECT 
		f.total_ttc*(-1) as amount,
		f.paye,
    	1 as fac,
		f.date_lim_reglement as date,
		\"0000-00-00\" as dateprel,
		s.rowid as socid,
		s.nom as nom,
		s.date_relance,
		s.relance_lvl,
				s.email,
		s.contact_relance,
		s.relance_total,
							f.rowid,
		s.relance_lvlmax
			FROM `llx_societe` s 
			inner join llx_facture f on f.fk_soc=s.rowid 
								WHERE f.fk_statut =1
								AND f.paye =0
								AND f.total_ttc > 0 
								AND f.date_lim_reglement < CURDATE()
								AND s.entity = $conf->entity
		UNION ALL 
		SELECT 
			f.total_ttc*(-1) as amount,
			1 AS paye,
			3 as fac,
			f.datef as date,
			\"0000-00-00\" as dateprel,
			s.rowid as socid,
			s.nom as nom,
			s.date_relance,
			s.relance_lvl,
					s.email,
			s.contact_relance,
			s.relance_total,
							f.rowid,
		s.relance_lvlmax
				FROM `llx_societe` s 
				inner join llx_facture f on f.fk_soc=s.rowid 
				WHERE f.paye =0
					AND f.fk_statut =1
					AND s.entity = $conf->entity
			AND f.total_ttc < 0 
		UNION ALL 
		SELECT 
			r.amount_ttc as amount,
			1 as paye,
			3 as fac,
			r.datec as date,
			\"0000-00-00\" as dateprel,
			s.rowid as socid,
			s.nom as nom,
			s.date_relance,
			s.relance_lvl,
					s.email,
			s.contact_relance,
			s.relance_total,
							r.rowid,
		s.relance_lvlmax
				FROM `llx_societe` s 
				inner join llx_societe_remise_except r on s.rowid=r.fk_soc
				WHERE r.fk_facture IS NULL
				AND r.fk_facture_line IS NULL
				AND r.fk_facture_source IS NULL
				AND s.entity = $conf->entity
		UNION ALL 
		SELECT 
			r.amount_ttc as amount,
			1 as paye,
			3 as fac,
			r.datec as date,
			\"0000-00-00\" as dateprel,
			s.rowid as socid,
			s.nom as nom,
			s.date_relance,
			s.relance_lvl,
					s.email,
			s.contact_relance,
			s.relance_total,
							r.rowid,
		s.relance_lvlmax
				FROM `llx_societe` s 
				inner join llx_societe_remise_except r on s.rowid=r.fk_soc
				inner join llx_facture f on f.rowid=r.fk_facture_source
				WHERE r.fk_facture IS NULL
				AND r.fk_facture_line IS NULL
				AND s.entity = $conf->entity
		UNION ALL 
		SELECT 
			r.amount_ttc as amount,
			1 as paye,
			3 as fac,
			r.datec as date,
			\"0000-00-00\" as dateprel,
			s.rowid as socid,
			s.nom as nom,
			s.date_relance,
			s.relance_lvl,
					s.email,
			s.contact_relance,
			s.relance_total,
							r.rowid,
		s.relance_lvlmax
				FROM `llx_societe` s 
				inner join llx_facture f on f.fk_soc=s.rowid 
				inner join llx_societe_remise_except r on s.rowid=r.fk_soc
				inner join llx_facture f2 on f2.rowid=r.fk_facture_source
				WHERE f.paye =0
					AND f.fk_statut =1
					AND f.total_ttc>0
				AND f.date_lim_reglement < CURDATE()
					AND r.fk_facture = f.rowid
					AND r.fk_facture_line IS NULL
					AND s.entity = $conf->entity
	) as a
	JOIN (SELECT @csum := 0) b
GROUP BY socid
HAVING nb_non_paye>0
AND retard >0
AND som < 0
ORDER BY nom";

print '<form method=POST action="#" name="sent">'; 

print $langs->trans("RelanceType").'<br/>';
print '<label><input type="radio" name="type_relance" value="0" checked>'.$langs->trans('ODTvisu').'</label><br/>';
print '<label><input type="radio" name="type_relance" value="1" >'.$langs->trans('ODTenvoi').'</label><br/>';
print '<label><input type="radio" name="type_relance" value="2">'.$langs->trans('Mailenvoi').'</label><br/>';
print '<label><input type="radio" name="type_relance" value="3">'.$langs->trans('Mailenvoinonpaye').'</label></p>';

print '<table class="noborder" width="100%">';
	print '<tr class="liste_titre">';
		print '<td>'.$langs->trans("NomTiers").'</td>';
		print '<td>'.$langs->trans("SoldeActu").'</td>';
		print '<td>'.$langs->trans("Fac").'</td>';
		print '<td>'.$langs->trans("Niveau").'</td>';
		print '<td>'.$langs->trans("NiveauMax").'</td>';
		print '<td>'.$langs->trans("NbRelance").'</td>';
		print '<td>'.$langs->trans("DateRelance").'</td>';
		print '<td>'.$langs->trans("Retard").'</td>';
		print '<td>'.$langs->trans("DateDerPaiement").'</td>';
		print '<td width="80px"><img src="'.(file_exists(DOL_DOCUMENT_ROOT.'/relanceTiers')?DOL_URL_ROOT.'/relanceTiers/img/mail.png':DOL_URL_ROOT.'/custom/relanceTiers/img/mail.png').'" height="20px" width="20px" title="Envoi mail relance"/>';
		print 'Sélection';
	if ($conf->use_javascript_ajax) print '</br><a href="#" id="checkall">'.$langs->trans("All").'</a> / <a href="#" id="checknone">'.$langs->trans("None").'</a>';
	print '</td>';
	print '</tr>';
$resql=$db->query($sql);
if ($resql)
{
$client_in_late=array();
	$num = $db->num_rows($resql);
	if ($num)
	{
		$i = 0;
		while ($i < $num)
		{
		 
			$row = $db->fetch_row($resql);
			$client_in_late = array_merge($client_in_late,array($row[8]));
			print '<tr class="level'.$row[2].'">';
				$email='';
				print '<input type="hidden" name="envoi_'.($i+1).'" value="'.$row[8].'">';
				if($row[9]!=0)
					{
						$sqlcontact='SELECT email FROM llx_socpeople WHERE rowid='.$row[9].';';
						$resqlcontact=$db->query($sqlcontact);
						if ($resqlcontact)
						{
							$rowcontact = $db->fetch_row($resqlcontact);
							$email=$rowcontact[0];
						}
					}
					else
					$email = $row[10];
				print '<td><a href="'.(file_exists(DOL_DOCUMENT_ROOT.'/relanceTiers')?DOL_URL_ROOT.'/relanceTiers/societe_fiche.php?socid=':DOL_URL_ROOT.'/custom/relanceTiers/societe_fiche.php?socid=').$row[8].'">'.$row[0].'</a>'.(isEmail($email)?' ( '.$email.' ) ':'<span style="color:red"> '.$langs->trans("(noMail)").'</span>').'</td>';
				print '<td align="right">'.converToDoppleDecimal($row[1]).' '.$conf->currency.'</td>';
				print '<td align="center">'.$row[7].'</td>';
				print '<td align="center">'.$row[2].'</td>';
				print '<td align="center">'.$row[11].'</td>';				
				print '<td align="center">'.$row[3].'</td>';
				
				if($row[4]==null)$str_date4="NC";
				else
				{
					$date4=new DateTime($row[4]);
					if($date4->format('Y') >2099 || $date4->format('Y') < 1980)
					$str_date4="NC";else $str_date4=$date4->format('d/m/Y');
				}
				print '<td>'.$str_date4.'</td>';
				
				if($row[5]<=0)$str_date5=$langs->trans("NoLate");
				else
				{
					$str_date5=$row[5].' '.$langs->trans("jour").'(s)';
				}
				print '<td>'.$str_date5.'</td>';
				
				if($row[6]==null)$str_date6="NC";
				else
				{
					try{
						$date6=new DateTime($row[6]);
						if($date6->format('Y') >2099 || $date6->format('Y') < 1980)
						$str_date6="NC";else $str_date6=$date6->format('d/m/Y');
					}catch(Exception $e){
						$str_date6="Error : ".$e;
					}
				}
				print '<td>'.$str_date6.'</td>';
				
				print '<td align="center"><input class="checkformerge" name="do_'.($i+1).'" type="checkbox"></td>';
				
			print '</tr>';
			$i++;
		}
		
		$late_sql="(";
		for($i=0;$i<count($client_in_late);$i++)
		{
			$late_sql.=$client_in_late[$i].",";
		}
		$late_sql=substr($late_sql,0,strlen($late_sql)-1);
		$late_sql.=")";
		
		$sql_not_late="UPDATE llx_societe SET relance_lvl=1 WHERE rowid NOT IN ".$late_sql." AND entity = $conf->entity";
		$resql_not_late=$db->query($sql_not_late);
	}
}

print '</table>';
print $langs->trans("RetardExplication").'<br/>'.$langs->trans("SoldeExplication").'<br/><br/>';
print '<input type="submit" class="button" value="'.$langs->trans('Relancer').'">';

print '</form>';
}

dol_fiche_end();


$db->close();

llxFooter();
?>
