<?php
/* 
 * Copyright (C) 2013 ethicweb                  <infos@ethicweb.com>
 *
 */

/**
 *	\file      relanceTiers/document.php
 */

 
 // SURCHARGE DE DOCUMENT.PHP POUR LECTURE FICHIER RECAP EN PDF (POUR STABILITE)
 
define('NOTOKENRENEWAL',1); // Disables token renewal
if (! defined('NOREQUIREMENU')) define('NOREQUIREMENU','1');
if (! defined('NOREQUIREHTML')) define('NOREQUIREHTML','1');
if (! defined('NOREQUIREAJAX')) define('NOREQUIREAJAX','1');

/**
 * Header empty
 *
 * @return	void
 */
function llxHeader() { }
/**
 * Footer empty
 *
 * @return	void
 */
function llxFooter() { }

global $user;
// Dolibarr environment
$res = @include("../main.inc.php"); // From htdocs directory
if (! $res) {
    $res = @include("../../main.inc.php"); // From "custom" directory
}
require_once 'lib/files.lib.php';

$encoding = '';
$action=GETPOST('action','alpha');
$original_file=GETPOST('file','alpha');	// Do not use urldecode here ($_GET are already decoded by PHP).
$modulepart=GETPOST('modulepart','alpha');
$urlsource=GETPOST('urlsource','alpha');
$entity=GETPOST('entity')?GETPOST('entity','int'):$conf->entity;

// Security check
if (empty($modulepart)) accessforbidden('Bad value for parameter modulepart');

// Suppression de la chaine de caractere ../ dans $original_file
$original_file = str_replace("../","/", $original_file);

// Find the subdirectory name as the reference
$refname=basename(dirname($original_file)."/");
// Security check
if (empty($modulepart)) accessforbidden('Bad value for parameter modulepart');

// Security:
// Limite acces si droits non corrects


	if (! is_object($fuser)) $fuser=$user;

	if (empty($modulepart)) return 'ErrorBadParameter';
if (! ($fuser->rights->facture->lire ||$fuser->admin))
{
	accessforbidden();
}

// Security:
// On interdit les remontees de repertoire ainsi que les pipe dans
// les noms de fichiers.
if (preg_match('/\.\./',$original_file) || preg_match('/[<>|]/',$original_file))
{
	dol_syslog("Refused to deliver file ".$original_file);
	$file=basename($original_file);		// Do no show plain path of original_file in shown error message
	dol_print_error(0,$langs->trans("ErrorFileNameInvalid",$file));
	exit;
}

clearstatcache();

$filename = basename($original_file);
$id=str_replace(array('.pdf','.txt'),'',$original_file);
if($modulepart=='relanceODT') {
	$original_file=DOL_DATA_ROOT.'/relanceTiers/receipts/odt/'.$original_file;
}
else if($modulepart=='relanceArchives'){
	$id = explode('_', $id);
	$id = $id[count($id)-1];
	$original_file=DOL_DATA_ROOT.'/relanceTiers/temp/'.$id.'/'.$original_file;
}
else {
	$original_file=DOL_DATA_ROOT."/relanceTiers/receipts/".$id.'/'.$original_file;
}



	// Output file on browser
	dol_syslog("document.php download $original_file $filename content-type=$type");
	$original_file_osencoded=dol_osencode($original_file);	// New file name encoded in OS encoding charset
	// This test if file exists should be useless. We keep it to find bug more easily

	if (! file_exists($original_file_osencoded))
	{
		dol_print_error(0,$langs->trans("ErrorFileDoesNotExists",$original_file));
		exit;
	}
	// Les drois sont ok et fichier trouve, on l'envoie

	header('Content-Description: File Transfer');
	if ($encoding)   header('Content-Encoding: '.$encoding);
	if ($type)       header('Content-Type: '.$type.(preg_match('/text/',$type)?'; charset="'.$conf->file->character_set_client:''));
	// Add MIME Content-Disposition from RFC 2183 (inline=automatically displayed, atachment=need user action to open)
	header('Content-Disposition: attachment; filename="'.$filename.'"');
	header('Content-Length: ' . dol_filesize($original_file_osencoded));
	// Ajout directives pour resoudre bug IE
	header('Cache-Control: Public, must-revalidate');
	header('Pragma: public');
	
	readfile($original_file_osencoded);


?>