<?php
/* Copyright (C) 2003-2005 Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2011 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2004      Eric Seigne          <eric.seigne@ryxeo.com>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 * Copyright (C) 2013 ethicweb
 *
 */

/**
 *	\file       relanceTiers/core/module/relanceTiers/modules_relanceTiers.php
 */

require_once DOL_DOCUMENT_ROOT.'/core/class/commondocgenerator.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';   // Requis car utilise dans les classes qui heritent


/**
 *	Parent class of invoice document generators
 */
 if (!class_exists('ModeleRelanceTiers')) {
	abstract class ModeleRelanceTiers extends CommonDocGenerator
	{
		var $error='';

		/**
		 *  Return list of active generation modules
		 *
		 *  @param	DoliDB	$db     			Database handler
		 *  @param  string	$maxfilenamelength  Max length of value to show
		 *  @return	array						List of templates
		 */
		static function liste_modeles($db,$maxfilenamelength=0)
		{
			global $conf;

			$liste=array("crabe");

			return $liste;
		}
	}
}



/**
 *  Create a document onto disk according to template module.
 *
 *	@param	DoliDB		$db  			Database handler
 *	@param  Object		$object			Object invoice
 *	@param	string		$modele			Force template to use ('' to not force)
 *	@param	Translate	$outputlangs	objet lang a utiliser pour traduction
 *  @param  int			$hidedetails    Hide details of lines
 *  @param  int			$hidedesc       Hide description
 *  @param  int			$hideref        Hide ref
 *  @param  int			$nonpaye        1 pour non paye 
 *	@return int        					<0 if KO, >0 if OK
 */
 if (!function_exists('relanceTiers_pdf_create')) {
	function relanceTiers_pdf_create($db, $object, $modele, $outputlangs, $hidedetails=0, $hidedesc=0, $hideref=0, $nonpaye = 0)
	{
		global $conf,$user,$langs;
		$langs->load("relanceTiers@relanceTiers");

		$error=0;
		// Increase limit for PDF build
		@set_time_limit(120);

		$srctemplatepath='';

		// Positionne le modele sur le nom du modele a utiliser
		if (! dol_strlen($modele))
		{
			if (! empty($conf->global->PRELEVEMENTSEPA_ADDON_PDF))
			{
				$modele = $conf->global->PRELEVEMENTSEPA_ADDON_PDF;
			}
			else
			{
				$modele = 'crabe';
			}
		}

		// If selected modele is a filename template (then $modele="modelname:filename")
		$tmp=explode(':',$modele,2);
		if (! empty($tmp[1]))
		{
			$modele=$tmp[0];
			$srctemplatepath=$tmp[1];
		}

		// Search template files
		$file=''; $classname=''; $filefound=0;
		$dirmodels=array('/');
		if (is_array($conf->modules_parts['models'])) $dirmodels=array_merge($dirmodels,$conf->modules_parts['models']);
		
		$file=dol_buildpath('/relanceTiers/core/modules/relanceTiers/doc/pdf_crabe.modules.php');
		if (file_exists($file))
		{
					$filefound=1;
					$classname='pdf_crabe';
		}

		// Charge le modele
		if ($filefound)
		{
			require_once $file;
			$obj = new $classname($db);
			// We save charset_output to restore it because write_file can change it if needed for
			// output format that does not support UTF8.
			$sav_charset_output=$outputlangs->charset_output;
				
			if ( $obj->write_file($object, $outputlangs, $srctemplatepath, $hidedetails, $hidedesc, $hideref, $nonpaye) > 0)
			{
				$outputlangs->charset_output=$sav_charset_output;

				// We delete old preview
				require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
				//dol_delete_preview($object);/////////////////////////////////////////////

				// Success in building document. We build meta file.
				dol_meta_create($object);

				// Appel des triggers
				include_once DOL_DOCUMENT_ROOT . '/core/class/interfaces.class.php';
				$interface=new Interfaces($db);
				$result=$interface->run_triggers('BILL_BUILDDOC',$object,$user,$langs,$conf);
				if ($result < 0) { $error++; $this->errors=$interface->errors; }
				// Fin appel triggers

				return 1;
			}
			else
			{
				$outputlangs->charset_output=$sav_charset_output;
				dol_print_error($db,"relanceTiers_pdf_create Error: ".$obj->error);
				return -1;
			}

		}
		else
		{
			dol_print_error('',$langs->trans("Error")." ".$langs->trans("ErrorFileDoesNotExists",$file));
			return -1;
		}
	}
}

/**
 *  Create a document onto disk according to template module.
 *
 *	@param	DoliDB		$db  			Database handler
 *	@param  Object		$object			Object invoice
 *	@param	string		$modele			Force template to use ('' to not force)
 *	@param	Translate	$outputlangs	objet lang a utiliser pour traduction
 *  @param  int			$hidedetails    Hide details of lines
 *  @param  int			$hidedesc       Hide description
 *  @param  int			$hideref        Hide ref
 *	@return int        					<0 if KO, >0 if OK
 */
 if (!function_exists('relanceTiers_pdf_createarchive')) {
	function relanceTiers_pdf_createarchive($db, $object, $modele, $outputlangs, $hidedetails=0, $hidedesc=0, $hideref=0)
	{
		global $conf,$user,$langs;
		$langs->load("relanceTiers@relanceTiers");

		$error=0;
		// Increase limit for PDF build
		@set_time_limit(120);

		$srctemplatepath='';

		// Positionne le modele sur le nom du modele a utiliser
		if (! dol_strlen($modele))
		{
			$modele = 'relanceArchive';
		}

		// If selected modele is a filename template (then $modele="modelname:filename")
		$tmp=explode(':',$modele,2);
		if (! empty($tmp[1]))
		{
			$modele=$tmp[0];
			$srctemplatepath=$tmp[1];
		}

		// Search template files
		$file=''; $classname=''; $filefound=0;
		$dirmodels=array('/');
		if (is_array($conf->modules_parts['models'])) $dirmodels=array_merge($dirmodels,$conf->modules_parts['models']);
		
		$file=dol_buildpath('/relanceTiers/core/modules/relanceTiers/doc/pdf_relanceArchive.modules.php');
		if (file_exists($file))
		{
					$filefound=1;
					$classname='pdf_relanceArchive';
		}

		// Charge le modele
		if ($filefound)
		{
			require_once $file;
			$obj = new $classname($db);
			// We save charset_output to restore it because write_file can change it if needed for
			// output format that does not support UTF8.
			$sav_charset_output=$outputlangs->charset_output;
			if ($obj->write_file($object, $outputlangs, $srctemplatepath, $hidedetails, $hidedesc, $hideref) > 0)
			{
				$outputlangs->charset_output=$sav_charset_output;

				// We delete old preview
				require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
				//dol_delete_preview($object);/////////////////////////////////////////////

				// Success in building document. We build meta file.
				dol_meta_create($object);

				// Appel des triggers
				include_once DOL_DOCUMENT_ROOT . '/core/class/interfaces.class.php';
				$interface=new Interfaces($db);
				$result=$interface->run_triggers('BILL_BUILDDOC',$object,$user,$langs,$conf);
				if ($result < 0) { $error++; $this->errors=$interface->errors; }
				// Fin appel triggers

				return 1;
			}
			else
			{
				$outputlangs->charset_output=$sav_charset_output;
				dol_print_error($db,"relanceTiers_pdf_create Error: ".$obj->error);
				return -1;
			}

		}
		else
		{
			dol_print_error('',$langs->trans("Error")." ".$langs->trans("ErrorFileDoesNotExists",$file));
			return -1;
		}

	}
}
?>