<?php
/* Copyright (C) 2004-2012	Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012	Regis Houssin		<regis.houssin@capnetworks.com>
 * Copyright (C) 2008		Raphael Bertrand	<raphael.bertrand@resultic.fr>
 * Copyright (C) 2010-2012	Juanjo Menent		<jmenent@2byte.es>
 * Copyright (C) 2012      	Christophe Battarel <christophe.battarel@altairis.fr>
 * Copyright (C) 2013 ethicweb                  <infos@ethicweb.com>
 */

/**
 *	\file       relanceTiers/core/module/relanceTiers/doc/pdf_crabe.modules.php
 */
if(file_exists(DOL_DOCUMENT_ROOT."/custom/relanceTiers"))
require_once DOL_DOCUMENT_ROOT.'/custom/relanceTiers/core/modules/relanceTiers/modules_relanceTiers.php';
else
require_once DOL_DOCUMENT_ROOT.'/relanceTiers/core/modules/relanceTiers/modules_relanceTiers.php';

require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';


 function text_decode($text){
		return html_entity_decode($text, ENT_QUOTES, 'UTF-8');
	}
	
function strcouper($str,$pos){
	if ( strlen($str)>$pos)
	{
		$str=substr($str,0,$pos);
		$pos=strrpos($str," ");
		$pos2=strrpos($str,"-");
		if($pos2>$pos)$pos=$pos2+1;
		$str=substr($str,0,$pos);
	
		return $str;
	}
	else return $str;
}
	
	
	
/**
 *	Class to manage PDF invoice template Crabe
 */
class pdf_relanceArchive extends ModeleRelanceTiers
{
    var $db;
    var $name;
    var $description;
    var $type;

    var $phpmin = array(4,3,0); // Minimum version of PHP required by module
    var $version = 'dolibarr';

    var $page_largeur;
    var $page_hauteur;
    var $format;
	var $marge_gauche;
	var	$marge_droite;
	var	$marge_haute;
	var	$marge_basse;

	var $emetteur;	// Objet societe qui emet

	/**
	 *	Constructor
	 *
	 *  @param		DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
		global $conf,$langs,$mysoc;

		$langs->load("relanceTiers@relanceTiers");

		$this->db = $db;
		$this->name = "relanceArchive";
		$this->description = $langs->trans('PDFCrabeDescription');

		// Dimension page pour format A4
		$this->type = 'pdf';
		$formatarray=pdf_getFormat();
		$this->page_largeur = $formatarray['width'];
		$this->page_hauteur = $formatarray['height'];
		$this->format = array($this->page_largeur,$this->page_hauteur);
		$this->marge_gauche=isset($conf->global->MAIN_PDF_MARGIN_LEFT)?$conf->global->MAIN_PDF_MARGIN_LEFT:10;
		$this->marge_droite=isset($conf->global->MAIN_PDF_MARGIN_RIGHT)?$conf->global->MAIN_PDF_MARGIN_RIGHT:10;
		$this->marge_haute =isset($conf->global->MAIN_PDF_MARGIN_TOP)?$conf->global->MAIN_PDF_MARGIN_TOP:10;
		$this->marge_basse =isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)?$conf->global->MAIN_PDF_MARGIN_BOTTOM:10;

		$this->option_logo = 1;                    // Affiche logo
		$this->option_tva = 1;                     // Gere option tva FACTURE_TVAOPTION
		$this->option_modereg = 1;                 // Affiche mode reglement
		$this->option_condreg = 1;                 // Affiche conditions reglement
		$this->option_codeproduitservice = 1;      // Affiche code produit-service
		$this->option_multilang = 1;               // Dispo en plusieurs langues
		$this->option_escompte = 1;                // Affiche si il y a eu escompte
		$this->option_credit_note = 1;             // Support credit notes
		$this->option_freetext = 1;				   // Support add of a personalised text
		$this->option_draft_watermark = 1;		   // Support add of a watermark on drafts

		$this->franchise=!$mysoc->tva_assuj;

		// Get source company
		$this->emetteur=$mysoc;
		if (empty($this->emetteur->country_code)) $this->emetteur->country_code=substr($langs->defaultlang,-2);    // By default, if was not defined

		// Define position of columns
		$this->posxdesc=$this->marge_gauche+1;
		$this->posxtva=111;
		$this->posxup=126;
		$this->posxqty=145;
		$this->posxdiscount=162;
		$this->postotalht=174;
		if ($this->page_largeur < 210) // To work with US executive format
		{
			$this->posxtva-=20;
			$this->posxup-=20;
			$this->posxqty-=20;
			$this->posxdiscount-=20;
			$this->postotalht-=20;
		}

		$this->tva=array();
		$this->localtax1=array();
		$this->localtax2=array();
		$this->atleastoneratenotnull=0;
		$this->atleastonediscount=0;
		
	}
	
	function converToDoppleDecimal($var){
	if(strpos($var,".")===FALSE)return $var.".00";
	else if(strlen($var) - strpos($var,".") == 2)
	return $var."0";
	else if(strlen($var) - strpos($var,".") == 1)
	return $var."00";
	else return substr($var,0,strpos($var,'.')+3);
	
	}
	


	/**
     *  Function to build pdf onto disk
     *
     *  @param		Object		$object				Object to generate
     *  @param		Translate	$outputlangs		Lang output object
     *  @param		string		$srctemplatepath	Full path of source filename for generator using a template file
     *  @param		int			$hidedetails		Do not show line details
     *  @param		int			$hidedesc			Do not show desc
     *  @param		int			$hideref			Do not show ref
     *  @return     int         	    			1=OK, 0=KO
	 */
	

	function write_file($object,$outputlangs,$srctemplatepath='',$hidedetails=0,$hidedesc=0,$hideref=0)
	{
		global $user,$langs,$conf,$mysoc,$db,$hookmanager;
		if (! is_object($outputlangs)) $outputlangs=$langs;
		// For backward compatibility with FPDF, force output charset to ISO, because FPDF expect text to be encoded in ISO
		if (! empty($conf->global->MAIN_USE_FPDF)) $outputlangs->charset_output='ISO-8859-1';

		//$outputlangs->load("pdfRelanceTiers@relanceTiers");
		$outputlangs->load("payment");
		$outputlangs->load("bank");
		$outputlangs->load("invoice");
		$outputlangs->load("withdrawals");
		if ($conf)
		{

			$objectref = dol_sanitizeFileName($object->id);
			$dir = DOL_DATA_ROOT."/relanceTiers/temp/".$object->id;
			$file = $dir . "/relance_archive_" . $objectref . ".pdf";
			if (! file_exists($dir))
			{
				if (dol_mkdir($dir) < 0)
				{
					$this->error=$langs->transnoentities("ErrorCanNotCreateDir",$dir);
					return 0;
				}
			}
			if (file_exists($dir))
			{
				$sql = "SELECT count(*), s.nom 
						FROM ".MAIN_DB_PREFIX."relance_archive as t
						INNER JOIN ".MAIN_DB_PREFIX."societe s ON s.rowid = t.fk_soc
 						WHERE t.fk_soc='".$object->id."'";

				$resql=$this->db->query($sql);
				if ($resql)
				{
					$row = $this->db->fetch_row($resql);
					$nblignes = $row[0];
					$cli_nom= $row[1];
				}
				

                $pdf=pdf_getInstance($this->format);
				$heightforinfotot = 50;	// Height reserved to output the info and total part
		        $heightforfreetext= (isset($conf->global->MAIN_PDF_FREETEXT_HEIGHT)?$conf->global->MAIN_PDF_FREETEXT_HEIGHT:5);	// Height reserved to output the free text on last page
                $pdf->SetAutoPageBreak(1,0);


                // Set path to the background PDF File
                if (empty($conf->global->MAIN_DISABLE_FPDI) && ! empty($conf->global->MAIN_ADD_PDF_BACKGROUND))
                {
				    $pagecount = $pdf->setSourceFile($conf->mycompany->dir_output.'/'.$conf->global->MAIN_ADD_PDF_BACKGROUND);
				    $tplidx = $pdf->importPage(1);
                }

				$pdf->Open();
				$pagenb=0;
				$pdf->SetDrawColor(128,128,128);

				$pdf->SetTitle($outputlangs->convToOutputCharset($object->id));
				$pdf->SetSubject($outputlangs->transnoentities("Invoice"));
				$pdf->SetCreator("Dolibarr ".DOL_VERSION);
				$pdf->SetAuthor($outputlangs->convToOutputCharset($user->getFullName($outputlangs)));
				$pdf->SetKeyWords($outputlangs->convToOutputCharset($object->id)." ".$outputlangs->transnoentities("Invoice"));
				if (! empty($conf->global->MAIN_DISABLE_PDF_COMPRESSION)) $pdf->SetCompression(false);

				$pdf->SetMargins($this->marge_gauche, $this->marge_haute, $this->marge_droite);   // Left, Top, Right
				

				
				
				
				// New page
				$pdf->AddPage();
				if (! empty($tplidx)) $pdf->useTemplate($tplidx);
				$pagenb++;
//avoir
				$pdf->SetFont('','', 8);
				$pdf->MultiCell(0, 3, '');		// Set interline to 3
				$pdf->SetTextColor(0,0,0);
				if(file_exists(DOL_DATA_ROOT.'/mycompany/logos/'.$conf->global->MAIN_INFO_SOCIETE_LOGO))$pdf->Image(DOL_DATA_ROOT.'/mycompany/logos/'.$conf->global->MAIN_INFO_SOCIETE_LOGO, 10, 5);

				$tab_top = 70;
				$tab_height = 110;
				$tab_height_newpage = 150;

				
				$this->_print_head($pdf, $cli_nom, $outputlangs);
				$this->_print_first_head_total($pdf, $cli_nom, $outputlangs);

				$iniY = $tab_top + 7;
				$curY = $tab_top + 7;
				$nexY = $tab_top + 7;
				
				$nbDePage=$nblignes/50;   
				$nbDePage=ceil($nbDePage);
				
				$pdf->SetFillColor(255,255,255);
				$this->_print_page($pdf, $pagenb, $nbDePage);

				
				$saut_page=0;
				
				
				$diffX=Array($this->marge_gauche,$this->marge_gauche+30,$this->marge_gauche+60,$this->marge_gauche+110);

				// Loop on each lines
				$sql = "SELECT";
				$sql.= " t.rowid,";
				$sql.= " t.fk_soc,";
				$sql.= " t.date_relance,";
				$sql.= " t.type_relance,";
				$sql.= " t.niveau_relance,";
				$sql.= " t.description";


				$sql.= " FROM ".MAIN_DB_PREFIX."relance_archive as t";
				$sql.= " WHERE t.fk_soc='".$object->id."'";

				$resql=$this->db->query($sql);
				if ($resql)
				{
					$num = $this->db->num_rows($resql);
					if ($num)
					{
						$i = 0;
						$nb=0;
						while ($i < $num)
						{
							$writte=true;
							$row = $this->db->fetch_row($resql);
								
							if($writte){
								$maxlines = max($pdf->getNumLines(html_entity_decode($row[3]), 50),$pdf->getNumLines($row[5],80));

								if(($curY + 4*$maxlines - $tab_top) > 200 ){
									$curY = $tab_top + 7;
								
									// Show square
									$this->_tableau($pdf, $tab_top, 200, 0, $outputlangs, 0, 0);
									$bottomlasttab=$this->page_hauteur - $heightforinfotot - $heightforfreetext - $heightforfooter + 1;
					
									// New page
									$saut_page=0;
									$pdf->AddPage();
									if (! empty($tplidx)) $pdf->useTemplate($tplidx);
									$pagenb++;

									$pdf->SetFont('','', 8);
									$pdf->MultiCell(0, 3, '');		// Set interline to 3
									$pdf->SetTextColor(0,0,0);
									if(file_exists(DOL_DATA_ROOT.'/mycompany/logos/'.$conf->global->MAIN_INFO_SOCIETE_LOGO))$pdf->Image(DOL_DATA_ROOT.'/mycompany/logos/'.$conf->global->MAIN_INFO_SOCIETE_LOGO, 10, 5);
									$tab_top = 70;
									$tab_height = 110;
									

									$iniY = $tab_top + 7;
									$curY = $tab_top + 7;
									$nexY = $tab_top + 7;
									$this->_print_page($pdf, $pagenb, $nbDePage);
									
									$this->_print_head($pdf, $cli_nom, $outputlangs);
									$this->_print_first_head_total($pdf, $cli_nom, $outputlangs);
								}
								
								if($saut_page%2==0)
									$pdf->SetFillColor(200,200,200);
								
								$date=new DateTime($row[2]);
								
								$pdf->SetXY($diffX[0], $curY);
								$pdf->MultiCell(30,4*$maxlines, $date->format('d/m/Y'),'','L',true);
								
								$pdf->SetXY($diffX[1], $curY);
								$pdf->MultiCell(30,4*$maxlines, $row[4],'','C',true);

								$pdf->SetXY($diffX[2], $curY);								
								$pdf->MultiCell(50,4*$maxlines, html_entity_decode($row[3]),'','C',true);															
								
								$pdf->SetXY($diffX[3], $curY);
								$pdf->MultiCell(80,4*$maxlines, $row[5],'','L',true);								
															
								$iniY += 4*$maxlines;
								$curY += 4*$maxlines;
								$nexY += 4*$maxlines;
								
								$saut_page++;								
							}
							
							$pdf->SetFillColor(255,255,255);
							$i++;
							
						}
					}
					
				}

				// Show square
					$this->_tableau($pdf, $tab_top, 200, 0, $outputlangs, 0, 0);
					$bottomlasttab=$this->page_hauteur - $heightforinfotot - $heightforfreetext - $heightforfooter + 1;




				// Pied de page
				//$this->_pagefoot($pdf,$object,$outputlangs);
				//if (method_exists($pdf,'AliasNbPages')) $pdf->AliasNbPages();

				$pdf->Close();

				$pdf->Output($file,'F');

				// Add pdfgeneration hook
				if (! is_object($hookmanager))
				{
					include_once DOL_DOCUMENT_ROOT.'/core/class/hookmanager.class.php';
					$hookmanager=new HookManager($this->db);
				}
				$hookmanager->initHooks(array('pdfgeneration'));
				$parameters=array('file'=>$file,'object'=>$object,'outputlangs'=>$outputlangs);
				global $action;
				$reshook=$hookmanager->executeHooks('afterPDFCreation',$parameters,$this,$action);    // Note that $action and $object may have been modified by some hooks

				if (! empty($conf->global->MAIN_UMASK))
				@chmod($file, octdec($conf->global->MAIN_UMASK));

				return 1;   // Pas d'erreur
			}
			else
			{
				$this->error=$langs->trans("ErrorCanNotCreateDir",$dir);
				return 0;
			}
		}
		else
		{
			$this->error=$langs->trans("ErrorConstantNotDefined","FAC_OUTPUTDIR");
			return 0;
		}
		$this->error=$langs->trans("ErrorUnknown");
		return 0;   // Erreur par defaut
	}





function _print_page(&$pdf, $num_page, $total_page)
	{
		global $conf;

			$pdf->SetXY(180, 270);
			$pdf->MultiCell(30,1, "Page : ".$pdf->getAliasNumPage().'/'.$pdf->getAliasNbPages(),'','L');
	}

function _print_head(&$pdf,$cli_nom, $outputlangs)
	{
		global $conf;
			if (! empty($conf->global->ADRESSE_RELANCE_MAIL)) $socname = $conf->global->ADRESSE_RELANCE_MAIL;
			$pdf->SetXY(10, 10);
			$pdf->MultiCell(190,1, $conf->global->ADRESSE_RELANCE_MAIL,'','R');
			
			
	}
	
function _print_first_head_total(&$pdf, $client,$outputlangs,$hidetop=0, $hidebottom=0)
	{
		global $conf;

			$pdf->SetXY(15, 53);
			$pdf->MultiCell(170,1, text_decode($outputlangs->trans("Client")).' '.$client,'','L');						
			
			$pdf->SetXY(15, 40);
			$pdf->MultiCell(180,1, text_decode($outputlangs->trans("HistoriqueDesRelances")),'','C');
			
		$this->printRect($pdf,$this->marge_gauche,50, $this->page_largeur-$this->marge_gauche-$this->marge_droite, 15, $hidetop, $hidebottom);	// Rect prend une longueur en 3eme param et 4eme param

	}
	/*
	/**
	 *   Show table for lines
	 *
	 *   @param		PDF			&$pdf     		Object PDF
	 *   @param		string		$tab_top		Top position of table
	 *   @param		string		$tab_height		Height of table (rectangle)
	 *   @param		int			$nexY			Y (not used)
	 *   @param		Translate	$outputlangs	Langs object
	 *   @param		int			$hidetop		1=Hide top bar of array and title, 0=Hide nothing, -1=Hide only title
	 *   @param		int			$hidebottom		Hide bottom bar of array
	 *   @return	void
	 */
	function _tableau(&$pdf, $tab_top, $tab_height, $nexY, $outputlangs, $hidetop=0, $hidebottom=0)
	{
		global $conf;

		// Force to disable hidetop and hidebottom
		$hidebottom=0;
		if ($hidetop) $hidetop=-1;

		$default_font_size = pdf_getPDFFontSize($outputlangs);

		// Amount in (at tab_top - 1)
		$pdf->SetTextColor(0,0,0);
		$pdf->SetFont('','', $default_font_size - 2);

		if (empty($hidetop))
		{			

			//$conf->global->MAIN_PDF_TITLE_BACKGROUND_COLOR='230,230,230';
			if (! empty($conf->global->MAIN_PDF_TITLE_BACKGROUND_COLOR)) $pdf->Rect($this->marge_gauche, $tab_top, $this->page_largeur-$this->marge_droite-$this->marge_gauche, 5, 'F', null, explode(',',$conf->global->MAIN_PDF_TITLE_BACKGROUND_COLOR));
		}

		$pdf->SetDrawColor(128,128,128);
		$pdf->SetFont('','', $default_font_size - 3);

		// Output Rect
		$this->printRect($pdf,$this->marge_gauche, $tab_top, $this->page_largeur-$this->marge_gauche-$this->marge_droite, $tab_height, $hidetop, $hidebottom);	// Rect prend une longueur en 3eme param et 4eme param

		if (empty($hidetop))      /// CREATION DU TABLEAU VIDE ICI
		{
			$avancee=0;
		
			$pdf->line($this->marge_gauche, $tab_top+5, $this->page_largeur-$this->marge_droite, $tab_top+5);	// line prend une position y en 2eme param et 4eme param
			$pdf->SetXY($this->posxdesc-1, $tab_top+1);
			$pdf->MultiCell(30,2, text_decode($outputlangs->trans("Date")),'','C');
			$avancee+=30;

			$pdf->line($this->marge_gauche+$avancee, $tab_top,$this->marge_gauche+$avancee, $tab_top + $tab_height);
			$pdf->SetXY($this->marge_gauche+$avancee, $tab_top+1);
			$pdf->MultiCell(30,2, text_decode($outputlangs->trans("NiveauRelance")),'','C');
			$avancee+=30;
			
			$pdf->line($this->marge_gauche+$avancee, $tab_top,$this->marge_gauche+$avancee, $tab_top + $tab_height);
			$pdf->SetXY($this->marge_gauche+$avancee, $tab_top+1);
			$pdf->MultiCell(50,2, text_decode($outputlangs->trans("TypeRelance")),'','C');
			$avancee+=50;
			
			
			$pdf->line($this->marge_gauche+$avancee, $tab_top,$this->marge_gauche+$avancee, $tab_top + $tab_height);
			$pdf->SetXY($this->marge_gauche+$avancee, $tab_top+1);
			$pdf->MultiCell(80,2, text_decode($outputlangs->trans("Description")),'','L');
			$avancee+=80;
		}

	}


	/**
	 *   	Show footer of page. Need this->emetteur object
     *
	 *   	@param	PDF			&$pdf     			PDF
	 * 		@param	Object		$object				Object to show
	 *      @param	Translate	$outputlangs		Object lang for output
	 *      @param	int			$hidefreetext		1=Hide free text
	 *      @return	int								Return height of bottom margin including footer text
	 */
	function _pagefoot(&$pdf,$object,$outputlangs,$hidefreetext=0)
	{
		return pdf_pagefoot($pdf,$outputlangs,'FACTURE_FREE_TEXT',$this->emetteur,$this->marge_basse,$this->marge_gauche,$this->page_hauteur,$object,0,$hidefreetext);
	}

}

?>
