<?php
/* 
 * Copyright (C) 2013 ethicweb                  <infos@ethicweb.com>
 *
 */

/**
 *	\file       	htdocs/relanceTiers/core/modules/modRelanceTiers.class.php
 */

include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';
// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";


/**
 *	Classe de description et activation du module Prelevement
 */
class modRelanceTiers extends DolibarrModules
{

	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
		global $conf,$langs;

		$this->db = $db;
		$langs->load("relanceTiers@relanceTiers");
		$this->dir_output = "relanceTiers/receipts";

		$this->numero = 58972;

		$this->family = "financial";
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i','',get_class($this));
		$this->description = $langs->trans("GestionRelanceReleve");

		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = '1.0.7 (Pour dolibarr 3.4.0 à 7.0.1)';

		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		$this->special = 0;
		
		
		
		
		// Name of png file (without png) used for this module
		$this->picto='invoice';

		// Data directories to create when module is enabled
		$this->dirs = array("/relanceTiers/temp","/relanceTiers/receipts");

		// Dependancies
		$this->depends = array("modFacture","modBanque");
		$this->requiredby = array();

		// Config pages
		
if(file_exists(DOL_DOCUMENT_ROOT."/custom/relanceTiers"))
		$this->config_page_url = array(DOL_URL_ROOT."/custom/relanceTiers/admin/admin_relanceTiers.php");
else
		$this->config_page_url = array(DOL_URL_ROOT."/relanceTiers/admin/admin_relanceTiers.php");

		// Constantes
		$this->const = array();

		// Boites
		$this->boxes = array();
		
		//onglet externe
		$this->tabs = array(
			'thirdparty:+tiers_recap_invoice:RecapPaiements:relanceTiers@relanceTiers:1:/relanceTiers/societe_fiche.php?socid=__ID__',
			'thirdparty:+tiers_recap_archives:RelanceArchives:relanceTiers@relanceTiers:1:/relanceTiers/archive_fiche.php?socid=__ID__'
		);   // To add a new tab identified by code tabname1
	
		// Permissions
		//------------
		$this->rights = array();
		$this->rights_class = 'relanceTiers';
		
		$r=0;
		$this->rights[$r][0] = 30001;
		$this->rights[$r][1] = 'Relancer';
		$this->rights[$r][2] = 'r';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'lire';


		// Main menu entries
		$this->menu = array();
		$r=0;
		 
		// Add here entries to declare new menus
		// Example to declare the Top Menu entry:
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=billing',			// Put 0 if this is a top menu
					'type'=>'left',			// This is a Top menu entry
					'titre'=>'RelanceTiers',
					'mainmenu'=>'billing',
					'leftmenu'=>'RelanceTiers',
					'url'=>'/relanceTiers/relance_tiers.php',
					'langs'=>'relanceTiers@relanceTiers',	// Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
					'position'=>100,
					'enabled'=>'1',			// Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
					'perms'=>'1',			// Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
					'target'=>'',
					'user'=>2);				// 0=Menu for internal users, 1=external users, 2=both
		$r++;

		$this->module_parts = array('css' => array('/relanceTiers/css/relanceTiers.css'));
 
 				
		dolibarr_set_const($db,"MAIN_MODULE_RELANCETIERS_DIR", json_encode(array('output' => $this->dir_output)), 'chaine',0,'',$conf->entity);

	}


	/**
	 *		Function called when module is enabled.
	 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *		It also creates data directories
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function init()
	{
		global $conf;
		// Permissions
		$this->remove($options);
                
		$sql = array();

		$this->load_tables();	   
			   
		return $this->_init($sql);
	}

    /**
	 *		Function called when module is disabled.
	 *      Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
     */
    function remove($options='')
    {
		$sql = array();

		return $this->_remove($sql,$options);
    }
	
	function load_tables()
	{
		return $this->_load_tables('/relanceTiers/sql/');
	}
    
   
 
    


}
?>
