<?php
/* Copyright (C) 2003-2005 Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2011 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2004      Eric Seigne          <eric.seigne@ryxeo.com>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *	\file       htdocs/core/modules/facture/modules_facture.php
 *	\ingroup    facture
 *	\brief      Fichier contenant la classe mere de generation des factures en PDF
 * 				et la classe mere de numerotation des factures
 */

require_once DOL_DOCUMENT_ROOT.'/core/class/commondocgenerator.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';   // Requis car utilise dans les classes qui heritent




/**
 *  Create a document onto disk according to template module.
 *
 *	@param	DoliDB		$db  			Database handler
 *	@param  Object		$object			Object invoice
 *	@param	string		$modele			Force template to use ('' to not force)
 *	@param	Translate	$outputlangs	objet lang a utiliser pour traduction
 *  @param  int			$hidedetails    Hide details of lines
 *  @param  int			$hidedesc       Hide description
 *  @param  int			$hideref        Hide ref
 *	@return int        					<0 if KO, >0 if OK
 */
function courrierRelance_pdf_create($db, $object, $modele, $outputlangs, $hidedetails=0, $hidedesc=0, $hideref=0)
{
	global $conf,$user,$langs;

	$error=0;

	// Increase limit for PDF build
    $err=error_reporting();
    error_reporting(0);
    @set_time_limit(120);
    error_reporting($err);

    $srctemplatepath='';

	
    $modele='generic_invoice_odt';
    $srctemplatepath=dol_buildpath('/relanceTiers/tpl/template_courrier.odt');

	// Search template files
	$file=dol_buildpath('/relanceTiers/core/modules/courrier/doc/doc_generic_courrier_odt.modules.php');
	$classname = 'doc_generic_courrier_odt';

	// Charge le modele
	require_once $file;

	$obj = new $classname($db);

	// We save charset_output to restore it because write_file can change it if needed for
	// output format that does not support UTF8.
	$sav_charset_output=$outputlangs->charset_output;
	if ($obj->write_file($object, $outputlangs, $srctemplatepath, $hidedetails, $hidedesc, $hideref) > 0)
	{
		$outputlangs->charset_output=$sav_charset_output;

		// Success in building document. We build meta file.
		dol_meta_create($object);
		return 1;
	}
	else
	{
		$outputlangs->charset_output=$sav_charset_output;
		dol_print_error($db,"courrier_odt_create Error: ".$obj->error);
		return -1;
	}
}

?>