<?php
/*
 * Copyright (C) 2013 ethicweb
 *
 */

/**
 *         \file                admin/prelevement_SEPA.php
 *         \ingroup        		prelevement_SEPA
 */
 
// Dolibarr environment
$res = @include("../../main.inc.php"); // From htdocs directory
if (! $res) {
    $res = @include("../../../main.inc.php"); // From "custom" directory
}


require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';


$langs->load("admin");
$langs->load("withdrawals");
$langs->load("adminRelanceTiers@relanceTiers");

// Security check
if (!$user->admin) accessforbidden();

$action = GETPOST('action','alpha');


/*
 * Actions
 */

if ($action == "set")
{
    $db->begin();
 

    
        $res = dolibarr_set_const($db,"RELANCE_TEXT_MAIL_1", GETPOST("RELANCE_TEXT_MAIL_1"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
        $res = dolibarr_set_const($db,"RELANCE_TEXT_MAIL_2", GETPOST("RELANCE_TEXT_MAIL_2"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
        $res = dolibarr_set_const($db,"RELANCE_TEXT_MAIL_3", GETPOST("RELANCE_TEXT_MAIL_3"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
        $res = dolibarr_set_const($db,"RELANCE_TITLE_MAIL_1", GETPOST("RELANCE_TITLE_MAIL_1"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
        $res = dolibarr_set_const($db,"RELANCE_TITLE_MAIL_2", GETPOST("RELANCE_TITLE_MAIL_2"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
        $res = dolibarr_set_const($db,"RELANCE_TITLE_MAIL_3", GETPOST("RELANCE_TITLE_MAIL_3"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
        $res = dolibarr_set_const($db,"RELANCE_EMAIL_COPIE", GETPOST("RELANCE_EMAIL_COPIE"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
		
        $res = dolibarr_set_const($db,"ADRESSE_RELANCE_MAIL", GETPOST("ADRESSE_RELANCE_MAIL"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
		
		
		$res = dolibarr_set_const($db,"RELANCE_TEXT_COURRIER_1", GETPOST("RELANCE_TEXT_COURRIER_1"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
        $res = dolibarr_set_const($db,"RELANCE_TEXT_COURRIER_2", GETPOST("RELANCE_TEXT_COURRIER_2"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
        $res = dolibarr_set_const($db,"RELANCE_TEXT_COURRIER_3", GETPOST("RELANCE_TEXT_COURRIER_3"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
        $res = dolibarr_set_const($db,"RELANCE_TITLE_COURRIER_1", GETPOST("RELANCE_TITLE_COURRIER_1"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
        $res = dolibarr_set_const($db,"RELANCE_TITLE_COURRIER_2", GETPOST("RELANCE_TITLE_COURRIER_2"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
        $res = dolibarr_set_const($db,"RELANCE_TITLE_COURRIER_3", GETPOST("RELANCE_TITLE_COURRIER_3"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
		
        $res = dolibarr_set_const($db,"ADRESSE_RELANCE_COURRIER", GETPOST("ADRESSE_RELANCE_COURRIER"), 'chaine',0,'',$conf->entity);
        if (! $res > 0) $error++;
    

    if (! $error)
	{
		$db->commit();
		setEventMessage($langs->trans("SetupSaved"));
	}
	else
	{
		$db->rollback();
		setEventMessage($langs->trans("Error"),'errors');
	}
}

/*
 *	View
 */

$form=new Form($db);

llxHeader('',$langs->trans("RelanceSetup"));

$linkback='<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';

print_fiche_titre($langs->trans("RelanceSetup"),$linkback,'setup');
print '<br>';
print '<table width="100%"><tr><td width="10%">'.$langs->trans("ADMIN_VAR").'</td><td width="60%">';

print '<table class="border" ><tr class="liste_titre"><td align="center">'.$langs->trans("ADMIN_CHAMP").'</td><td align="center">'.$langs->trans("ADMIN_RETOUR").'</td></tr><tr><td align="center">[name]</td><td align="center" >'.$langs->trans("ADMIN_VAR_NAME").'</td></tr>
<tr><td align="center">[nb_invoice_unpaid]</td><td align="center">'.$langs->trans("ADMIN_VAR_FAC").'</td></tr>
<tr><td align="center">[balance]</td><td align="center">'.$langs->trans("ADMIN_VAR_SOLDE").'</td></tr>
<tr><td align="center">[somme_due]</td><td align="center">'.$langs->trans("ADMIN_VAR_SOMME_DUE").'</td></tr>
<tr><td align="center">[late]</td><td align="center">'.$langs->trans("ADMIN_VAR_DATE_RETARD").'</td></tr></table>';




print '</td></tr></table>';
print '<br>';
print '<br>';
print '<form method="post" action="admin_relanceTiers.php?action=set">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';

print '<table class="noborder" width="100%">';
print '<tr class="liste_titre">';
print '<td width="20%">'.$langs->trans("Parameter").'</td>';
print '<td width="40%">'.$langs->trans("MailValue").'</td>';
print '<td width="40%">'.$langs->trans("CourrierValue").'</td>';
print "</tr>";


//Titre relance 1
print '<tr class="pair"><td>'.$langs->trans("RELANCE_TITLE_1").'</td>';
print '<td align="left">';
print '<input   name="RELANCE_TITLE_MAIL_1" size="50" value="'.$conf->global->RELANCE_TITLE_MAIL_1.'"></td>';
print '<td align="left">';
print '<input   name="RELANCE_TITLE_COURRIER_1" size="50" value="'.$conf->global->RELANCE_TITLE_COURRIER_1.'"></td>';
print '</tr>';
//Texte relance 1
print '<tr class="pair"><td>'.$langs->trans("RELANCE_TEXT_1").'</td>';
print '<td align="left">';
print '<textarea   name="RELANCE_TEXT_MAIL_1" rows="10" cols="50" >'.$conf->global->RELANCE_TEXT_MAIL_1.'</textarea></td>';
print '<td align="left">';
print '<textarea   name="RELANCE_TEXT_COURRIER_1"  rows="10" cols="50" >'.$conf->global->RELANCE_TEXT_COURRIER_1.'</textarea></td>';
print '</tr>';

//Titre mail relance 2
print '<tr class="pair"><td>'.$langs->trans("RELANCE_TITLE_2").'</td>';
print '<td align="left">';
print '<input   name="RELANCE_TITLE_MAIL_2" size="50" value="'.$conf->global->RELANCE_TITLE_MAIL_2.'"></td>';
print '<td align="left">';
print '<input   name="RELANCE_TITLE_COURRIER_2" size="50" value="'.$conf->global->RELANCE_TITLE_COURRIER_2.'"></td>';
print '</tr>';
//Texte relance 2
print '<tr class="pair"><td>'.$langs->trans("RELANCE_TEXT_2").'</td>';
print '<td align="left">';
print '<textarea   name="RELANCE_TEXT_MAIL_2" rows="10" cols="50" >'.$conf->global->RELANCE_TEXT_MAIL_2.'</textarea></td>';
print '<td align="left">';
print '<textarea   name="RELANCE_TEXT_COURRIER_2" rows="10" cols="50" >'.$conf->global->RELANCE_TEXT_COURRIER_2.'</textarea></td>';
print '</tr>';

//Titre mail relance 3
print '<tr class="pair"><td>'.$langs->trans("RELANCE_TITLE_3").'</td>';
print '<td align="left">';
print '<input   name="RELANCE_TITLE_MAIL_3" size="50" value="'.$conf->global->RELANCE_TITLE_MAIL_3.'"></td>';
print '<td align="left">';
print '<input   name="RELANCE_TITLE_COURRIER_3" size="50" value="'.$conf->global->RELANCE_TITLE_COURRIER_3.'"></td>';
print '</tr>';
//Texte relance 3
print '<tr class="pair"><td>'.$langs->trans("RELANCE_TEXT_3").'</td>';
print '<td align="left">';
print '<textarea   name="RELANCE_TEXT_MAIL_3" rows="10" cols="50" >'.$conf->global->RELANCE_TEXT_MAIL_3.'</textarea></td>';
print '<td align="left">';
print '<textarea   name="RELANCE_TEXT_COURRIER_3" rows="10" cols="50" >'.$conf->global->RELANCE_TEXT_COURRIER_3.'</textarea></td>';
print '</tr>';

//Email récepteur de copie
print '<tr class="pair"><td>'.$langs->trans("RELANCE_EMAIL_COPIE").'</td>';
print '<td colspan="2" align="left">';
print '<input   name="RELANCE_EMAIL_COPIE" size="50" value="'.$conf->global->RELANCE_EMAIL_COPIE.'"></td>';
print '</tr>';


//Adresse

print '<tr class="pair"><td>'.$langs->trans("ADRESSE_RELANCE").'</td>';
print '<td align="left">';
print '<textarea   name="ADRESSE_RELANCE_MAIL"rows="10" cols="50" >'.$conf->global->ADRESSE_RELANCE_MAIL.'</textarea></td>';
print '<td align="left">';
print '<textarea   name="ADRESSE_RELANCE_COURRIER"rows="10" cols="50" >'.$conf->global->ADRESSE_RELANCE_COURRIER.'</textarea></td>';
print '</tr>';



print '</table>';
print '<br>';

print '<center><input type="submit" class="button" value="'.$langs->trans("Save").'"></center>';

print '</form>';

dol_fiche_end();

print '<br>';



$db->close();

llxFooter();
