<?php

require('config.php');
dol_include_once('/comm/action/class/actioncomm.class.php');
//require('../../core/class/html.form.class.php');

if (!($user->rights->recouvrement->dossier->read)) accessforbidden();

require('./class/dossier.class.php');
require('./class/etape.class.php');
require('./class/procedure.class.php');
require_once DOL_DOCUMENT_ROOT .'/core/lib/pdf.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
dol_include_once('/recouvrement/class/html.recouvrement.class.php');
dol_include_once("/core/lib/company.lib.php");


$PDOdb = new TPDOdb;
//$PDOdb->Execute("SET NAMES 'utf8'");

$tbs = new TTemplateTBS;
$dossier = new TRecDossier();


$mesg = '';
$error=false;

// Initialize technical object to manage hooks of page. Note that conf->hooks_modules contains array of hook context
$hookmanager->initHooks(array('recouvrementdossierlist'));

$action = GETPOST('action');

// Pour que le bouton "Annuler" de la fiche d'un dossier annule et ne sauvegarde pas...
if(isset($_REQUEST['cancel']) && $_REQUEST['cancel'] == "Annuler") {
	$action = "";
}

$parameters=array();
$reshook=$hookmanager->executeHooks('doActions',$parameters,$object,$action);    // Note that $action and $object may have been modified by some hooks
if ($reshook < 0) setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');

if(empty($reshook) && !empty($action)) {
	switch($action) {
		case 'default':
			_liste($PDOdb, $dossier);
			break;
		case 'list':
			_liste($PDOdb, $dossier);
			break;
		case 'add':
		case 'new':
			$dossier = new TRecDossier;
			$dossier->set_values($_REQUEST);
			_fiche($PDOdb, $dossier,'edit');

			break;
		case 'edit'	:

			$dossier->load($PDOdb, $_REQUEST['id']);

			_fiche($PDOdb, $dossier,'edit');
			break;

		case 'save':
			$dossier->load($PDOdb, $_REQUEST['id']);
			$dossier->set_values($_REQUEST);

			$dossier->save($PDOdb);
			_fiche($PDOdb, $dossier, 'view');

			break;

		case 'save_etape':
			_action_save_etape($PDOdb, $dossier);
			break;

		case 'mergePdfAll':
			_action_mergePdf($PDOdb, $dossier,'all');
			break;

		case 'mergePdfCurrent':
			_action_mergePdf($PDOdb, $dossier,'current');
			break;

		case 'saveLink':

			if(!empty($_POST['TRecDossierFacture'])) {
				foreach($_POST['TRecDossierFacture'] as $id=>$factureLink) {

					$o=new TRecDossierFacture;
					if($o->load($PDOdb, $id)) {
						$o->filepath = $factureLink['filepath'];
						$o->save($PDOdb);

					}

				}

				setEventMessage("Sélection de fichier appliquée");

			}

			$dossier->load($PDOdb, $_REQUEST['id_dossier']);
			_fiche($PDOdb, $dossier, 'view');


			break;

		case 'delete':

			if(!empty($_REQUEST['urlfile'])){
				$dossier->load($PDOdb, $_REQUEST['dossier']);
				$upload_dir = $dossier->getPath().'/';
				if(file_exists($upload_dir.$_REQUEST['urlfile']))
					unlink($upload_dir.$_REQUEST['urlfile']);
			}
			else{
				$dossier->load($PDOdb, $_REQUEST['id']);
				$dossier->delete($PDOdb);
				_liste($PDOdb, $dossier);
			}

			if(!empty($_REQUEST['urlfile'])){
				?>
				<script language="javascript">
					document.location.href="?id=<?php echo $dossier->getId(); ?>";
				</script>
				<?php
			}

			break;
		case 'addfacture':

			$dossier->load($PDOdb, GETPOST('id'));

			$id_facture = GETPOST('factureid');
			if($id_facture) {

				$dossier->addFacture($id_facture);
				$dossier->save($PDOdb);

			}


			_fiche($PDOdb, $dossier, 'view');

			break;
		case 'delfacture':

			$dossier->load($PDOdb, GETPOST('id'));

			$id_facture = GETPOST('factureid');
			if($id_facture) {

				$dossier->delFacture($id_facture);
				$dossier->save($PDOdb);

			}


			_fiche($PDOdb, $dossier, 'view');

			break;
		case 'genetat':

			$dossier->load($PDOdb, GETPOST('id'));

			$societe = new Societe($db);
			$societe->fetch($dossier->fk_soc);

			$TFacture = array();
			foreach( $dossier->TRecDossierFacture as $dossFac) {
				$TFacture[] = $dossFac->fk_facture;
			}

			_genEtat(DOL_DATA_ROOT . '/recouvrement/'.$dossier->ref.'/', $TFacture, $societe);

			//_fiche($PDOdb, $dossier, 'view');

			break;

		case 'relaunch_step':
			$dossier->load($PDOdb, GETPOST('id'));
			$dossier->doAction($user, $PDOdb);

			_fiche($PDOdb, $dossier, 'view');

			break;

		default:
			_liste($PDOdb, $dossier);
			break;
	}

}
elseif(isset($_REQUEST['id'])) {
	$dossier->load($PDOdb, $_REQUEST['id']);

	_fiche($PDOdb, $dossier, 'view');
}
else {
	 _liste($PDOdb, $dossier);
}

llxFooter();

/*
 * View
 */
function _liste(&$PDOdb, &$dossier) {
	global $langs, $db, $conf, $user, $action,$hookmanager;

	//$PDOdb->Execute("SET NAMES 'utf8'");
	llxHeader('',$langs->trans('RecDossierListTitle' ) ,'', '', 0, 0, '', array('/recouvrement/css/module_style.css') );

	if(GETPOST('socid')){
		$soc = new Societe($db);
		$soc->fetch(GETPOST('socid'));
		$soc->info(GETPOST('socid'));

		$head = societe_prepare_head($soc);
		dol_fiche_head($head, 'Recouvrement', $langs->trans("ThirdParty"),0,'company');

	}

	$r = new TSSRenderControler($dossier);
	//(SELECT) as 'montant',
	$sql = "SELECT d.rowid, d.ref, '' as 'Montant', '' as 'reste', d.fk_soc, s.nom, d.date_start, e.name as etapeCourante,d.date_last_etape, d.rowid as etapeSuivante,'' as prochaine, '' as doc, d.statut as 'statut'";
	// Add fields from hooks
	$parameters=array();
	$reshook=$hookmanager->executeHooks('printFieldListSelect',$parameters);    // Note that $action and $object may have been modified by hook
	$sql.=$hookmanager->resPrint;

	$sql.= ' , d.rowid AS checkbox'; // placed at end

	$sql.= " FROM ".MAIN_DB_PREFIX."rec_dossier as d";
	$sql.= ' LEFT JOIN '.MAIN_DB_PREFIX.'rec_etape as e ON d.fk_etape = e.rowid';
	$sql.= ' LEFT JOIN '.MAIN_DB_PREFIX.'societe as s ON d.fk_soc = s.rowid';
	// Add fields from hooks
	$parameters=array();
	$reshook=$hookmanager->executeHooks('printFieldListJoin',$parameters);    // Note that $action and $object may have been modified by hook
	$sql.=$hookmanager->resPrint;
	$sql.= " WHERE d.entity IN (".getEntity('rec_dossier',1).") ";
	// Add where from hooks
	$parameters=array();
	$reshook=$hookmanager->executeHooks('printFieldListWhere',$parameters);    // Note that $action and $object may have been modified by hook
	$sql.=$hookmanager->resPrint;


	if(GETPOST('socid')) $sql .= " AND d.fk_soc = ".GETPOST('socid');

	$THide = array('rowid', 'fk_soc', 'fk_user');

	$TOrder = array('date_start'=>'DESC');
	if(isset($_REQUEST['orderDown']))$TOrder = array($_REQUEST['orderDown']=>'DESC');
	if(isset($_REQUEST['orderUp']))$TOrder = array($_REQUEST['orderUp']=>'ASC');

	if (!empty($_SERVER['QUERY_STRING'])) { $page_submition = $_SERVER['PHP_SELF'].'?'.$_SERVER['QUERY_STRING']; }
	else { $page_submition = $_SERVER['PHP_SELF']; }

	$form = new TFormCore($page_submition,'formscore','POST');

	//echo $form->hidden('action', 'save_etape');

//	$PDOdb->debug = true;

	$listViewConfig = array (
			'limit' => array (
					'page' => (isset ( $_REQUEST ['page'] ) ? $_REQUEST ['page'] : 1),
					'nbLine' => $conf->liste_limit  // Limite dolibarr modifiable sur fiche user
			),
			'link' => array (
					'ref' => img_picto ( '', 'object_dir' ) . ' <a href="?id=@rowid@">@val@</a>',
					'login' => '<a href="' . DOL_URL_ROOT . '/user/fiche.php?id=@fk_user@">' . img_picto ( '', 'object_user.png', '', 0 ) . ' @val@</a>'
				/* ,'nom'=>'<a href="'.DOL_URL_ROOT.'/societe/soc.php?socid=@fk_soc@">'.img_picto('','object_company.png', '', 0).' @val@</a>' */
			),
			'hide' => $THide,
			'type' => array (
					'date_start' => 'date',
					'date_end' => 'date',
					'date_last_etape' => 'date',
					'reste' => 'money'
			),
			'title' => array (
					'rowid' => 'Numéro de dossier',
					'ref' => 'Référence dossier',
					'date_start' => 'Date dossier',
					'nom' => 'Client',
					'login' => 'Utilisateur',
					'fk_etape' => 'Etape',
					'etapeSuivante' => 'Etape suivante',
					'etapeCourante' => 'Dernière étape effectuée',
					'doc' => 'Document joint',
					'statut' => 'Statut',
					'prochaine' => 'Prochaine étape dans',
					'date_last_etape' => 'Date de la dernière action',
					'reste' => 'Reste à payer',
					'checkbox' => '<input id="folderCheckToggle" type="checkbox"  />'
			),
			'liste' => array (
					'titre' => $langs->trans ( 'RecDossierList' ),
					'image' => img_picto ( '', 'recouvrement.png@recouvrement', '', 0 ),
					'picto_precedent' => img_picto ( '', 'back.png', '', 0 ),
					'picto_suivant' => img_picto ( '', 'next.png', '', 0 ),
					'noheader' => 0,
					'messageNothing' => $langs->transnoentities ( 'NoRecDossierToDisplay' ),
					'order_down' => img_picto ( '', '1downarrow.png', '', 0 ),
					'order_up' => img_picto ( '', '1uparrow.png', '', 0 )
			),
			'eval' => array (
					'etapeSuivante' => 'afficheComboSuivant(@rowid@)',
					'Montant' => '_getMontant(@rowid@)',
					'reste' => 'getSumPaiement(@rowid@)',
					// ,'Enregistrer'=>$form->btsubmit('Enregistrer', 'save_etape')
					'doc' => '_getDocJoint(@rowid@)',
					'statut' => '_getStatut(@rowid@)',
					'prochaine' => '_getDelaiProchaineEtape(@rowid@)',
					'nom' => '_getSocUrl(@fk_soc@)' ,
					'checkbox' => '_checkbox(@val@)'
			),
			'search' => array (
					'nom' => array(
						'recherche' => true
						,'table' => 's'
					)
					,'statut' => array (
							'recherche' => $dossier->TStatut,
							'table' => 'd'
					),
					'date_start' => array (
							'recherche' => 'calendars',
							'table' => 'd'
					)
			),
			'orderby'=> array (
			$TOrder,
			'noOrder'=> array('checkbox'),
			),
	);

	// Change view from hooks
	$parameters=array(  'listViewConfig' => $listViewConfig);

	$reshook=$hookmanager->executeHooks('listViewConfig',$parameters,$r);    // Note that $action and $object may have been modified by hook
	if ($reshook < 0) setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');
	if ($reshook>0)
	{
		$listViewConfig = $hookmanager->resArray;
	}



	$PDOdb->execute($sql);
	if($PDOdb->Get_Recordcount() > 0) {
		// Action en masse
		_formTopMassAction();
	}

	if($action == 'downloadFusionPdf')
	{
		print '<a class="butAction" href="'.DOL_URL_ROOT.'/document.php?modulepart=recouvrement&file=merged.pdf"><i class="fa fa-download"></i> ';
		print $langs->trans ( 'DownloadMergedPdf' );
		print '</a> ';
		print '<iframse  src="'.DOL_URL_ROOT.'/document.php?modulepart=recouvrement&file=merged.pdf" frameborder="0" height="0" width="0" ></iframe>';

	}

	$r->liste($PDOdb, $sql, $listViewConfig);

	?>
	<script type="text/javascript" >
    $(document).ready(function () {
	 	$("#folderCheckToggle").click(function() {
             var checkBoxes = $(".folder-checkbox");
             checkBoxes.prop("checked", this.checked);
        });

	 	$('.rowInput').change(function() {
	 		var id = $(this).attr( "data-dossierid" );
	 		$('.folder-checkbox[data-dossierid="'+ id +'"]').prop("checked", 1);
	    });

    });
    </script>
	<?php




	global $mesg;
	dol_htmloutput_mesg($mesg, '', 'ok');

}
function _getSocUrl($fk_soc) {
global $db;

	$soc=new Societe($db);
	$soc->fetch($fk_soc);
	return $soc->getNomUrl(1);

}

$TCacheDossier=array();

function _getDelaiProchaineEtape($id_dossier) {
	global $TCacheDossier;


	$PDOdb = new TPDOdb;
	if(!isset($TCacheDossier[$id_dossier])) {
		$dossier = new TRecDossier;
		$dossier->load($PDOdb, $id_dossier);
		$TCacheDossier[$id_dossier] = $dossier;
	}

	$dossier = & $TCacheDossier[$id_dossier];

	$res = $dossier->getDelaiProchaineEtape($PDOdb);

	if($res===false)return '';

	if($dossier->date_last_etape==0) $dossier->date_last_etape = time();
	$time_next_etape = $dossier->date_last_etape + ($res->delais * 86400);

	$jour = ($time_next_etape - time()) / 86400;

	$PDOdb->close();

	return (int)$jour.' jour(s) : '.$res->name;
}
function _getMontant($id_dossier) {
	global $conf,$TCacheDossier;


	if(!isset($TCacheDossier[$id_dossier])) {
		$PDOdb = new TPDOdb;
		$dossier = new TRecDossier;
		$dossier->load($PDOdb, $id_dossier);
		$TCacheDossier[$id_dossier] = $dossier;
	}

	$dossier = & $TCacheDossier[$id_dossier];

	return $dossier->getMontant($conf->currency);
}

function getSumPaiement($id_dossier,$idfac=0){
	global $db,$TCacheDossier;



	if(!isset($TCacheDossier[$id_dossier])) {
		$PDOdb = new TPDOdb;
		$dossier = new TRecDossier;
		$dossier->load($PDOdb, $id_dossier);
		$TCacheDossier[$id_dossier] = $dossier;
	}

	$dossier = & $TCacheDossier[$id_dossier];

	$TFacIds = array();

	if(!$idfac){
		foreach($dossier->TRecDossierFacture as $TRecDossierFacture){
			$TFacIds[] = $TRecDossierFacture->fk_facture;
		}
	}
	else{
		$TFacIds[] = $idfac;
	}

	foreach($TFacIds as $idfac){
		$facture = new Facture($db);
		$facture->fetch($idfac);

		$totalpaye = $facture->getSommePaiement();
		$totalcreditnotes = $facture->getSumCreditNotesUsed();
		$totaldeposits = $facture->getSumDepositsUsed();

		$resteapayer += price2num($facture->total_ttc - $totalpaye - $totalcreditnotes - $totaldeposits, 'MT');
	}

	return $resteapayer;
}

function _getStatut($id_dossier){
	$PDOdb = new TPDOdb;

	$dossier = new TRecDossier;
	$dossier->withChild = false;
	$dossier->load($PDOdb, $id_dossier);

	$PDOdb->close();

	return $dossier->TStatut[$dossier->statut];
}

function _getDocJoint($id_dossier){
	global $hookmanager,$action,$conf;
	$PDOdb = new TPDOdb;

	$dossier = new TRecDossier;
	$dossier->withChild = false;
	$dossier->load($PDOdb, $id_dossier);

	$PDOdb->close();


	$parameters=array();
	$reshook=$hookmanager->executeHooks('ModRecouvrementGetDocJoint',$parameters,$dossier,$action);    // Note that $action and $object may have been modified by some hooks
	if ($reshook < 0) setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');

	if(empty($reshook))
	{
		if(!empty($conf->global->RECOUVREMENT_FOLDER_LIST_SHOWALLFILES))
		{
			
		    
		    $dir = $dossier->getPath();
			
			
			
			$filearray=dol_dir_list($dir, 'files');
			
			$form = new Form($db);
			$return = '';
			foreach ($filearray as $f )
			{
				$img =  img_mime($f['fullname'] , $f['name'] );

				$return .= '<a href="'.DOL_URL_ROOT.'/document.php?modulepart=recouvrement&entity='.$dossier->entity.'&file='.$dossier->ref.'/'.$f['name'].'">';
				$return .= $form->textwithtooltip( $img , $f['name'] ,1,0);
				$return .= '</a> ';

			}

			return $return;

		}
		else
		{
			// comportement d'origin
			switch($dossier->etape->fk_action){
				case 'externaliser':

				    if(file_exists($dossier->getPath().'/dossier.zip'))
					    return '<a href="'.DOL_URL_ROOT.'/document.php?modulepart=recouvrement&entity='.$dossier->entity.'&file='.$dossier->ref.'/dossier.zip">'.img_picto('','file.png', '', 0).'</a>';
						else
							return '';
							break;
				case 'doc':
				    if(file_exists($dossier->getPath().'/'.$dossier->etape->tpl_doc))
						return '<a href="'.DOL_URL_ROOT.'/document.php?modulepart=recouvrement&entity='.$dossier->entity.'&file='.$dossier->ref.'/'.$dossier->etape->tpl_doc.'">'.img_picto('','file.png', '', 0).'</a>';
						else
							return '';
							break;
				default:
					return '';
					break;
			}

		}





	}
	else
	{
		return $hookmanager->resPrint;
	}
}

function afficheComboSuivant($id_dossier) {
global $langs;
	$PDOdb2 = new TPDOdb;

	if(!isset($TCacheDossier[$id_dossier])) {
		$dossier = new TRecDossier;
		$dossier->load($PDOdb2, $id_dossier);
		$TCacheDossier[$id_dossier] = $dossier;
	}

	$dossier = & $TCacheDossier[$id_dossier];

	//pre($p->getFirstEtape(), true);exit;
	$sql = 'SELECT e.rowid, e.name, e.delais,e.rang
			FROM '.MAIN_DB_PREFIX.'rec_etape as e
			WHERE e.fk_procedure = '.$dossier->fk_procedure/*$id_dossier*/.'
		 ORDER BY e.rang'; //AND e.rowid NOT IN ('.$doss->fk_etape.')

	$PDOdb2->Execute($sql);

	$Tab = array(0=>'---------');

	while($row = $PDOdb2->Get_line()) {
		if($row->rowid==$dossier->fk_etape)$Tab[$row->rowid] ='('.$langs->trans('RecouvrementLastAction').') '.  $row->rang.'/ '.$row->name;
		else $Tab[$row->rowid] = $row->rang.'/ '.$row->name;
	}

	$form = new TFormCore;
	$onChange='';
	$plus=' data-dossierid="'.(int)$id_dossier.'" ';
	$class='rowInput';
	$combo = $form->combo('', 'TDossier['.$id_dossier.'][fk_etape]', $Tab,0,1,$onChange,$plus,$class);

	// Affichage du combo uniquement si le dossier n'est pas au statu "CLOSED"
	if($doss->statut != "CLOSED")
		return $combo;
}

function _fiche(&$PDOdb, &$dossier, $mode) {
	global $db, $langs, $user, $conf;

	if (!empty($dossier->errors)) setEventMessages('', $dossier->errors, 'errors');

	dol_include_once('/recouvrement/admin/recouvrementsetuppage.php');

	llxHeader('',$langs->trans("Dossier"),'','','','',$extrajs);
	$head = rec_prepare_head($dossier);
	dol_fiche_head($head, 'recouvrement', "Fiche du dossier", 0);

	$dossier_user = new User($db);
	$dossier_user->fetch($dossier->fk_user);

	$societe = new Societe($db);
	$societe->fetch($dossier->fk_soc);

	$sql = "SELECT rowid, name
			FROM ".MAIN_DB_PREFIX."rec_procedure";

	$PDOdb->Execute($sql);

	$tab = array();

	while($PDOdb->Get_line()) {
		$tab[$PDOdb->Get_field('rowid')] = $PDOdb->Get_field('name');
	}

	$PDOdb2 = new TPDOdb;
	$sqlListeClients = "SELECT rowid, nom
						FROM ".MAIN_DB_PREFIX."societe";
	$PDOdb2->Execute($sqlListeClients);
	$TabListeClients = array();
	while($PDOdb2->Get_line()) {
		$TabListeClients[$PDOdb2->Get_field('rowid')] = $PDOdb2->Get_field('nom');
	}

	$formCore = new TFormCore;

	$procEdit = $formCore->combo($pLib, 'fk_procedure', $tab, $pDefault);
	$procView = $tab[$dossier->fk_procedure];

	$formDoli = new Form($db);
	$form=new TFormCore($_SERVER['PHP_SELF'],'formscore','POST');
	$form->Set_typeaff($mode);

	echo $form->hidden('id', $dossier->getId());
	echo $form->hidden('action', 'save');
	echo $form->hidden('fk_user', $dossier->fk_user);
	echo $form->hidden('date_end', date('d m Y'));
	echo $form->hidden('entity', getEntity('rec_dossier'));
	echo $form->hidden('fk_etape', $dossier->fk_etape);

	$TBS=new TTemplateTBS();
	//dol_fiche_head();


	$btNewRecEtape.= '<a href="'.$_SERVER['SELF'].'?action=addnewstep&id='.$dossier->rowid.'" class="butAction">'.$langs->trans('NewRecEtape').'</a>';

	$btRetour = '<a class="butAction" href="'.dol_buildpath("/recouvrement/dossier.php",1).'">Retour</a>';
	$btCancel = $form->btsubmit('Annuler', 'cancel');
	$btSave = $form->btsubmit('Valider', 'save');
	$btModifier = '<a class="butAction" href="'.dol_buildpath('/recouvrement/dossier.php?id='.$dossier->rowid.'&action=edit',1).'">Modifier</a>';
	$btDelete = "<input type=\"button\" id=\"action-delete\" value=\"Supprimer\" name=\"cancel\" class=\"butActionDelete\" onclick=\"if(confirm('Supprimer ce dossier ?'))document.location.href='?action=delete&id=".$dossier->rowid."'\" />";
	//pre($dossier);
	$socView = $TabListeClients[$dossier->fk_soc];
	$socEdit = $formDoli->select_company($dossier->fk_soc, $htmlname='fk_soc');
	$userEdit = $formDoli->select_dolusers($dossier->fk_user, 'fk_user');

	$titleEdit = load_fiche_titre($dossier->getId() > 0 ? $langs->trans("EditDoss") : $langs->trans("NewDoss"),'');
	$titleView = load_fiche_titre($langs->trans("FicheDoss"),'');

	//if($dossier->statut == "CLOSED") {
	$dateDossTitle = "Date de clôture du dossier";
	$dateDoss = $dossier->get_date('date_end');
	//}

	if($mode == 'edit') {
		$soc = $socEdit;
		$usr = $userEdit;

		$buttons = $btCancel.$btSave;
		$title = $titleEdit;
		$procedures = $procEdit;
	} else {
		$soc = $societe->getNomUrl(1);
		$usr = (empty($dossier_user->id) ? $langs->trans('DossNoUserAttached') : $dossier_user->getNomUrl(1));

		$buttons = $btRetour.' '.$btModifier.' '.$btDelete;

		$title = $titleView;
		$procedures = $procView;
	}

	print $TBS->render('./tpl/dossier.tpl.php'
		,array(

		)
		,array(
			'dossier'=>array(
				'titre'=>$title
				,'id'=>$dossier->rowid
				,'ref_title'=>$langs->trans('RecDossierTitleRef')
				,'ref'=>$form->texte('', 'ref', $dossier->ref, 15)
				,'montant_a_recouvrer_title'=>$langs->trans('RecDossierTitleMontantARecouvrer')
				,'montant_a_recouvrer'=>$dossier->getMontant()
				,'date_creation_title'=>'Date de création du dossier'
				,'date_creation'=>$dossier->get_date('date_start')
				,'statut_title'=>'Statut'
				,'statut'=>$form->combo('', 'statut', $dossier->TStatut, $dossier->statut)
				,'soc_title'=>'Client'
				,'fk_soc'=>$soc
				,'proc_title'=>'Procédure'
				,'listProcedure'=>$procedures
				,'etape_title'=>"Etape précédemment effectuée"
				,'etapeCourante'=>$dossier->etape->name.($mode=='view' ? ' <a href="?id='.$dossier->getId().'&action=relaunch_step">'.img_picto($langs->trans('RefreshStep'), 'refresh').'</a>' :'')
				,'date_clo_title'=>$dateDossTitle
				,'date_clo'=>$dateDoss
				,'commentaire_title'=>"Commentaire"
				,'commentaire'=>$mode == "edit" ? $form->zonetexte('', 'commentaire', $dossier->commentaire, 15) : $dossier->commentaire
				,'user_title'=>$langs->trans('DossUserAttached')
				,'user'=>$usr
			)
			,'client'=>array(
				'showrefnav'=>$formDoli->showrefnav($societe,'socid','',($user->societe_id?0:1),'rowid','nom')
				,'idprof1'=>$societe->idprof1
				,'adresse'=>$societe->address
				,'cpville'=>$societe->zip.($societe->zip && $societe->town ? " / ":"").$societe->town
				,'pays'=>picto_from_langcode($societe->country_code).' '.$societe->country
			)
			,'view'=>array(
				'mode'=>$mode
			)
			,'buttons'=>array(
				'buttons'=>$buttons
			)

		)
	);

	echo $form->end_form();

	?>
	<script type="text/javascript">
		$(document).ready(function(){
			$('.deletefilelink').each(function(){
				$(this).attr('href',$(this).attr('href')+"&dossier=<?php echo $dossier->rowid; ?>");
			});
		});
	</script>
	<?php

	// End of page
	if($mode == 'view') {
		_listeEtape($dossier,$PDOdb);
		_listeFacture($dossier,$PDOdb);
		//_gestionDocument($dossier);
	}

	global $mesg, $error;
	dol_htmloutput_mesg($mesg, '', ($error ? 'error' : 'ok'));
}

function _listeEtape(&$dossier,&$PDOdb){
	global $langs, $db, $conf, $user;

	$procedure= new TRecProcedure();
	$procedure->load($PDOdb,$dossier->fk_procedure);


	$sql = " SELECT e.rowid, e.rang, e.name, e.delais,h.date_etape,h.fk_commaction";
	$sql.= " FROM ".MAIN_DB_PREFIX."rec_etape as e LEFT JOIN ".MAIN_DB_PREFIX."rec_etape_history h ON (h.fk_etape=e.rowid AND h.fk_dossier=".$dossier->getId().")";


	if(!$procedure->allow_free_events)
	{
		$sql.= " WHERE e.fk_procedure = ".$dossier->fk_procedure;
	}
	else {
		$sql.= " WHERE e.fk_procedure IN (0, ".$dossier->fk_procedure." )";
	}


    $lst = new TListviewTBS('list_rec_dossier');

	$THide = array('rowid');

	if(isset($_REQUEST['orderDown']))$TOrder = array($_REQUEST['orderDown']=>'DESC');
	if(isset($_REQUEST['orderUp']))$TOrder = array($_REQUEST['orderUp']=>'ASC');

	if (!isset($_REQUEST['orderDown']) && !isset($_REQUEST['orderUp'])) $TOrder = array('rang' => 'ASC');

	print $lst->render($PDOdb, $sql, array(
		'limit'=>array(
			'page'=>(isset($_REQUEST['page']) ? $_REQUEST['page'] : 1)
			,'nbLine'=>99
		)
		,'link'=>array(
			//'name'=>img_picto('', 'object_list').' <a href="'.DOL_URL_ROOT.'/custom/recouvrement/admin/etape.php?id=@rowid@&fk_procedure='.$dossier->getId().'">@val@</a>',
			'name'=>'@val@',
			'delais'=>'@val@ jours'
		)
		,'title'=>array(
			'name'=>$langs->trans('RecEtapeTitleName')
			,'rang'=>$langs->trans('RecEtapeTitleOrder')
			,'delais'=>$langs->trans('RecEtapeTitleDelais')
			,'date_etape'=>$langs->trans('RecDateEtape')
			,'fk_commaction'=>$langs->trans('RecCommAction')
		)
		,'hide'=>$THide
		,'type'=>array()
		,'liste'=>array(
			'titre'=>$langs->trans('RecEtapeList')
			,'picto_precedent'=>img_picto('','back.png', '', 0)
			,'picto_suivant'=>img_picto('','next.png', '', 0)
			,'noheader'=> 0
			,'messageNothing'=>$langs->transnoentities('NoRecEtapeToDisplay')
			,'order_down'=>img_picto('','1downarrow.png', '', 0)
			,'order_up'=>img_picto('','1uparrow.png','', 0)
		)
		,'eval'=>array(
			'fk_commaction'=>'_get_actioncomm_link("@val@")'
			,'date_etape'=>'_get_date_etape("@val@")'
		)
		,'orderBy'=>$TOrder

	));

	_freeStepAddForm($dossier,$procedure,$PDOdb);
	print '<br /><br />';
}

function _freeStepAddForm(&$dossier,$procedure,&$PDOdb)
{
	global $user, $langs;

	if(!$procedure->allow_free_events || !$user->rights->recouvrement->dossier->allow_free_events)
	{
		return;
	}

	$form = new TFormCore($_SERVER['PHP_SELF'],'freeStepAddForm','POST');
	print '<h4>'.$langs->trans('AddNewStep').'</h4>';
	echo $form->texte($langs->trans('RecEtapeTitleName'),'name','',50,255,'',"free-step-add-input", '');

	print '<button id="btn-form-add-new-event-submit" class="butAction" type="submit" name="save" value="add" >'.$langs->trans('Add').'</button>';

	$form->end();
	?>

	<script type="text/javascript" >
        $(document).ready(function () {

        	$("#btn-form-add-new-event-submit").click(function(event) {
        		event.preventDefault();
        		$(this).disabled=true;

        		var data = {"action": "add"};

        		$("form#freeStepAddForm :input").each(function(){

        			data[$(this).attr('name')] = $(this).val();

        			 //var input = $(this).attr('name'); // This is the jquery object of the input
        		});

        		ajax_event_call(data);
        		return false;

        	});

        });


    	function ajax_event_call(datas)
    	{
    		$.ajax({
    		    url: "<?php echo dol_buildpath('/recouvrement/etape_libre.php?dossier_id='.$dossier->getId(), 1) ; ?>",
    		    type: "POST",
    		    dataType: "json",
    		    data: datas,
    		    success: function(data){
    		    	$("#btn-form-add-new-event-submit").disabled=false;
    		       console.log(data);
    		        if (data.result>0) {
    		        	$.jnotify(data.msg);
    		        	window.location.replace("<?php echo $_SERVER['PHP_SELF'].'?id='.$dossier->getId(); ?>");
    		        }
    		        else
    		        {
    		        	 if (data.result==0) {
    	    		        $.jnotify(data.msg);
    	    		     }
    	    		     else
    	    		     {
    	    		    	if (data.result<0) {
    	    		    		$.jnotify('Error:' + data.errorMsg,"error");
    	     		        }
    	     		        else
    	     		        {
    	     		        	// do nothing
    	     		        }
    	    		     }
    		        }





    		    },
    		    error: function(error){
    		    	$.jnotify('AjaxError',"error");
    		    }
    		});
    	}
</script>

	<?php

	//http://127.0.0.1/dolibarr/a2a/htdocs/custom/recouvrement/etape_libre.php?dossier_id=1
	//http://127.0.0.1/dolibarr/a2a/htdocs/custom/clia2a/pt_ajax.php?dossier_id=1
}


function _get_date_etape($date) {

	$t=strtotime($date);
	if($t<strtotime('2000-01-01')) return '';
	else return date('d/m/Y H:i', $t);

}
function _get_actioncomm_link($fk_actioncomm) {
global $db;

	$a=new ActionComm($db);
	$a->fetch($fk_actioncomm);

	if($fk_actioncomm>0)return $a->getNomUrl(1);
	else return '';

}

function _listeFacture(&$dossier,&$PDOdb){
	global $langs, $db, $conf, $user;

	$form = new FormRecouvrement($db);

	$selectList=$form->select_invoice($dossier->getId(), $dossier->fk_soc);

	if(!empty($selectList)) {
		print '<form action="'.$_SERVER["PHP_SELF"].'" method="post">';
		print '<input type="hidden" name="action" value="addfacture">';
		print '<input type="hidden" name="id" value="'.$dossier->getId().'">';
		print '<table><tr><td>'.$langs->trans("SelectInvoice").'</td>';
		print '<td>'.$selectList.'</td>';
		print '<td><input type="submit" class="button" value="'.dol_escape_htmltag($langs->trans("AddInvoiceTo")).'"></td>';
		print '</tr></table>';
		print '</form>';
	}


	$formCore=new TFormCore('auto','formlink','post');
	echo $formCore->hidden('action','saveLink');
	echo $formCore->hidden('id_dossier',$dossier->getId());


	$r = new TListviewTBS('liste_facture');

    if ((float) DOL_VERSION < 10.0) $field_facture_ref = 'facnumber';
    else $field_facture_ref = 'ref';

	$sql = " SELECT f.rowid, df.rowid as linkFct,f.".$field_facture_ref." AS facnumber,";

	if($conf->global->RECOUVREMENT_PARENT_CASE){
		$sql .= "f.fk_soc, s.nom,";
	}
	$sql .= " f.date_lim_reglement as date_lim, '' as 'reste', '' as 'file', f.total, f.tva, f.total_ttc, f.paye, '' as 'unlink'";
	$sql.= " FROM ".MAIN_DB_PREFIX."facture as f
			 	LEFT JOIN ".MAIN_DB_PREFIX."rec_dossier_facture as df ON (df.fk_facture = f.rowid)";
	if($conf->global->RECOUVREMENT_PARENT_CASE){
		$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON (s.rowid = f.fk_soc)";
	}
	$sql.= " WHERE df.fk_dossier = ".$dossier->rowid;
	//$sql.= " AND f.paye = 0";

	/*$resql = $db->query($sql);
	$resql = $resql->fetch_object();

	$facture = new Facture($db);*/

	$TLink = array(
			'unlink'=>' <a href="?id='.$dossier->getId().'&factureid=@rowid@&action=delfacture">'.img_picto($langs->trans('Unlink'), 'delete.png').'</a>'
		);

	$TEval= array(
			'reste'=>'getSumPaiement('.$dossier->rowid.',@rowid@)'
			,'file'=>'getComboFile(@linkFct@, "@file@")'
	);

	if($conf->global->RECOUVREMENT_PARENT_CASE){
		$TEval['nom'] = '_getSocUrl(@fk_soc@)';
	}
	$TEval['facnumber']='_getNomUrlInvoice("@rowid@")';

	$THide = array('rowid','fk_soc','linkFct');

	if(isset($_REQUEST['orderDown']))$TOrder = array($_REQUEST['orderDown']=>'DESC');
	if(isset($_REQUEST['orderUp']))$TOrder = array($_REQUEST['orderUp']=>'ASC');

	print $r->render($PDOdb, $sql, array(
		'limit'=>array(
			'page'=>(isset($_REQUEST['page']) ? $_REQUEST['page'] : 0)
			,'nbLine'=>'25'
		)
		,'link'=>$TLink
		,'translate'=>array(
			'paye'=>array(
				0=>img_picto($langs->trans('BillStatusNotPaid'),'statut1')
				,1=>img_picto($langs->trans('BillStatusPaid'),'statut6')
			)
		)
		,'title'=>array(
			'facnumber'=>$langs->trans('RecFactureTitleNumber')
			,'unlink'=>$langs->trans('Unlink')
			//,'fk_soc'=>$langs->trans('RecFactureTitleFKSoc')
			//,'nom'=>$langs->trans('RecDossierTitleSociete')
			,'date_lim'=>'Date limite de règlement'
			,'total'=>'Total HT'
			,'tva'=>'Total TVA'
			,'total_ttc'=>'Total TTC'
			,'paye'=>'Statut'
			,'nom'=>'Filliale'
			,'reste'=>'Reste à payer'
			,'file'=>'Fichier'
		)
		,'hide'=>$THide
		,'liste'=>array(
			'titre'=>$langs->trans('RecFactureList')
			,'picto_precedent'=>img_picto('','back.png', '', 0)
			,'picto_suivant'=>img_picto('','next.png', '', 0)
			,'noheader'=> 0
			,'messageNothing'=>$langs->transnoentities('NoRecFactureToDisplay')
			,'order_down'=>img_picto('','1downarrow.png', '', 0)
			,'order_up'=>img_picto('','1uparrow.png','', 0)
		)
		,'type'=>array(
			'total'=>'money',
			'tva'=>'money',
			'total_ttc'=>'money',
			'reste'=>'money',
			'date_lim'=>'date'
		)
		,'eval'=>$TEval
	));

	echo '<p align="right">'.$formCore->btSubmit('Enregistrer la sélection de fichier','saveLink').'</p>';

	$formCore->end();


	print '<br><center><a class="butAction" href="'.dol_buildpath('/recouvrement/dossier.php?id='.$dossier->rowid.'&action=genetat',1).'">Générer un état des factures</a></center>';

}

function getComboFile($id, $file) {

	$PDOdb=new TPDOdb;

	$o = new TRecDossierFacture;
	$o->load($PDOdb,$id);

	return $o->getComboFile("TRecDossierFacture[".$id."][filepath]");


}

function _gestionDocument($object){
	global $db,$user,$conf;

	echo '<br><br>';

	@mkdir($object->getPath(),0777,true);

	$upload_dir = $object->getPath();

	// Post file
	if (GETPOST('sendit') && ! empty($conf->global->MAIN_UPLOAD_DOC))
	{
		if ($object->getId())
		{
			dol_add_file_process($upload_dir,0,1,'userfile');
		}
	}

	$formfile=new FormFile($db);

	// Show upload form
	$formfile->form_attach_new_file($_SERVER["PHP_SELF"].'?id='.$object->getId(),'',0,0,$user->rights->recouvrement->dossier->read,50,$object);
	$filearray=dol_dir_list($object->getPath());

	// Pour ne pas afficher que le dossier "thumbs" auto-généré soit affiché dans la liste des fichiers joints

	$i = 0;
	foreach($filearray as $f) {
		/*echo "<pre>";
		echo count(explode(".",$f['name']));
		echo "</pre>";
		exit;*/
		if(!is_file($f['fullname'])) {
			unset($filearray[$i]); // On retire du tableau les éléments qui ne sont pas des fichiers.
		}
		$i++;
	}

	// List of document
	$formfile->list_of_documents($filearray,$object,'recouvrement');

}


function _getNomUrlInvoice($invoice_id) {
	global $db;

	if(empty($invoice_id) ) return '';

	$obj=new Facture($db);
	$obj->fetch($invoice_id);

	return $obj->getNomUrl(1);
}

function _checkbox($id=0){
	if(empty($id)) return '';

	$checked = 'unchecked';
	if(isset($_POST['folder'][$id])){$checked = 'checked';}
	return '<input type="checkbox" class="folder-checkbox" name="TDossier['.(int)$id.'][checked]" value="'.(int)$id.'" '.$checked.' data-dossierid="'.(int)$id.'"  />';
}

function _formTopMassAction()
{
	global $langs, $db, $conf, $user, $action,$hookmanager;

	$form = new Form($db);
	?>
	<div id="top-form-mass-action-wrap" class="filter-box">
	<table cellpadding="5" >
		<tr>
			<td id="top-form-mass-action-select-col" >
				<?php
				$TSelect=array(
						'default' => $langs->trans('SelectAction'),
						'save_etape' => $langs->trans('ApplyStep'),
						'mergePdfCurrent'  => $langs->trans('PDFMergeCurrent'),
						'mergePdfAll'  => $langs->trans('PDFMergeAll')
				);

				$parameters=array('TSelect' => $TSelect);

				$object ='' ;
				$reshook=$hookmanager->executeHooks('ModRecouvrementFormTopMassAction',$parameters,$object,$action);    // Note that $action and $object may have been modified by some hooks
				if ($reshook < 0) setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');

				if ($reshook>0)
				{
					$select = $hookmanager->resArray;
				}

				print $form->selectarray('action', $TSelect, $action);


				?>
			</td>
			<td  id="top-form-mass-action-btn-col"  >
				<button id="btn_validate_action" type="button" class="butAction"  /><?php print $langs->trans('Apply'); ?></button>
				<input  id="validate_action" type="hidden" value="" name="btupdatecontract" />
			</td>
		</tr>
	</table>
	</div>
	<div class="tabsAction"></div>
	<script type="text/javascript" >

	$(function() {
	    $('#btn_validate_action').click(function(){
	    	$('#validate_action').val('validate_action');
	    	$('#formscore').submit();

	    });
	});

	</script>


	<?php

}

function _action_save_etape($PDOdb, $dossier){
	global $langs, $user;
	if (is_array($_REQUEST['TDossier']) && count($_REQUEST['TDossier'])>0) {
		$action_done =false;
		foreach($_REQUEST['TDossier'] as $idDossier=>$dossierData)
		{
			if(!empty($dossierData['fk_etape']) && !empty($dossierData['checked']))
			{
				$dossier = new TRecDossier();
				$dossier->load($PDOdb, $idDossier);
				$dossier->set_values(array(
						'fk_etape' => $dossierData['fk_etape'],
				));
				$dossier->save($PDOdb);
				$dossier->etape->load($PDOdb,$dossier->fk_etape);

				$dossier->doAction($user, $PDOdb);
				$dossier->save($PDOdb);

				$action_done =true;
			}

		}

		if ($action_done) {
			setEventMessages($langs->trans('StepFinished'), null, 'mesgs');
		}
	}

	$dossier = new TRecDossier();
	_liste($PDOdb, $dossier);
}


function _action_mergePdf($PDOdb, $dossier,$type = 'current'){
	global $langs,$action,$conf;
	if (is_array($_REQUEST['TDossier']) && count($_REQUEST['TDossier'])>0) {
		$action_done =false;
		$TFilesToMerge = array();
		foreach($_REQUEST['TDossier'] as $idDossier=>$dossierData)
		{
			if(!empty($dossierData['checked']))
			{
				$dossier = new TRecDossier();
				$dossier->load($PDOdb, $idDossier);

				if($type == 'all')
				{
				    
				    $filearray=dol_dir_list($dossier->getPath(), 'files');
					$form = new Form($db);
					$return = '';
					foreach ($filearray as $f )
					{
						if( mime_content_type ( $f['fullname'] ) == 'application/pdf' )
						{
							$TFilesToMerge[] = $f['fullname'];
						}
					}
				}
				else
				{

					if ($dossier->etape->fk_action=='doc') {
					    $doc = $dossier->getPath().'/'.$dossier->etape->tpl_doc;
						if(file_exists($doc))
						{
							$path_parts = pathinfo($doc);
							$filename=$path_parts['dirname'].'/'.$path_parts['filename'].'.pdf';
							if(file_exists($filename) && mime_content_type ($filename) == 'application/pdf') {
								$TFilesToMerge[] = $filename;
							}

						}
					}
				}
			}
		}
		if(!empty($TFilesToMerge))
		{

			require_once(DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php');
			// Define format of output PDF
			$formatarray=pdf_getFormat($langs);
			$page_largeur = $formatarray['width'];
			$page_hauteur = $formatarray['height'];
			$format = array($page_largeur,$page_hauteur);
			$pdf=pdf_getInstance($format);

			// set document information
			$pdf->SetCreator(PDF_CREATOR);
			$pdf->SetAuthor('Dolibarr');


			foreach ($TFilesToMerge as $file) {
				$pageCount = $pdf->setSourceFile($file);
				for ($i = 0; $i < $pageCount; $i++) {
					$tpl = $pdf->importPage($i + 1, '/MediaBox');
					$pdf->addPage();
					$pdf->useTemplate($tpl);
				}
			}

			// output the pdf as a file
			if ($conf->multicompany->enabled) {
				if (! is_dir($conf->recouvrement->dir_output)) {
					dol_mkdir($conf->recouvrement->dir_output);
				}
				$pdf->Output($conf->recouvrement->dir_output . '/merged.pdf', 'F');
			} else {
				$pdf->Output(DOL_DATA_ROOT . '/'.(($conf->entity > 1)?$conf->entity.'/':'').'recouvrement/merged.pdf', 'F');
			}

			$action_done = true;
			setEventMessages($langs->trans('MergePdfFinished'), null, 'mesgs');
			$action = 'downloadFusionPdf';
		}
		else
		{
			setEventMessages($langs->trans('NoFileToMerge'), null, 'warnings');
		}


	}

	$dossier = new TRecDossier();
	_liste($PDOdb, $dossier);
}


