<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   mymodule     Module MyModule
 *  \brief      Example of a module descriptor.
 *				Such a file must be copied into htdocs/mymodule/core/modules directory.
 *  \file       htdocs/mymodule/core/modules/modMyModule.class.php
 *  \ingroup    mymodule
 *  \brief      Description and activation file for module MyModule
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';


/**
 *  Description and activation class for module MyModule
 */
class modRecouvrement extends DolibarrModules
{
	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
        global $langs,$conf;

        $this->db = &$db;

		// Id for module (must be unique).
		// Use here a free id (See in Home -> System information -> Dolibarr for list of used modules id).
		$this->numero = 104220;
		// Key text used to identify module (for permissions, menus, etc...)
		$this->rights_class = 'recouvrement';

		// Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
		// It is used to group modules in module setup page
		$this->family = "financial";
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i','',get_class($this));
		// Module description, used if translation string 'ModuleXXXDesc' not found (where XXX is value of numeric property 'numero' of module)
		$this->description = "Gestion du recouvrement";
		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = '1.8.7';
		// Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		// Where to store the module in setup page (0=common,1=interface,2=others,3=very specific)
		$this->special = 0;
		// Name of image file used for this module.
		// If file is in theme/yourtheme/img directory under name object_pictovalue.png, use this->picto='pictovalue'
		// If file is in module/img directory under name object_pictovalue.png, use this->picto='pictovalue@module'
		$this->picto='recouvrement@recouvrement';

		// Defined all module parts (triggers, login, substitutions, menus, css, etc...)
		// for default path (eg: /mymodule/core/xxxxx) (0=disable, 1=enable)
		// for specific path of parts (eg: /mymodule/core/modules/barcode)
		// for specific css file (eg: /mymodule/css/mymodule.css.php)
		//$this->module_parts = array(
		//                        	'triggers' => 0,                                 	// Set this to 1 if module has its own trigger directory (core/triggers)
		//							'login' => 0,                                    	// Set this to 1 if module has its own login method directory (core/login)
		//							'substitutions' => 0,                            	// Set this to 1 if module has its own substitution function file (core/substitutions)
		//							'menus' => 0,                                    	// Set this to 1 if module has its own menus handler directory (core/menus)
		//							'theme' => 0,                                    	// Set this to 1 if module has its own theme directory (core/theme)
		//                        	'tpl' => 0,                                      	// Set this to 1 if module overwrite template dir (core/tpl)
		//							'barcode' => 0,                                  	// Set this to 1 if module has its own barcode directory (core/modules/barcode)
		//							'models' => 0,                                   	// Set this to 1 if module has its own models directory (core/modules/xxx)
		//							'css' => array('/mymodule/css/mymodule.css.php'),	// Set this to relative path of css file if module has its own css file
	 	//							'js' => array('/mymodule/js/mymodule.js'),          // Set this to relative path of js file if module must load a js on all pages
		//							'hooks' => array('hookcontext1','hookcontext2')  	// Set here all hooks context managed by module
		//							'dir' => array('output' => 'othermodulename'),      // To force the default directories names
		//							'workflow' => array('WORKFLOW_MODULE1_YOURACTIONTYPE_MODULE2'=>array('enabled'=>'! empty($conf->module1->enabled) && ! empty($conf->module2->enabled)', 'picto'=>'yourpicto@mymodule')) // Set here all workflow context managed by module
		//                        );
		$this->module_parts = array(
			'triggers' => 1,
			'hooks' => array('invoicecard')
		);

		// Data directories to create when module is enabled.
		// Example: this->dirs = array("/mymodule/temp");
		$this->dirs = array('/recouvrement');

		// Config pages. Put here list of php page, stored into mymodule/admin directory, to use to setup module.
		$this->config_page_url = array("configuration.php@recouvrement");

		// Dependencies
		$this->depends = array();		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->phpmin = array(5,0);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("recouvrement@recouvrement");

		// Constants
		// List of particular constants to add when module is enabled (key, 'chaine', value, desc, visible, 'current' or 'allentities', deleteonunactive)
		// Example: $this->const=array(0=>array('MYMODULE_MYNEWCONST1','chaine','myvalue','This is a constant to add',1),
		//                             1=>array('MYMODULE_MYNEWCONST2','chaine','myvalue','This is another constant to add',0, 'current', 1)
		// );
		$this->const = array();

		// Array to add new pages in new tabs
		// Example: $this->tabs = array('objecttype:+tabname1:Title1:mylangfile@mymodule:$user->rights->mymodule->read:/mymodule/mynewtab1.php?id=__ID__',  	// To add a new tab identified by code tabname1
        //                              'objecttype:+tabname2:Title2:mylangfile@mymodule:$user->rights->othermodule->read:/mymodule/mynewtab2.php?id=__ID__',  	// To add another new tab identified by code tabname2
        //                              'objecttype:-tabname':NU:conditiontoremove);                                                     						// To remove an existing tab identified by code tabname
		// where objecttype can be
		// 'thirdparty'       to add a tab in third party view
		// 'intervention'     to add a tab in intervention view
		// 'order_supplier'   to add a tab in supplier order view
		// 'invoice_supplier' to add a tab in supplier invoice view
		// 'invoice'          to add a tab in customer invoice view
		// 'order'            to add a tab in customer order view
		// 'product'          to add a tab in product view
		// 'stock'            to add a tab in stock view
		// 'propal'           to add a tab in propal view
		// 'member'           to add a tab in fundation member view
		// 'contract'         to add a tab in contract view
		// 'user'             to add a tab in user view
		// 'group'            to add a tab in group view
		// 'contact'          to add a tab in contact view
		// 'categories_x'	  to add a tab in category view (replace 'x' by type of category (0=product, 1=supplier, 2=customer, 3=member)
        $this->tabs = array('thirdparty:+Recouvrement:Recouvrement:recouvrement@recouvrement:$user->rights->recouvrement->dossier->read:/recouvrement/dossier.php?socid=__ID__');

        // Dictionnaries
        if (! isset($conf->recouvrement->enabled)) @$conf->recouvrement->enabled=0;
		$this->dictionnaries=array();
        /* Example:
        if (! isset($conf->mymodule->enabled)) $conf->mymodule->enabled=0;	// This is to avoid warnings
        $this->dictionnaries=array(
            'langs'=>'mylangfile@mymodule',
            'tabname'=>array(MAIN_DB_PREFIX."table1",MAIN_DB_PREFIX."table2",MAIN_DB_PREFIX."table3"),		// List of tables we want to see into dictonnary editor
            'tablib'=>array("Table1","Table2","Table3"),													// Label of tables
            'tabsql'=>array('SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table1 as f','SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table2 as f','SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table3 as f'),	// Request to select fields
            'tabsqlsort'=>array("label ASC","label ASC","label ASC"),																					// Sort order
            'tabfield'=>array("code,label","code,label","code,label"),																					// List of fields (result of select to show dictionnary)
            'tabfieldvalue'=>array("code,label","code,label","code,label"),																				// List of fields (list of fields to edit a record)
            'tabfieldinsert'=>array("code,label","code,label","code,label"),																			// List of fields (list of fields for insert)
            'tabrowid'=>array("rowid","rowid","rowid"),																									// Name of columns with primary key (try to always name it 'rowid')
            'tabcond'=>array($conf->mymodule->enabled,$conf->mymodule->enabled,$conf->mymodule->enabled)												// Condition to show each dictionnary
        );
        */

        // Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
        $this->boxes = array();			// List of boxes
		$r=0;
		// Example:
		
		$this->boxes[$r][1] = "box_recouvrement@recouvrement";
		$r++;
		/*
		$this->boxes[$r][1] = "myboxb.php";
		$r++;
		*/

		// Permissions
		$this->rights = array();		// Permission array used by this module
		$r=0;

		$this->rights[$r][0] = 104221; 				// Permission id (must not be already used)
		$this->rights[$r][1] = 'Lire les dossiers de recouvrement';	// Permission label
		$this->rights[$r][3] = 1; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'dossier';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'read';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = 104222; 				// Permission id (must not be already used)
		$this->rights[$r][1] = 'Attribuer des factures à un dossier';	// Permission label
		$this->rights[$r][3] = 1; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'dossier';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'write';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;


		$this->rights[$r][0] = 104223; 				// Permission id (must not be already used)
		$this->rights[$r][1] = 'Définir les procedures de recouvrement';	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'dossier';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'admin';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;
		
		
		$this->rights[$r][0] = 104225; 				// Permission id (must not be already used)
		$this->rights[$r][1] = "Accéder à l'onglet des factures payées";	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'dossier';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'factures_payees';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;
		
		
		$this->rights[$r][0] = 104226; 				// Permission id (must not be already used)
		$this->rights[$r][1] = "Peut ajouter un évènement libre";	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'dossier';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'allow_free_events';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;
		
		
		$this->rights[$r][0] = 104220 . $r; 				// Permission id (must not be already used)
		$this->rights[$r][1] = "Autoriser le téléchargement des documents";	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'read';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = '';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		
		// Add here list of permission defined by an id, a label, a boolean and two constant strings.
		// Example:
		// $this->rights[$r][0] = 2000; 				// Permission id (must not be already used)
		// $this->rights[$r][1] = 'Permision label';	// Permission label
		// $this->rights[$r][3] = 1; 					// Permission by default for new user (0/1)
		// $this->rights[$r][4] = 'level1';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		// $this->rights[$r][5] = 'level2';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		// $r++;


		// Main menu entries
		$this->menus = array();			// List of menus to add
		$r=0;

		/*$this->menu[$r]=array(	'fk_menu'=>0,			                // Put 0 if this is a top menu
								'type'=>'top',			                // This is a Top menu entry
								'titre'=>'Recouvrement',
								'mainmenu'=>'recouvrement',
								'leftmenu'=>'recouvrement1',
								'url'=>'/recouvrement/attributionFactures.php',
								'langs'=>'recouvrement@recouvrement',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>200,
								'enabled'=>'$conf->recouvrement->enabled && $user->rights->recouvrement->dossier->read',	// Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled.
								'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;
		*/
		if ((float) DOL_VERSION < 10.0) $mainmenu = 'accountancy';
		else $mainmenu = 'billing';

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu='.$mainmenu,		    // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'Recouvrement',
								'mainmenu'=>$mainmenu,
								'leftmenu'=>'recouvrement',
								'url'=>'/recouvrement/attributionFactures.php',
								'langs'=>'recouvrement@recouvrement',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>110,
								'enabled'=>'$conf->recouvrement->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'$user->rights->recouvrement->dossier->read || $user->rights->recouvrement->dossier->write',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu='.$mainmenu.',fk_leftmenu=recouvrement',		    // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'RecDossierList',
								'mainmenu'=>$mainmenu,
								'leftmenu'=>'recouvrementList',
								'url'=>'/recouvrement/dossier.php?TListTBS[list_llx_rec_dossier][search][statut]=OPEN',
								'langs'=>'recouvrement@recouvrement',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>120,
								'enabled'=>'$conf->recouvrement->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'$user->rights->recouvrement->dossier->read',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu='.$mainmenu.',fk_leftmenu=recouvrementList',		    // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'RecDossierListDraft',
								'mainmenu'=>$mainmenu,
								'leftmenu'=>'recouvrementDraft',
								'url'=>'/recouvrement/dossier.php?TListTBS[list_llx_rec_dossier][search][statut]=DRAFT',
								'langs'=>'recouvrement@recouvrement',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>121,
								'enabled'=>'$conf->recouvrement->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'$user->rights->recouvrement->dossier->read',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu='.$mainmenu.',fk_leftmenu=recouvrementList',		    // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'RecDossierListOpen',
								'mainmenu'=>$mainmenu,
								'leftmenu'=>'recouvrementOpen',
								'url'=>'/recouvrement/dossier.php?TListTBS[list_llx_rec_dossier][search][statut]=OPEN',
								'langs'=>'recouvrement@recouvrement',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>122,
								'enabled'=>'$conf->recouvrement->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'$user->rights->recouvrement->dossier->read',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu='.$mainmenu.',fk_leftmenu=recouvrementList',		    // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'RecDossierListClosed',
								'mainmenu'=>$mainmenu,
								'leftmenu'=>'recouvrementClosed',
								'url'=>'/recouvrement/dossier.php?TListTBS[list_llx_rec_dossier][search][statut]=CLOSED',
								'langs'=>'recouvrement@recouvrement',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>123,
								'enabled'=>'$conf->recouvrement->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'$user->rights->recouvrement->dossier->read',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;




		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu='.$mainmenu.',fk_leftmenu=recouvrement',		    // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'RecAttributionFactureList',
								'mainmenu'=>'',
								'leftmenu'=>$mainmenu,
								'url'=>'/recouvrement/attributionFactures.php',
								'langs'=>'recouvrement@recouvrement',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>130,
								'enabled'=>'$conf->recouvrement->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'$user->rights->recouvrement->dossier->write',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu='.$mainmenu.',fk_leftmenu=recouvrement',		    // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'RecAttributionFactureListAndPaid',
								'mainmenu'=>'',
								'leftmenu'=>$mainmenu,
								'url'=>'/recouvrement/attributionFactures.php?allpaid=1',
								'langs'=>'recouvrement@recouvrement',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>131,
								'enabled'=>'$conf->recouvrement->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'$user->rights->recouvrement->dossier->factures_payees',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>0);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu='.$mainmenu.',fk_leftmenu=recouvrement',		    // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'RecAttributionFactureListAndUnpaid',
								'mainmenu'=>'',
								'leftmenu'=>$mainmenu,
								'url'=>'/recouvrement/attributionFactures.php?allunpaid=1',
								'langs'=>'recouvrement@recouvrement',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>132,
								'enabled'=>'$conf->recouvrement->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'$user->rights->recouvrement->dossier->write',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>0);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu='.$mainmenu.',fk_leftmenu=recouvrement',		    // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'RecAdmin',
								'mainmenu'=>'',
								'leftmenu'=>$mainmenu,
								'url'=>'/recouvrement/admin/procedure.php',
								'langs'=>'recouvrement@recouvrement',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>133,
								'enabled'=>'$conf->recouvrement->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'$user->rights->recouvrement->dossier->admin',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu='.$mainmenu.',fk_leftmenu=recouvrement',		    // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'GraphFacturation',
								'mainmenu'=>$mainmenu,
								'leftmenu'=>'recouvrementList',
								'url'=>'/recouvrement/graph_facturation.php',
								'langs'=>'recouvrement@recouvrement',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>140,
								'enabled'=>'$conf->recouvrement->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;


		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu='.$mainmenu.',fk_leftmenu=recouvrement',		    // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'TopImpayees',
								'mainmenu'=>$mainmenu,
								'leftmenu'=>'recouvrementList',
								'url'=>'/recouvrement/top_facture_impayee.php',
								'langs'=>'recouvrement@recouvrement',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>150,
								'enabled'=>'$conf->recouvrement->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;
		// Exports
		$r=1;


	}

	/**
	 *		Function called when module is enabled.
	 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *		It also creates data directories
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function init($options='')
	{
		global $conf,$langs,$user;
		$sql = array();


		define('INC_FROM_DOLIBARR', true);

		dol_include_once('/recouvrement/config.php');
		dol_include_once('/recouvrement/class/procedure.class.php');
		dol_include_once('/recouvrement/class/dossier.class.php');
		dol_include_once('/recouvrement/class/etape.class.php');
		dol_include_once('/recouvrement/class/prerelance.class.php');


		$ATMdb=new TPDOdb;
		$ATMdb->db->debug=true;

		$o=new TRecProcedure;
		$o->init_db_by_vars($ATMdb);

		$o=new TRecEtape;
		$o->init_db_by_vars($ATMdb);

		$o=new TRecDossier;
		$o->init_db_by_vars($ATMdb);

		$o=new TRecDossierFacture;
		$o->init_db_by_vars($ATMdb);

		$o=new TRecEtapeDocument;
		$o->init_db_by_vars($ATMdb);

		$o=new TRecEtapeHistory;
		$o->init_db_by_vars($ATMdb);

		$o=new TPreRelance($this->db);
		$o->init_db_by_vars($ATMdb);


		$result=$this->load_tables();

		dolibarr_set_const($this->db, 'RECOUVREMENT_CONVERT_TO_PDF', ($conf->global->RECOUVREMENT_CONVERT_TO_PDF) ? $conf->global->RECOUVREMENT_CONVERT_TO_PDF : 1,'chaine',1,'Conversion PDF des documents générés par le module recouvrement',$conf->entity);
		dolibarr_set_const($this->db, 'RECOUVREMENT_WITHOUT_BILLS', ($conf->global->RECOUVREMENT_WITHOUT_BILLS) ? $conf->global->RECOUVREMENT_WITHOUT_BILLS : 0,'chaine',1,'Active ou non la concaténation des PDF facture',$conf->entity);
		
		dol_include_once('/core/class/extrafields.class.php');
		$extrafields=new ExtraFields($this->db);
		$res = $extrafields->addExtraField('rec_no_auto_relance', 'Ne pas envoyer d\'e-mail de relance', 'boolean', 0, '', 'thirdparty');
		$res = $extrafields->addExtraField('rec_exclude_to_process', 'Exclure du processus de recouvrement', 'boolean', 0, '', 'facture', 0, 0, '', 0, 1);

		require_once DOL_DOCUMENT_ROOT.'/cron/class/cronjob.class.php';
		
		$cronjob = new Cronjob($this->db);
		$cronjob->label = 'Relances mail';
		$cronjob->note = '';
		$cronjob->jobtype = 'method';
		$cronjob->frequency = 1;
		$cronjob->unitfrequency = 86400;
		$cronjob->status = 0;
		$cronjob->module_name = 'recouvrement';
		$cronjob->classesname = '/recouvrement/class/prerelance.class.php';
		$cronjob->objectname = 'TPreRelance';
		$cronjob->methodename = 'detectSufferingBills';
		$cronjob->datestart = strtotime(date('Y-m-d 12:00:00'));
		$cronjob->create($user);
		
		return $this->_init($sql, $options);
	}

	/**
	 *		Function called when module is disabled.
	 *      Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function remove($options='')
	{
		$sql = array();

		return $this->_remove($sql, $options);
	}


	/**
	 *		Create tables, keys and data required by module
	 * 		Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * 		and create data commands must be stored in directory /mymodule/sql/
	 *		This function is called by this->init
	 *
	 * 		@return		int		<=0 if KO, >0 if OK
	 */
	function load_tables()
	{
		return $this->_load_tables('/recouvrement/sql/');
	}
}

?>
