<?php

if(!class_exists('TObjetStd')) {
    define('INC_FROM_DOLIBARR', true);
    require __DIR__.'/../config.php';

//var_dump(is_file(__DIR__.'/../config.php'));
}

class TPreRelance extends TObjetStd
{

    function __construct(&$db) {

        $this->db = &$db;

        parent::set_table(MAIN_DB_PREFIX.'rec_prerelance');
        parent::add_champs('fk_model,nb_day', array('type' => 'integer', 'index' => true));

        parent::start();
        parent::_init_vars();
    }

    function detectSufferingBills() {
        global $conf, $user, $langs;
        // facture paye à 0
        // date d'échéance + délai d'attente = NOW()

        dol_include_once('/compta/facture/class/facture.class.php');
        dol_include_once('/core/class/html.formmail.class.php');

        $db = &$this->db;

        $res = $db->query("SELECT fk_model, nb_day FROM ".MAIN_DB_PREFIX."rec_prerelance");

        if($res === false) {
            var_dump($db);
            exit;
        }
        $nbRelance = 0;
        while($objRelance = $db->fetch_object($res)) {
            $date1 = date('Y-m-d', strtotime('-'.$objRelance->nb_day.' day'));
            $date2 = date('Y-m-d', strtotime('-'.($objRelance->nb_day + 8).' day'));

            echo $objRelance->nb_day.' '.$date1.' - '.$date2.' > facts ? <br />';

            $sql = "SELECT f.rowid FROM ".MAIN_DB_PREFIX."facture f
					LEFT JOIN ".MAIN_DB_PREFIX."societe_extrafields sext ON (sext.fk_object = f.fk_soc)
					WHERE f.fk_statut=1
					AND f.paye = 0
					AND f.fk_mode_reglement != 3
					AND f.type IN (0,3)
					AND ((f.date_lim_reglement > f.datef AND f.date_lim_reglement = '".$date1."')
					OR (f.date_lim_reglement = f.datef AND f.date_lim_reglement = '".$date2."'))
					AND (sext.rec_no_auto_relance = 0 OR sext.rec_no_auto_relance IS NULL)
					";

            $resFacture = $db->query($sql);

            if($resFacture === false) {
                var_dump($db);
                exit;
            }
            $TInvoice = array();
            while($objFacture = $db->fetch_object($resFacture)) {
                $facture = new Facture($db);

                if($facture->fetch($objFacture->rowid) > 0) {
                    echo 'F:'.$facture->ref.'<br />';

                    $res = $this->sendMail($facture, $objRelance->fk_model);
                    if($res > 0) $nbRelance++;
                    else $TInvoice[$objFacture->rowid] = '<a href="'.dol_buildpath('/compta/facture/card.php', 2).'?id='.$facture->id.'">'.$facture->ref.'</a>';
                }
            }
            // Envoi d'un mail d'erreur à $user->email si des factures ne se sont pas envoyées
            if(!empty($TInvoice)) {
                $TParams = array(
                    'invoice_list' => $TInvoice,
                    'modelmail' => 'none'
                );
                $this->sendMail($facture, 34, $TParams, true);   // fk_model = 34, pour le modèle "Cron Erreur"
            }
        }

        echo 'END';
        $this->output = $nbRelance.' relances envoyées';
        return 0;
    }

    private function getEMailTemplate($db, $type_template, $user, $outputlangs, $id = 0, $active = 1) {
        $ret = array();

        $sql = "SELECT label, topic, content, lang";
        $sql .= " FROM ".MAIN_DB_PREFIX.'c_email_templates';
        $sql .= " WHERE type_template='".$db->escape($type_template)."'";
        $sql .= " AND entity IN (".getEntity("c_email_templates").")";
        $sql .= " AND (fk_user is NULL or fk_user = 0 or fk_user = ".$user->id.")";
        if($active >= 0) $sql .= " AND active = ".$active;
        if(is_object($outputlangs)) $sql .= " AND (lang = '".$outputlangs->defaultlang."' OR lang IS NULL OR lang = '')";
        if(!empty($id)) $sql .= " AND rowid=".$id;
        $sql .= $db->order("lang,label", "ASC");
        //print $sql;

        $resql = $db->query($sql);
        if($resql) {
            $obj = $db->fetch_object($resql); // Get first found
            if($obj) {
                $ret['label'] = $obj->label;
                $ret['topic'] = $obj->topic;
                $ret['content'] = $obj->content;
                $ret['content_lines'] = $obj->content_lines;
                $ret['lang'] = $obj->lang;
            }
            else {
                $defaultmessage = '';
                if($type_template == 'facture_send') {
                    $defaultmessage = $outputlangs->transnoentities("PredefinedMailContentSendInvoice");
                }
                elseif($type_template == 'facture_relance') {
                    $defaultmessage = $outputlangs->transnoentities("PredefinedMailContentSendInvoiceReminder");
                }
                elseif($type_template == 'propal_send') {
                    $defaultmessage = $outputlangs->transnoentities("PredefinedMailContentSendProposal");
                }
                elseif($type_template == 'supplier_proposal_send') {
                    $defaultmessage = $outputlangs->transnoentities("PredefinedMailContentSendSupplierProposal");
                }
                elseif($type_template == 'order_send') {
                    $defaultmessage = $outputlangs->transnoentities("PredefinedMailContentSendOrder");
                }
                elseif($type_template == 'order_supplier_send') {
                    $defaultmessage = $outputlangs->transnoentities("PredefinedMailContentSendSupplierOrder");
                }
                elseif($type_template == 'invoice_supplier_send') {
                    $defaultmessage = $outputlangs->transnoentities("PredefinedMailContentSendSupplierInvoice");
                }
                elseif($type_template == 'shipping_send') {
                    $defaultmessage = $outputlangs->transnoentities("PredefinedMailContentSendShipping");
                }
                elseif($type_template == 'fichinter_send') {
                    $defaultmessage = $outputlangs->transnoentities("PredefinedMailContentSendFichInter");
                }
                elseif($type_template == 'thirdparty') {
                    $defaultmessage = $outputlangs->transnoentities("PredefinedMailContentThirdparty");
                }

                $ret['label'] = 'default';
                $ret['topic'] = '';
                $ret['content'] = $defaultmessage;
                $ret['content_lines'] = '';
                $ret['lang'] = $outputlangs->defaultlang;
            }

            $db->free($resql);
            return $ret;
        }
        else {
            dol_print_error($db);
            return -1;
        }
    }

    function sendMail(Facture &$object, $fk_model, $TParams = array(), $user_as_recipent = false) {
        global $user, $langs, $conf;
        $db = &$this->db;
        $trackid = 'inv'.$object->id;
        $subject = '';
        $actionmsg = '';
        $actionmsg2 = '';
        $modelmail = empty($TParams['modelmail']) ? 'facture_send' : $TParams['modelmail'];
        $action = 'send';

        $actiontypecode = 'AC_FAC';
        $trigger_name = 'BILL_SENTBYMAIL';
        $paramname = 'id';
        $mode = 'emailfrominvoice';

        $arraydefaultmessage = $this->getEMailTemplate($this->db, $modelmail, $user, $langs, $fk_model);

        $langs->load('mails');

        $sendto = '';
        $sendtocc = '';
        $sendtobcc = '';
        $sendtoid = array();

        $object->fetch_thirdparty();

        include_once DOL_DOCUMENT_ROOT.'/core/class/html.formmail.class.php';
        $formmail = new FormMail($db);
        $formmail->setSubstitFromObject($object, $langs);
        $formmail->substit['__INVREF__'] = $object->ref;
        $formmail->substit['__FACREF__'] = $object->ref;
        $formmail->substit['__DATEECHEANCE__'] = dol_print_date($object->date_lim_reglement);
        if(!empty($TParams['invoice_list'])) $formmail->substit['__INVOICE_LIST__'] = implode("<br/>", $TParams['invoice_list']);

        dol_include_once('/contact/class/contact.class.php');
        $Tab = $object->liste_contact(-1, 'external', 0, 'BILLING');
        foreach($Tab as &$datacontact) {
            if(!empty($datacontact['email'])) {
                $To[] = $datacontact['email'];
                $contact = new Contact($this->db);

                $contact->fetch($datacontact['id']);
                if((float) DOL_VERSION >= 7.0) {
                    $formmail->substit['__CONTACT_NAME_'.$datacontact['code'].'__'] = $contact->getFullName($langs, 1);
                }
                else {
                    $formmail->substit['__CONTACTCIVNAME__'] = $contact->getFullName($langs, 1);
                }
            }
        }
        if(empty($Tab)) {
            if((float) DOL_VERSION >= 7.0) {
                $TCodeContact = $object->liste_type_contact('external', 'rowid', 1, 1);
                foreach($TCodeContact as $contactCode => $dummy) $formmail->substit['__CONTACT_NAME_'.$contactCode.'__'] = '';
            }
            else $formmail->substit['__CONTACTCIVNAME__'] = '';
        }

        if(empty($To)) {
            if(!empty($object->thirdparty->email)) $To[] = $object->thirdparty->email;
        }

//		$To=array('alexis@atm-consulting.fr','mko@atm-consulting.fr');

        if($user_as_recipent) $sendto = $user->email;
        else $sendto = implode(',', $To);

        if(dol_strlen($sendto)) {
            require_once DOL_DOCUMENT_ROOT.'/core/class/CMailFile.class.php';

            // Create form object

            $langs->load("commercial");


            $from = $user->getFullName($langs).' <'.$user->email.'>';
            $replyto = $from;

            $message = $arraydefaultmessage['content'];
            $subject = $arraydefaultmessage['topic'];

//			var_dump($formmail->substit);
            $message = make_substitutions($message, $formmail->substit);
            $subject = make_substitutions($subject, $formmail->substit);

            $sendtobcc = (empty($conf->global->MAIN_MAIL_AUTOCOPY_INVOICE_TO) ? '' : (($sendtobcc ? ", " : "").$conf->global->MAIN_MAIL_AUTOCOPY_INVOICE_TO));

            if($action == 'send' || $action == 'relance') {
                $actionmsg2 = $langs->transnoentities('MailSentBy').' '.CMailFile::getValidAddress($from, 4, 0, 1).' '.$langs->transnoentities('To').' '.CMailFile::getValidAddress($sendto, 4, 0, 1);
                if($message) {
                    $actionmsg = $langs->transnoentities('MailFrom').': '.dol_escape_htmltag($from);
                    $actionmsg = dol_concatdesc($actionmsg, $langs->transnoentities('MailTo').': '.dol_escape_htmltag($sendto));
                    if($sendtocc) $actionmsg = dol_concatdesc($actionmsg, $langs->transnoentities('Bcc').": ".dol_escape_htmltag($sendtocc));
                    $actionmsg = dol_concatdesc($actionmsg, $langs->transnoentities('MailTopic').": ".$subject);
                    $actionmsg = dol_concatdesc($actionmsg, $langs->transnoentities('TextUsedInTheMessageBody').":");
                    $actionmsg = dol_concatdesc($actionmsg, $message);
                }
            }

            $filepath = $filename = $mimetype = array();

            $objectref = dol_sanitizeFileName($object->ref);
            $dir = $conf->facture->dir_output."/".$objectref."/";
            $file = $objectref.".pdf";

            if(is_file($dir.$file)) {

                $filepath = array($dir.$file);
                $filename = array($file);
                $mimetype = array(dol_mimetype($dir.'/'.$file));
            }
            //var_dump($dir.$file,$filepath,$filename,$mimetype);exit;
//echo $subject.' '. $message;
            // Send mail
            $mailfile = new CMailFile($subject, $sendto, $from, $message, $filepath, $mimetype, $filename, $sendtocc, $sendtobcc, $deliveryreceipt, -1, '', '', $trackid);
            if($mailfile->error) {
                echo 'ERR '.$mailfile->error.'<br />';
                dol_syslog($mailfile->error, LOG_ERR);
                $action = 'presend';
                return -1;
            }
            else {
                $result = $mailfile->sendfile();
                if($result) {
                    $error = 0;

                    echo ' --> '.$sendto.'<br />';

                    // Initialisation of datas
                    if(is_object($object)) {
                        $object->socid = $sendtosocid; // To link to a company
                        $object->sendtoid = $sendtoid; // To link to contacts/addresses. This is an array.
                        $object->actiontypecode = $actiontypecode;
                        $object->actionmsg = $actionmsg;  // Long text
                        $object->actionmsg2 = $actionmsg2; // Short text
                        $object->trackid = $trackid;
                        $object->fk_element = $object->id;
                        $object->elementtype = $object->element;

                        // Call of triggers
                        include_once DOL_DOCUMENT_ROOT.'/core/class/interfaces.class.php';
                        $interface = new Interfaces($db);
                        $result = $interface->run_triggers($trigger_name, $object, $user, $langs, $conf);
                        if($result < 0) {
                            $error++;
                            $errors = $interface->errors;
                        }
                    }

                    if($error) {
                        echo 'ERR1 '.$db->lasterror.'<br />';
                        dol_syslog($db->lasterror, LOG_ERR);
                        return -1;
                    }
                }
                else {
                    $langs->load("other");
                    $mesg = '';
                    if($mailfile->error) {
                        $mesg .= $langs->trans('ErrorFailedToSendMail', $from, $sendto);
                        $mesg .= ' - '.$mailfile->error;
                    }
                    else {
                        $mesg .= ' - No mail sent. Feature is disabled by option MAIN_DISABLE_ALL_MAILS';
                    }

                    echo 'ERR2 '.$mesg.'<br />';
                    dol_syslog($mesg, LOG_ERR);
                    return -1;
                }
            }
        }
        else {
            $langs->load("errors");
            setEventMessages($langs->trans('ErrorFieldRequired', $langs->transnoentitiesnoconv("MailTo")), null, 'warnings');
            dol_syslog('Try to send email with no recipiend defined', LOG_WARNING);
            $action = 'presend';
            return -1;
        }


        return 1;
    }

}
