<?php

require('../config.php');
dol_include_once('/recouvrement/lib/recouvrement.lib.php');
dol_include_once('/core/lib/admin.lib.php');

if (!($user->rights->recouvrement->dossier->admin)) accessforbidden();

/**
 * Actions
 */

$action = GETPOST('action', 'alpha');

if (preg_match('/set_(.*)/',$action,$reg))
{
	$code=$reg[1];
	$val = GETPOST($code);
	if(is_array($val)) $val = serialize($val);
	if (dolibarr_set_const($db, $code, $val, 'chaine', 0, '', $conf->entity) > 0)
	{
		header("Location: ".$_SERVER["PHP_SELF"]);
		exit;
	}
	else
	{
		dol_print_error($db);
	}
}

require('../class/etape.class.php');
require('../class/procedure.class.php');

llxHeader('',$langs->trans('configuration'));

$head = recouvrement_admin_prepare_head();

dol_fiche_head($head, 'configuration', $langs->trans("configuration"), 0, 'recouvrementico@recouvrement');

$var=false;
print '<table class="noborder" width="100%">';
print '<tr class="liste_titre">';
print '<td>'.$langs->trans("Parameters").'</td>'."\n";
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="center" width="100">'.$langs->trans("Value").'</td>'."\n";

$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>Gérer les dossiers uniquement pour les maisons mères</td>';
print '<td align="center" width="20">&nbsp;</td>';

print '<td align="center" width="300">';
print ajax_constantonoff('RECOUVREMENT_PARENT_CASE');
print '</td></tr>';

$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->trans('ConvertDocuPDF').img_help(1,$langs->trans('ConvertDocuPDFNeeds')).'</td>';
print '<td align="center" width="20">&nbsp;</td>';

print '<td align="center" width="300">';
print ajax_constantonoff('RECOUVREMENT_CONVERT_TO_PDF');
print '</td></tr>';

/*print '<tr>';
print '<td>Ne pas concaténer les PDF facture</td>';
print '<td align="center" width="20">&nbsp;</td>';

print '<td align="center" width="300">';
print ajax_constantonoff('RECOUVREMENT_WITHOUT_BILLS');*/
print '</td></tr>';

$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>Ne pas afficher les factures avec un trop perçu dans les factures à recouvrer</td>';
print '<td align="center" width="20">&nbsp;</td>';

print '<td align="center" width="300">';
print ajax_constantonoff('RECOUVREMENT_DONT_SHOW_OVERPAYMENT');
print '</td></tr>';

$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->transnoentitiesnoconv('recouvrementDisplayTotalAmount').'</td>';
print '<td align="center" width="20">&nbsp;</td>';

print '<td align="center" width="300">';
print ajax_constantonoff('RECOUVREMENT_DISPLAY_TOTAL_AMOUNT');
print '</td></tr>';

$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->transnoentitiesnoconv('recouvrementDisplayProjectInList').'</td>';
print '<td align="center" width="20">&nbsp;</td>';

print '<td align="center" width="300">';
print ajax_constantonoff('RECOUVREMENT_SHOW_PROJECT');
print '</td></tr>';

$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->transnoentitiesnoconv('recouvrementDisplayProv').'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="center" width="300">';
print ajax_constantonoff('RECOUVREMENT_ALLOW_PROV');
print '</td></tr>';

$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->transnoentitiesnoconv('recouvrementDisplayedTypes').'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="center" width="300">';
print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="set_RECOUVREMENT_ALLOWED_TYPES">';
print $form->multiselectarray('RECOUVREMENT_ALLOWED_TYPES', array(2=>'Avoirs', 3=>'Acomptes', 5=>'Situations'), unserialize($conf->global->RECOUVREMENT_ALLOWED_TYPES), 0, 0, '', 0, 0, 'multiple style="overflow-y: auto;min-width: 150px"');
print '<input type="submit" class="button" value="'.$langs->trans("Modify").'">';
print '</form>';
print '</td></tr>';

$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->transnoentitiesnoconv('recouvrementDeleteFactureSolde').'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="center" width="300">';
print ajax_constantonoff('RECOUVREMENT_DELETE_SOLDE');
print '</td></tr>';

$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->trans("recouvrementExcludedTypesPaiement").'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="right" width="300">';
print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="set_RECOUVREMENT_EXCLUDED_TYPES_PAIEMENT">';

$TTypesPaiement = array();
$sql = "SELECT id, code, libelle, type, active FROM ".MAIN_DB_PREFIX."c_paiement WHERE active = 1 and id > 0";
$resql = $db->query($sql);
while($res = $db->fetch_object($resql)) $TTypesPaiement[$res->id] = $res->libelle;

$form = new Form($db);
print $form->multiselectarray('RECOUVREMENT_EXCLUDED_TYPES_PAIEMENT', $TTypesPaiement, unserialize($conf->global->RECOUVREMENT_EXCLUDED_TYPES_PAIEMENT), 0, 0, '', 0, 0, 'multiple style="overflow-y: auto;min-width: 150px"');
print '<input type="submit" class="button" value="'.$langs->trans("Modify").'">';
print '</form>';
print '</td></tr>';



$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->trans("RECOUVREMENT_FORMAT_EXCEL").'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="right" width="300">';
print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="set_RECOUVREMENT_FORMAT_EXCEL">';
$form = new Form($db);
echo $form->selectarray('RECOUVREMENT_FORMAT_EXCEL', array('.ods'=>'OpenDocumentSheet', '.xlsx'=>'Excel 2010 & +'), $conf->global->RECOUVREMENT_FORMAT_EXCEL);

print '<input type="submit" class="button" value="'.$langs->trans("Modify").'">';
print '</form>';
print '</td></tr>';


$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->transnoentitiesnoconv('recouvrementFolderListShowAllFiles').'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="center" width="300">';
print ajax_constantonoff('RECOUVREMENT_FOLDER_LIST_SHOWALLFILES');
print '</td></tr>';

$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->transnoentitiesnoconv('recouvrementShowSelectFolderInList').'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="center" width="300">';
print ajax_constantonoff('RECOUVREMENT_SHOW_SELECT_FOLDER');
print '</td></tr>';

print "</table>";

print '<br />';

print '<div style="text-align: right;">';
print '<a href="' . dol_buildpath('/recouvrement/script/autoRecouvrement.php', 1) . '" class="butAction">Générer les dossiers de recouvrement</a>';
print '</div>';

print '<br />';

llxFooter();
