-- --------------------------------------------------------

--
-- Structure de la table `llx_prelevementpf_bons`
--

CREATE TABLE `llx_prelevementpf_bons` (
 `rowid` int(11) NOT NULL AUTO_INCREMENT,
 `type` varchar(16) DEFAULT 'debit-order',
 `ref` varchar(12) DEFAULT NULL,
 `entity` int(11) NOT NULL DEFAULT '1',
 `datec` datetime DEFAULT NULL,
 `amount` double(24,8) DEFAULT '0.00000000',
 `statut` smallint(6) DEFAULT '0',
 `credite` smallint(6) DEFAULT '0',
 `note` text,
 `date_trans` datetime DEFAULT NULL,
 `method_trans` smallint(6) DEFAULT NULL,
 `fk_user_trans` int(11) DEFAULT NULL,
 `date_credit` datetime DEFAULT NULL,
 `fk_user_credit` int(11) DEFAULT NULL,
 `code_banque` varchar(128) DEFAULT NULL,
 `code_guichet` varchar(5) DEFAULT NULL,
 `numero_compte` varchar(11) DEFAULT NULL,
 `cle_rib` varchar(2) DEFAULT NULL,
 `fk_prelevementbank` int(11) DEFAULT NULL,
 `file_prelevement` varchar(512) DEFAULT NULL,
 `file_rejet` varchar(512) DEFAULT NULL,
 PRIMARY KEY (`rowid`),
 UNIQUE KEY `uk_prelevementpf_bons_ref` (`ref`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `llx_prelevementpf_facture`
--

CREATE TABLE IF NOT EXISTS `llx_prelevementpf_facture` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_facture` int(11) DEFAULT NULL,
  `fk_facture_fourn` int(11) DEFAULT NULL,
  `fk_prelevementpf_lignes` int(11) NOT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_prelevementpf_facture_fk_prelevementpf_lignes` (`fk_prelevementpf_lignes`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `llx_prelevementpf_facture_demande`
--

CREATE TABLE IF NOT EXISTS `llx_prelevementpf_facture_demande` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `fk_facture` int(11) DEFAULT NULL,
  `fk_facture_fourn` int(11) DEFAULT NULL,
  `sourcetype` varchar(32) DEFAULT NULL,
  `amount` double(24,8) NOT NULL,
  `date_demande` datetime NOT NULL,
  `traite` smallint(6) DEFAULT '0',
  `date_traite` datetime DEFAULT NULL,
  `fk_prelevementpf_bons` int(11) DEFAULT NULL,
  `fk_user_demande` int(11) NOT NULL,
  `code_banque` varchar(128) DEFAULT NULL,
  `code_guichet` varchar(6) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `cle_rib` varchar(5) DEFAULT NULL,
  `ext_payment_id` varchar(128) DEFAULT NULL,
  `ext_payment_site` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_prelevementpf_facture_demande_fk_facture` (`fk_facture`),
  KEY `idx_prelevementpf_facture_demande_fk_facture_fourn` (`fk_facture_fourn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `llx_prelevementpf_lignes`
--

CREATE TABLE IF NOT EXISTS `llx_prelevementpf_lignes` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_prelevementpf_bons` int(11) DEFAULT NULL,
  `fk_soc` int(11) NOT NULL,
  `statut` smallint(6) DEFAULT '0',
  `client_nom` varchar(255) DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `code_banque` varchar(128) DEFAULT NULL,
  `code_guichet` varchar(6) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `cle_rib` varchar(5) DEFAULT NULL,
  `note` text,
  PRIMARY KEY (`rowid`),
  KEY `idx_prelevementpf_lignes_fk_prelevementpf_bons` (`fk_prelevementpf_bons`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `llx_prelevementpf_rejet`
--

CREATE TABLE IF NOT EXISTS `llx_prelevementpf_rejet` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_prelevementpf_lignes` int(11) DEFAULT NULL,
  `date_rejet` datetime DEFAULT NULL,
  `motif` int(11) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `fk_user_creation` int(11) DEFAULT NULL,
  `note` text,
  `afacturer` tinyint(4) DEFAULT '0',
  `fk_facture` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


--
-- Contraintes pour la table `llx_prelevementpf_facture`
--
ALTER TABLE `llx_prelevementpf_facture`
  ADD CONSTRAINT `fk_prelevementpf_facture_fk_prelevementpf_lignes` FOREIGN KEY (`fk_prelevementpf_lignes`) REFERENCES `llx_prelevementpf_lignes` (`rowid`);

--
-- Contraintes pour la table `llx_prelevementpf_lignes`
--
ALTER TABLE `llx_prelevementpf_lignes`
  ADD CONSTRAINT `fk_prelevementpf_lignes_fk_prelevementpf_bons` FOREIGN KEY (`fk_prelevementpf_bons`) REFERENCES `llx_prelevementpf_bons` (`rowid`);



--
-- Structure de la table `llx_prelevementpf_bank`
--
DROP TABLE IF EXISTS `llx_prelevementpf_bank`;
CREATE TABLE `llx_prelevementpf_bank` (
  `rowid` int(11) NOT NULL,
  `code` varchar(5) NOT NULL,
  `name` varchar(64) NOT NULL,
  `shortname` varchar(8) NOT NULL,
  `address` varchar(64) NOT NULL,
  `pobox` varchar(16) NOT NULL,
  `zipcode` varchar(5) NOT NULL,
  `town` varchar(32) NOT NULL,
  `fk_prelevementbank` int(11) 
);
--
-- Contenu de la table `llx_prelevementpf_bank`
--
INSERT INTO `llx_prelevementpf_bank` (`rowid`, `code`, `name`, `shortname`, `address`, `pobox`, `zipcode`, `town`, `fk_prelevementbank`) VALUES
(1, '12239', 'Banque de Tahiti', 'BT', '38, rue François Cardella', '1602', '98713', 'Papeete', 1),
(2, '12149', 'Banque de Polynésie', 'BP', '355, boulevard Pomare', '530', '98713', 'Papeete', 2),
(3, '17469', 'Banque Socredo', 'SOC', "115, rue Dumont d'Urville", '130', '98713', 'Papeete', 3),
(4, '14168', 'Centre de Chèques Postaux', 'CCP', '8, rue de la Reine Pomare IV', '605', '98713', 'Papeete', 2);
--
-- Index pour la table `llx_prelevementpf_bank`
--
ALTER TABLE `llx_prelevementpf_bank`
  ADD PRIMARY KEY (`rowid`);
--
-- AUTO_INCREMENT pour la table `llx_prelevementpf_bank`
--
ALTER TABLE `llx_prelevementpf_bank`
  MODIFY `rowid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

-- --------------------------------------------------------
--
-- Structure de la table `llx_prelevementpf_prelevementbank`
--

DROP TABLE IF EXISTS `llx_prelevementpf_prelevementbank`;
CREATE TABLE IF NOT EXISTS `llx_prelevementpf_prelevementbank` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code_banque` varchar(5) NOT NULL,
  `libelle_compte` varchar(64) NOT NULL,
  `filename_ap` varchar(64) NOT NULL,
  `file_prelevement` varchar(512) NOT NULL COMMENT 'modele de nom du fichier de prelevement',
  `file_rejet` varchar(512) NOT NULL COMMENT 'modele du fichier pour le fichier de rejet',
  `fk_bank_account` int(11) NOT NULL,
  `active` tinyint(1) NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `llx_prelevementpf_prelevementbank`
--

INSERT INTO `llx_prelevementpf_prelevementbank` (`rowid`, `code_banque`, `libelle_compte`, `filename_ap`, `file_prelevement`, `file_rejet`, `fk_bank_account`, `active`) VALUES
(1, '12239', 'Banque de Tahiti', '-', 'PRE{T%m%d}.txt', 'PREVIR du \\d{2}\\.\\d{2}\\.\\d{2} BT.AT\\d', 0, 1),
(2, '12149', 'Banque de Polynésie', '-', 'PRE{P%m%d}.txt', 'R0605175 du \\d{2}\\.\\d{2}\\.\\d{2}\\ BP.\\d+', 0, 1),
(3, '17469', 'Banque Socredo', '-', 'PRPMTSOC.env', 'PRSOCPMT_\\d{8}_\\d{2}h\\d{2}m\\d{2}s.RET', 0, 1);


-- --------------------------------------------------------
--
-- Structure de la table `llx_prelevementpf_bankrejectcode`
--
DROP TABLE IF EXISTS `llx_prelevementpf_bankrejectcode`;
CREATE TABLE IF NOT EXISTS `llx_prelevementpf_bankrejectcode` (
  `code` varchar(2) NOT NULL,
  `label` varchar(32) NOT NULL,
  `description` varchar(256) NOT NULL,
  PRIMARY KEY (`code`)
);

--
-- Contenu de la table `llx_prelevementpf_bankrejectcode`
--
INSERT INTO `llx_prelevementpf_bankrejectcode` (`code`, `label`, `description`) VALUES
('12', 'COORD. BANC. INEXPLOIT.', 'Les coordonnées bancaires du destinataire IBAN/BIC ou code établissement/code guichet/numéro de compte ne sont pas reconnues par la banque domiciliataire.'),
('14', 'CPTE SOLDE CLOTURE VIRE', 'Le client a soldé son compte ou bien le compte a été clôturé, transféré dans un autre guichet de la banque ou du groupe bancaire.'),
('16', 'DESTINATAIRE NON RECONNU', 'Le nom du destinataire n''est pas précisé ou ne correspond pas aux coordonnées bancaires.'),
('18', 'EMETTEUR NON RECONNU', 'Émetteur non précisé ou non identifiable.'),
('20', 'PROVISION INSUFFISANTE', 'Absence totale ou partielle de provision, le rejet étant fait pour la totalité du montant.'),
('31', 'PAS D’AUTORISATION', 'La banque n''a pas reçu l''autorisation de prélèvement ou le client a effectué une révocation de l’autorisation de prélèvement'),
('32', 'DECISION JUDICIAIRE', 'Le débiteur a fait l’objet d’une décision de justice au titre d’une procédure collective.'),
('34', 'OPPOSITION SUR COMPTE', 'Le compte du bénéficiaire est frappé d''opposition ou bloqué. La date d''opposition doit précéder la date de règlement interbancaire de l''opération.'),
('35', 'TITULAIRE DECEDE', 'Titulaire du compte décédé (bénéficiaire)'),
('52', 'CODE OPERATION INCORRECT', 'Le code opération indiqué est incorrect'),
('54', 'ADRESSE INVALIDE', 'L’adresse indiquée ne correspond pas à celle du titulaire du compte.'),
('57', 'FORMAT INVALIDE', 'Format de fichier invalide.'),
('58', 'SUR ORDRE DU CLIENT ', 'Sur ordre du client/refus du débiteur'),
('59', 'RAISON NON COMMUNIQUEE ', 'La banque destinataire n’a pas communiqué de raison spécifique.'),
('60', 'CODE BANQUE INCORRECT ', 'Le code BIC de la banque destinataire est inexploitable.'),
('61', 'HEURE LIMITE DEPASSEE ', 'Fichier reçu après le cut-off time (heure limite)'),
('62', 'MOTIF REGLEMENTAIRE', 'Le rejet/retour est dû à une contrainte réglementaire (ex : une donnée réglementaire est absente)'),
('64', 'DOUBLON', 'Opération dupliquée.'),
('66', 'DONNEE MANDAT INCORRECTE', 'Une ou plusieurs données du mandat sont absentes ou erronées. S’applique au rejet (Reject).'),
('71', 'RECU A TORT / DEJA REGLE', 'Opération reçue à tort'),
('75', 'DEMANDE DE PROROGATION X', 'Bien que la date d''échéance de l''opération soit bien celle qui a été convenue, le débiteur demande un délai supplémentaire pour payer'),
('76', 'RECLAMATION TARDIVE', 'Réclamation tardive de l’émetteur.'),
('80', 'CONTESTATION DEBITEUR', 'Contestation par le débiteur d’une transaction autorisée dans les 8 semaines qui suivent le débit'),
('88', 'BANQUE HORS ECHANGES', 'La banque qui assurait les échanges ou la banque domiciliataire ne participe plus aux échanges.'),
('99', 'OPERATION NON ADMISE', 'Pour des raisons réglementaires, ce compte n''admet pas les virements (nationaux et SEPA)');
