<?php
/* Copyright (C) 2005      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2005-2014 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2010 Regis Houssin        <regis.houssin@inodbox.com>
 * Copyright (C) 2010-2013 Juanjo Menent        <jmenent@2byte.es>
 * Copyright (C) 2019      Markus Welters       <markus@welters.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 *	\file       htdocs/admin/prelevementpf.php
*	\ingroup    prelevementpf
 *	\brief      Page to setup Withdrawals
 */

require '../../../main.inc.php';
dol_include_once('/prelevementpf/class/bonprelevementpf.class.php');
dol_include_once('/core/lib/admin.lib.php');
dol_include_once('/compta/bank/class/account.class.php');
dol_include_once('/prelevementpf/lib/prelevementpf.lib.php');

// Load translation files required by the page
$langs->loadLangs(array("admin", "withdrawals"));

// Security check
if (!$user->admin) accessforbidden();

$action = GETPOST('action', 'aZ09');
$type = 'paymentorder';

$error = 0;

$t_prelevementbank = prelevementpf_getprelevementbank();


/*
 * Actions
 */

if ($action == "set")
{
//	$db->begin();

    foreach($t_prelevementbank as $pb){
        $key = 'fk_bank_account_'.$pb->rowid;
        $fk_bank_account = GETPOST($key, 'int');
        prelevementpf_set_bank_account($pb->rowid, $fk_bank_account);
    }
    $t_prelevementbank = prelevementpf_getprelevementbank();

	$res = dolibarr_set_const($db, "PRELEVEMENTPF_NNE", GETPOST("PRELEVEMENTPF_NNE"), 'chaine', 0, '', $conf->entity);
	if (!($res > 0)) $error++;

    if (GETPOST("PRELEVEMENTPF_USER") > 0) {
        $res = dolibarr_set_const($db, "PRELEVEMENTPF_USER", GETPOST("PRELEVEMENTPF_USER"), 'chaine', 0, '', $conf->entity);
        if (! ($res > 0)) $error++;
    }
}

/*
 *	View
 */
//echo "<pre>";var_dump($t_prelevementbank) ;echo "</pre>";////

$form = new Form($db);

$dirmodels = array_merge(array('/'), (array) $conf->modules_parts['models']);

llxHeader('', $langs->trans("WithdrawalsSetup"));

$linkback = '<a href="'.DOL_URL_ROOT.'/admin/modules.php?restore_lastsearch_values=1">'.$langs->trans("BackToModuleList").'</a>';

print load_fiche_titre($langs->trans("WithdrawalsSetup"), $linkback, 'title_setup');
print '<br>';

print '<form method="post" action="'.$_SERVER["PHP_SELF"].'?action=set">';
print '<input type="hidden" name="token" value="'.newToken().'">';

print '<table class="noborder centpercent">';

print '<tr class="liste_titre">';
print '<td class="titlefieldcreate">'.$langs->trans("Parameter").'</td>';
print '<td>'.$langs->trans("Value").'</td>';
print "</tr>";

// Bank account (from Banks module)
foreach($t_prelevementbank as $pb){
    $bank = "";
    foreach($pb->prelevementbank as $b){
        $bank .= ($bank?", ":"").$b->shortname;
    }
    print '<tr class="oddeven"><td class="">'.$langs->trans('PrelevementPFAdminAccountDesc',$pb->libelle_compte,$bank).'</td>';
    print '<td class="left">';
    $form->select_comptes($pb->fk_bank_account, 'fk_bank_account_'.$pb->rowid, 0, 'number LIKE "'.$pb->banque_prelevement.'%"', 1);
    print '</td></tr>';
}

// NUMERO NATIONAL EMETTEUR
print '<tr class="oddeven"><td class="fieldrequired">';
$htmltext = $langs->trans("AskThisIDToYourBank");
print $form->textwithpicto($langs->trans("NNE"), $htmltext);
print '</td>';
print '<td class="left">';
print '<input type="text" name="PRELEVEMENTPF_NNE" value="'.$conf->global->PRELEVEMENTPF_NNE.'" size="15" >';
print '</td>';
print '</td></tr>';

//USER
print '<tr class="oddeven"><td class="fieldrequired">'.$langs->trans("ResponsibleUser").'</td>';
print '<td class="left">';
print $form->select_dolusers($conf->global->PRELEVEMENTPF_USER, 'PRELEVEMENTPF_USER', 1, '', 0, '', '', 0, 0, 0, '', 0, '', 'maxwidth300');
print '</td>';
print '</tr>';


print '</table>';
print '<br>';

print '<div class="center"><input type="submit" class="button button-save" value="'.$langs->trans("Save").'"></div>';

print '</form>';


print '<br>';




print dol_get_fiche_end();

print '<br>';


// End of page
llxFooter();




$db->close();