<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2012-2013 jacquel jerome <icfr.eirl@free.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * 	\file		mypage.php
 * 	\ingroup	mymodule
 * 	\brief		This file is an example php page
 * 				Put some comments here
 */
$res = 0;
if (!$res && file_exists("../main.inc.php")) {
    $res = @include("../main.inc.php");
}
if (!$res && file_exists("../../main.inc.php")) {
    $res = @include("../../main.inc.php");
}
if (!$res && file_exists("../../../main.inc.php")) {
    $res = @include("../../../main.inc.php");
}
require_once DOL_DOCUMENT_ROOT . '/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.formpropal.class.php';
require_once DOL_DOCUMENT_ROOT . '/comm/propal/class/propal.class.php';
require_once DOL_DOCUMENT_ROOT . '/comm/action/class/actioncomm.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/modules/propale/modules_propale.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/propal.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/functions2.lib.php';
if (!empty($conf->projet->enabled))
    require_once DOL_DOCUMENT_ROOT . '/projet/class/project.class.php';
$res = 0;
if (!$res && file_exists(DOL_DOCUMENT_ROOT . "/echeancier/class/echeancier.class.php"))
    $res = include(DOL_DOCUMENT_ROOT . "/echeancier/class/echeancier.class.php");
if (!$res && file_exists("./class/echeancier.class.php"))
    $res = include("./class/echeancier.class.php");
if (!$res)
    die("Include of echeancier class fails");
$echeancier = new echeancier($db);
$echeancier->fetch(GETPOST('ide'));
if (!$user->rights->facture->lire || !$user->rights->echeancier->propale)
    accessforbidden();

if (GETPOST('action') == 'modife') {


    $sql = "";
    $count = GETPOST('count');

    for ($i = 0; $i < $count; $i++) {

        $date = strftime("%Y-%m-%d", mktime(0, 0, 0, GETPOST('dated' . $i . 'month'), GETPOST('dated' . $i . 'day'), GETPOST('dated' . $i . 'year')));
        $sql = " update " . MAIN_DB_PREFIX . "echeance set date_reglement='" . $date . "', montant='" . GETPOST('montant' . $i) . "' where rowid='" . GETPOST('id' . $i) . "';";
        $db->query($sql);
    }

    header('location:fiche_propale.php?id='.$echeancier->id_element );
}
$echeancier->fetch(GETPOST('ide'));
$id = $echeancier->id_element;
$ref = $echeancier->ref;
$socid = GETPOST('socid', 'int');
$form = new Form($db);
$langs->load("echeancier@echeancier");
$langs->load('companies');
$langs->load('propal');
$langs->load('compta');
$langs->load('bills');
$langs->load('orders');
$langs->load('products');
if (!empty($conf->margin->enabled))
    $langs->load('margins');
$object = new Propal($db);

if ($ide > 0 || !empty($ref)) {
    if ($action != 'add') {
        $ret = $object->fetch($echeancier->id_element, $echeancier->ref);
        if ($ret == 0) {
            $langs->load("errors");
            setEventMessage($langs->trans('ErrorRecordNotFound'), 'errors');
            $error++;
        } else if ($ret < 0) {
            setEventMessage($object->error, 'errors');
            $error++;
        }
        else
            $object->fetch_thirdparty();
    }
}
else {
    

    exit;
}
$css = array('/echeancier/css/styles.css');
llxHeader('', 'Echeancier', '', '', '', '', $js, $css);
print_fiche_titre($langs->trans("échéancier du client"));

$form = new Form($db);
$formother = new FormOther($db);
$formfile = new FormFile($db);
$formpropal = new FormPropal($db);
$companystatic = new Societe($db);

$now = dol_now();

/*
 * Show object in view mode
 */

$soc = new Societe($db);
$soc->fetch($object->socid);

$head = propal_prepare_head($object);
dol_fiche_head($head, 'tabEcheancier', $langs->trans('Proposal'), 0, 'propal');

$formconfirm = '';

print '<table class="border" width="100%">';

$linkback = '<a href="' . DOL_URL_ROOT . '/comm/propal/list.php' . (!empty($socid) ? '?socid=' . $socid : '') . '">' . $langs->trans("BackToList") . '</a>';

// Ref
print '<tr><td>' . $langs->trans('Ref') . '</td><td colspan="5">';
print $form->showrefnav($object, 'ref', $linkback, 1, 'ref', 'ref', '');
print '</td></tr>';

// Ref client
print '<tr><td>';
print '<table class="nobordernopadding" width="100%"><tr><td nowrap="nowrap">';
print $langs->trans('RefCustomer') . '</td><td align="left">';
print '</td>';
if ($action != 'refclient' && !empty($object->brouillon))
    print '<td align="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=refclient&amp;id=' . $object->id . '">' . img_edit($langs->trans('Modify')) . '</a></td>';
print '</tr></table>';
print '</td><td colspan="5">';
if ($user->rights->propal->creer && $action == 'refclient') {
    print '<form action="propal.php?id=' . $object->id . '" method="post">';
    print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
    print '<input type="hidden" name="action" value="set_ref_client">';
    print '<input type="text" class="flat" size="20" name="ref_client" value="' . $object->ref_client . '">';
    print ' <input type="submit" class="button" value="' . $langs->trans('Modify') . '">';
    print '</form>';
} else {
    print $object->ref_client;
}
print '</td>';
print '</tr>';

// Company
print '<tr><td>' . $langs->trans('Company') . '</td><td colspan="5">' . $soc->getNomUrl(1) . '</td>';
print '</tr>';

// Ligne info remises tiers
print '<tr><td>' . $langs->trans('Discounts') . '</td><td colspan="5">';
if ($soc->remise_client)
    print $langs->trans("CompanyHasRelativeDiscount", $soc->remise_client);
else
    print $langs->trans("CompanyHasNoRelativeDiscount");
print '. ';
$absolute_discount = $soc->getAvailableDiscounts('', 'fk_facture_source IS NULL');
$absolute_creditnote = $soc->getAvailableDiscounts('', 'fk_facture_source IS NOT NULL');
$absolute_discount = price2num($absolute_discount, 'MT');
$absolute_creditnote = price2num($absolute_creditnote, 'MT');
if ($absolute_discount) {
    if ($object->statut > 0) {
        print $langs->trans("CompanyHasAbsoluteDiscount", price($absolute_discount), $langs->transnoentities("Currency" . $conf->currency));
    } else {
        // Remise dispo de type non avoir
        $filter = 'fk_facture_source IS NULL';
        print '<br>';
        $form->form_remise_dispo($_SERVER["PHP_SELF"] . '?id=' . $object->id, 0, 'remise_id', $soc->id, $absolute_discount, $filter);
    }
}
if ($absolute_creditnote) {
    print $langs->trans("CompanyHasCreditNote", price($absolute_creditnote), $langs->transnoentities("Currency" . $conf->currency)) . '. ';
}
if (!$absolute_discount && !$absolute_creditnote)
    print $langs->trans("CompanyHasNoAbsoluteDiscount") . '.';
print '</td></tr>';

// Date of proposal
print '<tr>';
print '<td>';
print '<table class="nobordernopadding" width="100%"><tr><td>';
print $langs->trans('Date');
print '</td>';
if ($action != 'editdate' && !empty($object->brouillon))
    print '<td align="right"><a href="' . $_SERVER["PHP_SELF"] . '?action=editdate&amp;id=' . $object->id . '">' . img_edit($langs->trans('SetDate'), 1) . '</a></td>';
print '</tr></table>';
print '</td><td colspan="3">';
if (!empty($object->brouillon) && $action == 'editdate') {
    print '<form name="editdate" action="' . $_SERVER["PHP_SELF"] . '?id=' . $object->id . '" method="post">';
    print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
    print '<input type="hidden" name="action" value="setdate">';
    $form->select_date($object->date, 're', '', '', 0, "editdate");
    print '<input type="submit" class="button" value="' . $langs->trans('Modify') . '">';
    print '</form>';
} else {
    if ($object->date) {
        print dol_print_date($object->date, 'daytext');
    } else {
        print '&nbsp;';
    }
}
print '</td>';

// Date end proposal
print '<tr>';
print '<td>';
print '<table class="nobordernopadding" width="100%"><tr><td>';
print $langs->trans('DateEndPropal');
print '</td>';
if ($action != 'editecheance' && !empty($object->brouillon))
    print '<td align="right"><a href="' . $_SERVER["PHP_SELF"] . '?action=editecheance&amp;id=' . $object->id . '">' . img_edit($langs->trans('SetConditions'), 1) . '</a></td>';
print '</tr></table>';
print '</td><td colspan="3">';
if (!empty($object->brouillon) && $action == 'editecheance') {
    print '<form name="editecheance" action="' . $_SERVER["PHP_SELF"] . '?id=' . $object->id . '" method="post">';
    print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
    print '<input type="hidden" name="action" value="setecheance">';
    $form->select_date($object->fin_validite, 'ech', '', '', '', "editecheance");
    print '<input type="submit" class="button" value="' . $langs->trans('Modify') . '">';
    print '</form>';
} else {
    if (!empty($object->fin_validite)) {
        print dol_print_date($object->fin_validite, 'daytext');
        if ($object->statut == 1 && $object->fin_validite < ($now - $conf->propal->cloture->warning_delay))
            print img_warning($langs->trans("Late"));
    }
    else {
        print '&nbsp;';
    }
}
print '</td>';
print '</tr>';

// Payment term
print '<tr><td>';
print '<table class="nobordernopadding" width="100%"><tr><td>';
print $langs->trans('PaymentConditionsShort');
print '</td>';
if ($action != 'editconditions' && !empty($object->brouillon))
    print '<td align="right"><a href="' . $_SERVER["PHP_SELF"] . '?action=editconditions&amp;id=' . $object->id . '">' . img_edit($langs->transnoentitiesnoconv('SetConditions'), 1) . '</a></td>';
print '</tr></table>';
print '</td><td colspan="3">';
if ($action == 'editconditions') {
    $form->form_conditions_reglement($_SERVER['PHP_SELF'] . '?id=' . $object->id, $object->cond_reglement_id, 'cond_reglement_id');
} else {
    $form->form_conditions_reglement($_SERVER['PHP_SELF'] . '?id=' . $object->id, $object->cond_reglement_id, 'none');
}
print '</td>';
print '</tr>';

// Delivery date
$langs->load('deliveries');
print '<tr><td>';
print '<table class="nobordernopadding" width="100%"><tr><td>';
print $langs->trans('DeliveryDate');
print '</td>';
if ($action != 'editdate_livraison' && !empty($object->brouillon))
    print '<td align="right"><a href="' . $_SERVER["PHP_SELF"] . '?action=editdate_livraison&amp;id=' . $object->id . '">' . img_edit($langs->transnoentitiesnoconv('SetDeliveryDate'), 1) . '</a></td>';
print '</tr></table>';
print '</td><td colspan="3">';
if ($action == 'editdate_livraison') {
    print '<form name="editdate_livraison" action="' . $_SERVER["PHP_SELF"] . '?id=' . $object->id . '" method="post">';
    print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
    print '<input type="hidden" name="action" value="setdate_livraison">';
    $form->select_date($object->date_livraison, 'liv_', '', '', '', "editdate_livraison");
    print '<input type="submit" class="button" value="' . $langs->trans('Modify') . '">';
    print '</form>';
} else {
    print dol_print_date($object->date_livraison, 'daytext');
}
print '</td>';
print '</tr>';

// Delivery delay
print '<tr><td>';
print '<table class="nobordernopadding" width="100%"><tr><td>';
print $langs->trans('AvailabilityPeriod');
if (!empty($conf->commande->enabled))
    print ' (' . $langs->trans('AfterOrder') . ')';
print '</td>';
if ($action != 'editavailability' && !empty($object->brouillon))
    print '<td align="right"><a href="' . $_SERVER["PHP_SELF"] . '?action=editavailability&amp;id=' . $object->id . '">' . img_edit($langs->transnoentitiesnoconv('SetAvailability'), 1) . '</a></td>';
print '</tr></table>';
print '</td><td colspan="3">';
if ($action == 'editavailability') {
    $form->form_availability($_SERVER['PHP_SELF'] . '?id=' . $object->id, $object->availability_id, 'availability_id', 1);
} else {
    $form->form_availability($_SERVER['PHP_SELF'] . '?id=' . $object->id, $object->availability_id, 'none', 1);
}

print '</td>';
print '</tr>';

// Origin of demand
print '<tr><td>';
print '<table class="nobordernopadding" width="100%"><tr><td>';
print $langs->trans('Source');
print '</td>';
if ($action != 'editdemandreason' && !empty($object->brouillon))
    print '<td align="right"><a href="' . $_SERVER["PHP_SELF"] . '?action=editdemandreason&amp;id=' . $object->id . '">' . img_edit($langs->transnoentitiesnoconv('SetDemandReason'), 1) . '</a></td>';
print '</tr></table>';
print '</td><td colspan="3">';
//print $object->demand_reason_id;
if ($action == 'editdemandreason') {
    $form->selectInputReason($object->demand_reason_id, 'demand_reason_id','' ,1);
} else {
    $form->selectInputReason($object->demand_reason_id, 'none');
}

print '</td>';
print '</tr>';

// Payment mode
print '<tr>';
print '<td width="25%">';
print '<table class="nobordernopadding" width="100%"><tr><td>';
print $langs->trans('PaymentMode');
print '</td>';
if ($action != 'editmode' && !empty($object->brouillon))
    print '<td align="right"><a href="' . $_SERVER["PHP_SELF"] . '?action=editmode&amp;id=' . $object->id . '">' . img_edit($langs->transnoentitiesnoconv('SetMode'), 1) . '</a></td>';
print '</tr></table>';
print '</td><td colspan="3">';
if ($action == 'editmode') {
    $form->form_modes_reglement($_SERVER['PHP_SELF'] . '?id=' . $object->id, $object->mode_reglement_id, 'mode_reglement_id');
} else {
    $form->form_modes_reglement($_SERVER['PHP_SELF'] . '?id=' . $object->id, $object->mode_reglement_id, 'none');
}
print '</td></tr>';

// Project
if (!empty($conf->projet->enabled)) {
    $langs->load("projects");
    print '<tr><td>';
    print '<table class="nobordernopadding" width="100%"><tr><td>';
    print $langs->trans('Project') . '</td>';
    if ($user->rights->propal->creer) {
        if ($action != 'classify')
            print '<td align="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=classify&amp;id=' . $object->id . '">' . img_edit($langs->transnoentitiesnoconv('SetProject')) . '</a></td>';
        print '</tr></table>';
        print '</td><td colspan="3">';
        if ($action == 'classify') {
            $form->form_project($_SERVER['PHP_SELF'] . '?id=' . $object->id, $object->socid, $object->fk_project, 'projectid');
        } else {
            $form->form_project($_SERVER['PHP_SELF'] . '?id=' . $object->id, $object->socid, $object->fk_project, 'none');
        }
        print '</td></tr>';
    } else {
        print '</td></tr></table>';
        if (!empty($object->fk_project)) {
            print '<td colspan="3">';
            $proj = new Project($db);
            $proj->fetch($object->fk_project);
            print '<a href="../projet/fiche.php?id=' . $object->fk_project . '" title="' . $langs->trans('ShowProject') . '">';
            print $proj->ref;
            print '</a>';
            print '</td>';
        } else {
            print '<td colspan="3">&nbsp;</td>';
        }
    }
    print '</tr>';
}

// Other attributes
$parameters = array('colspan' => ' colspan="3"');
$reshook = $hookmanager->executeHooks('formObjectOptions', $parameters, $object, $action);    // Note that $action and $object may have been modified by hook
if (empty($reshook) && !empty($extrafields->attribute_label)) {
    foreach ($extrafields->attribute_label as $key => $label) {
        $value = (isset($_POST["options_" . $key]) ? $_POST["options_" . $key] : $object->array_options["options_" . $key]);
        print '<tr><td';
        if (!empty($extrafields->attribute_required[$key]))
            print ' class="fieldrequired"';
        print '>' . $label . '</td><td colspan="3">';
        print $extrafields->showInputField($key, $value);
        print '</td></tr>' . "\n";
    }
}

// Amount HT
print '<tr><td height="10">' . $langs->trans('AmountHT') . '</td>';
print '<td align="right" nowrap><b>' . price($object->total_ht) . '</b></td>';
print '<td>' . $langs->trans("Currency" . $conf->currency) . '</td>';

// Margin Infos
if (!empty($conf->margin->enabled)) {
    print '<td valign="top" width="50%" rowspan="4">';
    print $object->displayMarginInfos;
    print '</td>';
}
print '</tr>';

// Amount VAT
print '<tr><td height="10">' . $langs->trans('AmountVAT') . '</td>';
print '<td align="right" nowrap>' . price($object->total_tva) . '</td>';
print '<td>' . $langs->trans("Currency" . $conf->currency) . '</td></tr>';

// Amount Local Taxes
if ($mysoc->localtax1_assuj == "1") { //Localtax1
    print '<tr><td height="10">' . $langs->transcountry("AmountLT1", $mysoc->country_code) . '</td>';
    print '<td align="right" nowrap>' . price($object->total_localtax1) . '</td>';
    print '<td>' . $langs->trans("Currency" . $conf->currency) . '</td></tr>';
}
if ($mysoc->localtax2_assuj == "1") { //Localtax2
    print '<tr><td height="10">' . $langs->transcountry("AmountLT2", $mysoc->country_code) . '</td>';
    print '<td align="right" nowrap>' . price($object->total_localtax2) . '</td>';
    print '<td>' . $langs->trans("Currency" . $conf->currency) . '</td></tr>';
}


// Amount TTC
print '<tr><td height="10">' . $langs->trans('AmountTTC') . '</td>';
print '<td align="right" nowrap>' . price($object->total_ttc) . '</td>';
print '<td>' . $langs->trans("Currency" . $conf->currency) . '</td></tr>';

// Statut
print '<tr><td height="10">' . $langs->trans('Status') . '</td><td align="left" colspan="2">' . $object->getLibStatut(4) . '</td></tr>';

print '</table><br>';

if (!empty($conf->global->MAIN_DISABLE_CONTACTS_TAB)) {
    $blocname = 'contacts';
    $title = $langs->trans('ContactsAddresses');
    include DOL_DOCUMENT_ROOT . '/core/tpl/bloc_showhide.tpl.php';
}

if (!empty($conf->global->MAIN_DISABLE_NOTES_TAB)) {
    $blocname = 'notes';
    $title = $langs->trans('Notes');
    include DOL_DOCUMENT_ROOT . '/core/tpl/bloc_showhide.tpl.php';
}

print '<form action="modif_echeancier_propal.php" method="post">';
print '<input type="hidden" name="action" value="modife">';
print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
print '<input type="hidden" name="redirect" value="' . GETPOST('redirect') . '">';
print '<input type="hidden" name="ide" value="' . GETPOST('ide') . '">';


print '<table id="echeancier" class="noborder semi"  >';
print '<thead><tr class="liste_titre"><th>' . $langs->trans('Date de reglement') . '</th><th>' . $langs->trans('Montant') . '</th><th></th></tr></thead>';


$i = 0;
$count_echeance = count($echeancier->echeances);
foreach ($echeancier->echeances as $echeance_row) {
    $var = !$var;
    $manuel = '';
    $egal = 0;
    for ($j = 0; $j < count($echeancier->echeances); $j++) {

        if ($echeance_row['montant'] == $echeancier->echeances[$j]['montant'])
            $egal++;
    }

    if ($egal <= 2)
        $manuel = 'manuel=true';

    print '<tr ' . $bc[$var] . ' id="row' . $i . '">';
    print '<td align="center">';
    $form->select_date($echeance_row['date_reglement'], 'dated' . $i, '', '', '', "setdate");
    print '</td>';
    print '<td align="center"><input id="montant' . $i . '" ' . $manuel . ' type="text" name="montant' . $i . '" value="' . $echeance_row['montant'] . '"></td>';


    print '<td align="center"></td>';
    print '<input type="hidden" name="id' . $i . '" value="' . $echeance_row['id'] . '">';
    print '</tr>';
    $i++;
}

print '<input type="hidden" name="count" value="' . $i . '">';
print '</table>';
print '<div class="tabsAction semi" ><input type="submit" id="addelementbuton" class="butAction" value="' . $langs->trans("modifie") . '"></div></form>';




print '</div>';
$montant = $echeancier->montant;


// End of page
?>
<script type="text/javascript">
    jQuery(document).ready(function(){
        var nonmanuel = 0 ;
        var date;
        var $idset;
        $loopcount = <?php print $i - 1; ?>; 
        var counter = 1;
        var tot = '<?php print $montant; ?>' ;
        console.log($loopcount);
        
        
   
        

        jQuery('#echeancier :input').on('change',function(event) {
            nonmanuel = 0 ;
            var totalmanuel = 0 ;
            var reste =0 ;
            //clearInterval($idset)
            jQuery(event.target).attr('manuel', true);
            jQuery('#echeancier :input:text').each(function(index,domEle){
                
            
       
                if ($(domEle).attr('manuel') && $(domEle).attr('name').substring(0, 5) != 'dated'){
                
                    totalmanuel = totalmanuel + parseFloat($(domEle).val());
                }else{
                    if (!$(domEle).attr('disabled') && $(domEle).attr('name').substring(0, 5) != 'dated'){
                        nonmanuel++;
                    }
                }
                
            
            });
            
            var val = ((tot-totalmanuel)/nonmanuel).toFixed(<?php echo $conf->global->MAIN_MAX_DECIMALS_TOT; ?>);
            jQuery('#echeancier :input:text').each(function(index,domEle){
                if (!($(domEle).attr('manuel')) &&  $(domEle).attr('name').substring(0, 5) != 'dated'){
                    jQuery($(domEle)).val(val);
                
                }
            
            });
       
            calclast();
    
        });

        function totalttc(){
    
            var totalttc=0;
            jQuery('#echeancier :input:text').each(function(index,domEle){
                
                if ( $(domEle).attr('name').substring(0, 5) != 'dated'){
                    totalttc = totalttc + parseFloat($(domEle).val());
               
                }       
            });
            console.log(totalttc);
            return totalttc
    
        }
        
        function add_echeance () { 
         
                    
            
                      
            
            var totalfix = (tot/$loopcount).toFixed(<?php echo $conf->global->MAIN_MAX_DECIMALS_TOT ?>);
           
               
                
            jQuery('#echeancier').append('<div class="label_echeance"><input type="hidden" name="date'+i+'" value="'+date +'"><label>'+date.toLocaleDateString()+'</label><input type="text" id="textbox'+i+'" name="textbox'+i+'" class="textbox2" value="'+totalfix+'" /></div>');
                
            date.setMonth(date.getMonth() + $periodicite );
               
        
    
            
               
            calclast();
        }

        function calclast(){
            var diff = tot - totalttc();
             
            var last= "#montant" + $loopcount.toString();
            console.log(last);
            var lastele = $('#echeancier').find(last);
            var lasttextbox = parseFloat(jQuery(lastele).val());
            var lastval = (lasttextbox + diff).toFixed(<?php echo $conf->global->MAIN_MAX_DECIMALS_TOT ?>);
            jQuery(last).val(lastval);
            console.log(lasttextbox);
            //setTimeout(function(){clearInterval($idset)},100);
    
    
        }




    });
</script>

<?php
dol_htmloutput_errors($errmsg);
llxFooter();
$db->close();