<?php

/*
 * Copyright (C) 2012 jacquel jerome <icfr.eirl@free.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup	Echeancier module
 * 	\brief		creation d'echeancier depuis contrat ou manuelement.
 * 	\file		core/modules/modEcheancier.class.php
 * 	\ingroup	Echeancier
 * 	\brief		Description and activation file for module MyModule
 */
include_once DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php";

/**
 * Description and activation class for module MyModule
 */
class modEcheancier extends DolibarrModules {

    /**
     * 	Constructor. Define names, constants, directories, boxes, permissions
     *
     * 	@param	DoliDB		$db	Database handler
     */
    public function __construct($db) {
        global $langs, $conf;

        $this->db = $db;

        // Id for module (must be unique).
        // Use a free id here
        // (See in Home -> System information -> Dolibarr for list of used modules id).
        $this->numero = 511000;
        // Key text used to identify module (for permissions, menus, etc...)
        $this->rights_class = 'echeancier';

        // Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
        // It is used to group modules in module setup page
        $this->family = "financial";
        // Module label (no space allowed)
        // used if translation string 'ModuleXXXName' not found
        // (where XXX is value of numeric property 'numero' of module)
        $this->name = preg_replace('/^mod/i', '', get_class($this));
        // Module description
        // used if translation string 'ModuleXXXDesc' not found
        // (where XXX is value of numeric property 'numero' of module)
        $this->description = "creation d'echeancier depuis une facture";
        // Possible values for version are: 'development', 'experimental' or version
        $this->version = '13.0';
        // Key used in llx_const table to save module status enabled/disabled
        // (where MYMODULE is value of property name of module in uppercase)
        $this->const_name = 'MAIN_MODULE_' . strtoupper($this->name);
        // Where to store the module in setup page
        // (0=common,1=interface,2=others,3=very specific)
        $this->special = 0;
        // Name of image file used for this module.
        // If file is in theme/yourtheme/img directory under name object_pictovalue.png
        // use this->picto='pictovalue'
        // If file is in module/img directory under name object_pictovalue.png
        // use this->picto='pictovalue@module'
        $this->picto = 'generic'; // mypicto@mymodule
        // Defined all module parts (triggers, login, substitutions, menus, css, etc...)
        // for default path (eg: /mymodule/core/xxxxx) (0=disable, 1=enable)
        // for specific path of parts (eg: /mymodule/core/modules/barcode)
        // for specific css file (eg: /mymodule/css/mymodule.css.php)
        $this->module_parts = array(
            // Set this to 1 if module has its own trigger directory
            'triggers' => 1,
            // Set this to 1 if module has its own login method directory
            //'login' => 0,
            // Set this to 1 if module has its own substitution function file
            //'substitutions' => 0,
            // Set this to 1 if module has its own menus handler directory
            //'menus' => 0,
            // Set this to 1 if module has its own barcode directory
            //'barcode' => 0,
            // Set this to 1 if module has its own models directory
            'models' => 1,
                // Set this to relative path of css if module has its own css file
                //'css' => '/echeancier/css/style.css',
                // Set here all hooks context managed by module
                //'hooks' => array('hookcontext1','hookcontext2')
                // Set here all workflow context managed by module
                //'workflow' => array('order' => array('WORKFLOW_ORDER_AUTOCREATE_INVOICE'))
        );

        // Data directories to create when module is enabled.
        // Example: this->dirs = array("/mymodule/temp");
        $this->dirs = array();

        // Config pages. Put here list of php pages
        // stored into mymodule/admin directory, used to setup module.
        //$this->config_page_url = array("admin.php@echeancier");

        // Dependencies
        // List of modules id that must be enabled if this module is enabled
        $this->depends = array();
        // List of modules id to disable if this one is disabled
        $this->requiredby = array();
        // Minimum version of PHP required by module
        $this->phpmin = array(5, 3);
        // Minimum version of Dolibarr required by module
        $this->need_dolibarr_version = array(3, 5);
        $this->langfiles = array("echeancier@echeancier"); // langfiles@mymodule
        // Constants
        // List of particular constants to add when module is enabled
        // (key, 'chaine', value, desc, visible, 'current' or 'allentities', deleteonunactive)
        // Example:
        $this->const = array();
        $r=0;
        $this->const[$r][0] = "ECHEANCIER_ADDON_PDF";
        $this->const[$r][1] = "chaine";
        $this->const[$r][2] = "echeancier";
        $this->const[$r][3] = 'Name of PDF model of invoice';
        $this->const[$r][4] = 0;
        $r++;

        // Array to add new pages in new tabs
        // Example:
        $this->tabs = array(
            'thirdparty:+tabEcheancier:Echeancier:echeancier@echeancier:$user->rights->echeancier->voir:/echeancier/fiche_client.php?id=__ID__',
            'invoice:+tabEcheancier:Echeancier:echeancier@echeancier:$user->rights->echeancier->voir:/echeancier/fiche_facture.php?id=__ID__',
            'propal:+tabEcheancier:Echeancier:echeancier@echeancier:$user->rights->echeancier->voir:/echeancier/fiche_propale.php?id=__ID__',
        );
        

        $this->dictionnaries = array();


        // Boxes
        // Add here list of php file(s) stored in core/boxes that contains class to show a box.
        $this->boxes = array(); // Boxes list
        $r = 0;
        // Example:

        $this->boxes[$r][1] = "box_echeancier@echeancier";
        $r++;


        // Permissions
        $this->rights = array(); // Permission array used by this module
        $r = 0;

        $this->rights = array();  // Permission array used by this module
        $this->rights_class = 'echeancier';
        $r = 0;
        $this->rights[$r][0] = 511001;
        $this->rights[$r][1] = 'Crée echeancier sur facture';
        $this->rights[$r][2] = 'r';
        $this->rights[$r][3] = 0;
        $this->rights[$r][4] = 'facture';

        $r++;
        $this->rights[$r][0] = 511002;
        $this->rights[$r][1] = 'Créer echeancier sur proposition commercial';
        $this->rights[$r][2] = 'r';
        $this->rights[$r][3] = 0;
        $this->rights[$r][4] = 'propale';

        $r++;
        $this->rights[$r][0] = 511003;
        $this->rights[$r][1] = 'Gerer les encaissement';
        $this->rights[$r][2] = 'r';
        $this->rights[$r][3] = 0;
        $this->rights[$r][4] = 'encaissement';
        $r++;
        $this->rights[$r][0] = 511004;
        $this->rights[$r][1] = 'Voir echeancier';
        $this->rights[$r][2] = 'r';
        $this->rights[$r][3] = 0;
        $this->rights[$r][4] = 'voir';

        $r++;

        $this->menus = array(); // List of menus to add
        $r = 0;

        // Example to declare a Left Menu entry into an existing Top menu entry:
        $this->menu[$r] = array(
            // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy'
            'fk_menu' => 'fk_mainmenu=commercial,fk_leftmenu=propals',
            // This is a Left menu entry
            'type' => 'left',
            'titre' => 'SimulationEcheancier',
            'mainmenu' => 'accountancy',
            'leftmenu' => 'propals',
            'url' => '/echeancier/simulation.php',
            // Lang file to use (without .lang) by module.
            // File must be in langs/code_CODE/ directory.
            'langs' => 'echeancier@echeancier',
            'position' => 100,
            // Define condition to show or hide menu entry.
            // Use '$conf->mymodule->enabled' if entry must be visible if module is enabled.
            // Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
            'enabled' => '1',
            // Use 'perms'=>'$user->rights->mymodule->level1->level2'
            // if you want your menu with a permission rules
            'perms' => '1',
            'target' => '',
            // 0=Menu for internal users, 1=external users, 2=both
            'user' => 2
        );
        $r++;

        $this->menu[$r] = array(
            // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy'
            'fk_menu' => 'fk_mainmenu=accountancy,fk_leftmenu=customers_bills',
            // This is a Left menu entry
            'type' => 'left',
            'titre' => 'EcheancierSurFacture',
            'mainmenu' => 'accountancy',
            'leftmenu' => 'customers_bills',
            'url' => '/echeancier/new_from_facture.php',
            // Lang file to use (without .lang) by module.
            // File must be in langs/code_CODE/ directory.
            'langs' => 'echeancier@echeancier',
            'position' => 100,
            // Define condition to show or hide menu entry.
            // Use '$conf->mymodule->enabled' if entry must be visible if module is enabled.
            // Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
            'enabled' => '1',
            // Use 'perms'=>'$user->rights->mymodule->level1->level2'
            // if you want your menu with a permission rules
            'perms' => '1',
            'target' => '',
            // 0=Menu for internal users, 1=external users, 2=both
            'user' => 2
        );
        $r++;
        $this->menu[$r] = array(
            // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy'
            'fk_menu' => 'fk_mainmenu=accountancy,fk_leftmenu=customers_bills',
            // This is a Left menu entrys
            'type' => 'left',
            'titre' => 'ReglementEcheance',
            'mainmenu' => 'accountancy',
            'leftmenu' => 'customers_bills',
            'url' => '/echeancier/valide.php',
            // Lang file to use (without .lang) by module.
            // File must be in langs/code_CODE/ directory.
            'langs' => 'echeancier@echeancier',
            'position' => 100,
            // Define condition to show or hide menu entry.
            // Use '$conf->mymodule->enabled' if entry must be visible if module is enabled.
            // Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
            'enabled' => '1',
            // Use 'perms'=>'$user->rights->mymodule->level1->level2'
            // if you want your menu with a permission rules
            'perms' => '1',
            'target' => '',
            // 0=Menu for internal users, 1=external users, 2=both
            'user' => 2
        );

        $r++;



        // Exports
        $r = 1;
    }

    /**
     * Function called when module is enabled.
     * The init function add constants, boxes, permissions and menus
     * (defined in constructor) into Dolibarr database.
     * It also creates data directories
     *
     * 	@param		string	$options	Options when enabling module ('', 'noboxes')
     * 	@return		int					1 if OK, 0 if KO
     */
    public function init($options = '') {
    	global $conf;
        $newid = 0;
        $sql = "SELECT max(id) newid from " . MAIN_DB_PREFIX . "c_paiement";
        $result = $this->db->query($sql);
        if ($result) {
            $obj = $this->db->fetch_object($result);
            $newid = ($obj->newid + 1);
        } else {
            dol_print_error($db);
        }
        $sql = "INSERT INTO " . MAIN_DB_PREFIX . "c_paiement (id,code,libelle,type,active) VALUE(" . $newid . ",'ECH','Echeancier','2','1') ";
        $result = $this->db->query($sql);
        
        $sql = "SELECT ecart FROM " . MAIN_DB_PREFIX . "echeance";
        $updatedb = $sql;
        $res = $this->db->query($sql);

        if (!$res) {
            $updatedb =   "ALTER TABLE `" . MAIN_DB_PREFIX . "echeance`
            CHANGE COLUMN `id` `rowid` INT(11) NOT NULL AUTO_INCREMENT FIRST,
            CHANGE COLUMN `echeancier` `fk_echeancier` INT(11) NOT NULL AFTER `rowid`,
            CHANGE COLUMN `id_facture` `fk_facture` INT(11) NOT NULL AFTER `fk_echeancier`,
            ADD COLUMN `montant_paye` FLOAT NOT NULL AFTER `montant`,
            ADD COLUMN `ecart` FLOAT NOT NULL AFTER `montant_paye`,
            CHANGE COLUMN `id_bank` `fk_bank` INT(11) NOT NULL AFTER `type`;";
        }
      
        $sql = array();

        $sql[] ="CREATE TABLE IF NOT EXISTS `" . MAIN_DB_PREFIX . "echeancier` (`id` int(11) NOT NULL AUTO_INCREMENT,`type` int(11),`montant` float(24,8) NOT NULL, `nombre` int(11) NOT NULL,  `id_element` int(11) NOT NULL,`id_client` int(11) NOT NULL,  `date_debut` date NOT NULL,`num` int(11) DEFAULT NULL,PRIMARY KEY (`id`)) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;";
        $sql[] = "CREATE TABLE IF NOT EXISTS `" . MAIN_DB_PREFIX . "echeance` ( `id` int(11) NOT NULL AUTO_INCREMENT, `echeancier` int(11) NOT NULL, `id_facture` int(11) NOT NULL, `date_reglement` date NOT NULL, `acompte` tinyint(1) NOT NULL, `paye` tinyint(1) NOT NULL, `montant` float NOT NULL,`type` int(11) NOT NULL DEFAULT '2',`id_bank` int(11) NOT NULL, PRIMARY KEY (`id`)) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;";
        $sql[] = $updatedb;
        $sql[] = "DELETE FROM ".MAIN_DB_PREFIX."document_model WHERE nom = '".$this->const[0][2]."' AND entity = ".$conf->entity;
		$sql[] = "INSERT INTO ".MAIN_DB_PREFIX."document_model (nom, type, entity) VALUES('".$this->const[0][2]."','invoice',".$conf->entity.")";

        $result = $this->loadTables();
        
        $sqlt = "SELECT tms FROM " . MAIN_DB_PREFIX . "echeance";
        $res = $this->db->query($sqlt);
        if (!$res){
        	$sql[] = "ALTER TABLE `" . MAIN_DB_PREFIX . "echeance`
            ADD COLUMN `tms` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP AFTER `fk_bank`;" ;
        	$this->db->query($updatedb);
        }
        return $this->_init($sql, $options);;
    }

    /**
     * Function called when module is disabled.
     * Remove from database constants, boxes and permissions from Dolibarr database.
     * Data directories are not deleted
     *
     * 	@param		string	$options	Options when enabling module ('', 'noboxes')
     * 	@return		int					1 if OK, 0 if KO
     */
    public function remove($options = '') {
        $sql = array();

        return $this->_remove($sql, $options);
    }

    /**
     *
     * 	@return		int		<=0 if KO, >0 if OK
     */
    private function loadTables() {
        return $this->_load_tables('/mymodule/sql/');
    }

}
