<?php
function getSuffixFromOriginRef($origin, $origin_id)
{
	global $db;

	$element = $subelement = $origin;
	if (preg_match('/^([^_]+)_([^_]+)/i',$origin,$regs))
	{
		$element = $regs[1];
		$subelement = $regs[2];
	}

	// For compatibility
	if ($element == 'order')    {
		$element = $subelement = 'commande';
	}
	if ($element == 'propal')   {
		$element = 'comm/propal'; $subelement = 'propal';
	}
	if ($element == 'contract') {
		$element = $subelement = 'contrat';
	}
	if ($element == 'inter')    {
		$element = $subelement = 'ficheinter';
	}
	if ($element == 'shipping') {
		$element = $subelement = 'expedition';
	}

	require_once DOL_DOCUMENT_ROOT . '/'.$element.'/class/'.$subelement.'.class.php';

	$classname = ucfirst($subelement);
	$srcobject = new $classname($db);

	dol_syslog("Try to find source object origin=".$origin." originid=".$origin_id." to add deposit lines");

	$result=$srcobject->fetch($origin_id);
	if ($result > 0)
	{
		$soc = new Societe($db);
		$socid=GETPOST('socid','int');
		if ($socid>0) $res=$soc->fetch($socid);

		$refori = $srcobject->ref;
		$refmodel = $srcobject->getNextNumRef($soc);
		return substr($refori, strlen($refmodel));
	}
	return '';
}
?>