<?php

	function altatpl_showOptionalsLabels($object, $norental = 0, $mode='view')
	{
		global $db, $conf, $langs, $action, $form, $nbcolforsubtotallines, $drafteditable;

		if (! is_object($form)) $form=new Form($db);

		$out = '';

		$extrafields = new ExtraFields($db);
		$extralabelsline = $extrafields->fetch_name_optionals_label($object->table_element_line);

		if (is_array($extrafields->attributes[$object->table_element_line]['label']) && count($extrafields->attributes[$object->table_element_line]['label']) > 0)
		{
			foreach($extrafields->attributes[$object->table_element_line]['label'] as $key=>$label)
			{
			    if (isset($extrafields->attributes[$object->table_element_line]['list'][$key])
			        && empty($extrafields->attributes[$object->table_element_line]['list'][$key]))
			    {
			        continue;
			    }

				// Show only the key field in params
				if (is_array($params) && array_key_exists('onlykey', $params) && $key != $params['onlykey']) continue;

				// @TODO Add test also on 'enabled' (different than 'list' that is 'visibility')
				$enabled = 1;

				$visibility = 1;
				if ($visibility && isset($extrafields->attributes[$object->table_element_line]['list'][$key]))
				{
				    $visibility = dol_eval($extrafields->attributes[$object->table_element_line]['list'][$key], 1);
				}

				$perms = 1;
				if ($perms && isset($extrafields->attributes[$object->table_element_line]['perms'][$key]))
				{
					$perms = dol_eval($extrafields->attributes[$object->table_element_line]['perms'][$key], 1);
				}

				if (($mode == 'create' || $mode == 'edit') && abs($visibility) != 1 && abs($visibility) != 3) continue;	// <> -1 and <> 1 and <> 3 = not visible on forms, only on list
				elseif($mode == 'view' && empty($visibility)) continue;
				if (empty($perms)) continue;

				if (empty($conf->rental->enabled) || empty($object->array_options['options_rental_doc']))
				{
					if (substr($key,0,7) == 'rental_') continue;
				}

				elseif( ! empty($object->array_options['options_rental_doc']) )
				{

					if (! $drafteditable)
					{
						// écran standard
						if ($mode == 'create')
						{
							if ( $norental && substr($key,0,7) == 'rental_' ) $moreparam .= 'style="display: none;"';
							elseif ( ! $norental && substr($key,0,7) != 'rental_' ) $moreparam .= 'style="display: none;"';
						}
						elseif ($mode == 'view')
						{
							if ( $norental && $key == 'rental_line' ) { /* traitement normal */ }
							elseif ( $norental && substr($key,0,7) == 'rental_' ) $moreparam .= 'style="display: none;"';
							elseif ( ! $norental && substr($key,0,7) != 'rental_' ) $moreparam .= 'style="display: none;"';
						}
					}
					else
					{
						// draft edit aevc location et vente mélangées
						if ($mode == 'create')
						{
							if ( $norental && $key == 'rental_line' ) { /* traitement normal */ }
							elseif ( $norental && substr($key,0,7) == 'rental_' ) $moreparam .= 'style="display: none;"';
							elseif ( ! $norental && substr($key,0,7) != 'rental_' ) $moreparam .= 'style="display: none;"';
						}
						elseif ($mode == 'view')
						{
							if ( $norental && $key == 'rental_line' ) { /* traitement normal */ }
							elseif ( $norental && substr($key,0,7) == 'rental_' ) $moreparam .= 'style="display: none;"';
							elseif ( ! $norental && substr($key,0,7) != 'rental_' ) $moreparam .= 'style="display: none;"';
						}
					}
				}

				// Load language if required
				if (! empty($extrafields->attributes[$object->table_element_line]['langfile'][$key])) $langs->load($extrafields->attributes[$object->table_element_line]['langfile'][$key]);

				if ($extrafields->attributes[$object->table_element_line]['type'][$key] == 'separate' || ! empty($extrafields->attributes[$object->table_element_line]['hidden'][$key]))
				{
					continue;
				}
				else
				{

					$labeltoshow = $langs->trans($label);

					$out .= '<td class="linecol'.$key.'" align="center">';

					if (! empty($extrafields->attributes[$object->table_element_line]['help'][$key])) $out .= $form->textwithpicto($labeltoshow, $extrafields->attributes[$object->table_element_line]['help'][$key]);
					else $out .= $labeltoshow;
					$out .= '</td>';
					$nbcolforsubtotallines++;
				}
			}
		}
		print $out;
	}
	/**
	 * Function to show lines of extrafields with output datas
	 *
	 * @param 	Extrafields $extrafields    Extrafield Object
	 * @param 	string      $mode           Show output (view) or input (edit) for extrafield
	 * @param 	array       $param			    if (isset($extrafields->attributes[$line->table_element]['list'][$key])
			        && empty($extrafields->attributes[$line->table_element]['list'][$key]) && $mode == 'view'){
			        continue;
			    }
s         Optional parameters
	 * @param 	string      $keysuffix      Suffix string to add after name and id of field (can be used to avoid duplicate names)
	 * @param 	string      $keyprefix      Prefix string to add before name and id of field (can be used to avoid duplicate names)
	 * @param	string		$onetrtd		All fields in same tr td
	 * @return 	string
	 */
	function altatpl_showOptionalsValues($line, $extrafields, $mode='view', $isrentalline=false, $params=null, $keysuffix='', $keyprefix='', $onetrtd=0)
	{
		global $db, $conf, $langs, $action, $form, $object, $drafteditable;

		if (! is_object($form)) $form=new Form($db);

		$out = '<style>input.maxwidth75 { max-width: 60px; } </style>';

		if (is_array($extrafields->attributes[$line->table_element]['label']) && count($extrafields->attributes[$line->table_element]['label']) > 0)
		{
			$out .= "\n";
			$out .= '<!-- showOptionalsInput --> ';
			$out .= "\n";

			$e = 0;
			foreach($extrafields->attributes[$line->table_element]['label'] as $key=>$label)
			{
				$moreparam = '';

			    if (isset($extrafields->attributes[$line->table_element]['list'][$key])
			        && empty($extrafields->attributes[$line->table_element]['list'][$key])){
			        continue;
			    }

				// Show only the key field in params
				if (is_array($params) && array_key_exists('onlykey', $params) && $key != $params['onlykey']) continue;

				// @TODO Add test also on 'enabled' (different than 'list' that is 'visibility')
				$enabled = 1;

				$visibility = 1;
				if ($visibility && isset($extrafields->attributes[$line->table_element]['list'][$key]))
				{
				    $visibility = dol_eval($extrafields->attributes[$line->table_element]['list'][$key], 1);
				}

				$perms = 1;
				if ($perms && isset($extrafields->attributes[$line->table_element]['perms'][$key]))
				{
					$perms = dol_eval($extrafields->attributes[$line->table_element]['perms'][$key], 1);
				}

				if (($mode == 'create' || $mode == 'edit') && abs($visibility) != 1 && abs($visibility) != 3) continue;	// <> -1 and <> 1 and <> 3 = not visible on forms, only on list
				elseif($mode == 'view' && empty($visibility)) continue;
				if (empty($perms)) continue;

				if (empty($conf->rental->enabled) || empty($object->array_options['options_rental_doc']))
				{
					if (substr($key,0,7) == 'rental_') continue;
				}

				elseif( ! empty($object->array_options['options_rental_doc']) )
				{
					if (! $drafteditable)
					{
						// écran standard
						if ($mode == 'create')
						{
							if ( ! $isrentalline && substr($key,0,7) == 'rental_' ) $moreparam .= 'style="display: none;"';
							elseif ( $isrentalline && substr($key,0,7) != 'rental_' ) $moreparam .= 'style="display: none;"';
						}
						elseif ($mode == 'view')
						{
							if ( ! $isrentalline && substr($key,0,7) == 'rental_' ) { $out .= '<td></td>'; continue; }
							elseif ( $isrentalline && substr($key,0,7) != 'rental_' ) { $out .= '<td></td>'; continue; }
						}
						elseif ($mode == 'edit')
						{
							if ( ! $isrentalline && $key == 'rental_line' ) { /* traitement normal */ }
							elseif ( ! $isrentalline && substr($key,0,7) == 'rental_' ) $moreparam .= 'style="display: none;"';
							elseif ( $isrentalline && substr($key,0,7) != 'rental_' ) $moreparam .= 'style="display: none;"';
						}
					}
					else
					{
						// draft edit
						if ($mode == 'create')
						{
							if ( ! $isrentalline && $key == 'rental_line' ) { /* traitement normal */ }
							elseif ( ! $isrentalline && substr($key,0,7) == 'rental_' ) $moreparam .= 'style="display: none;"';
							elseif ( $isrentalline && substr($key,0,7) != 'rental_' ) $moreparam .= 'style="display: none;"';
						}
						elseif ($mode == 'edit')
						{
							if ( ! $isrentalline && $key == 'rental_line' ) { /* traitement normal */ }
							elseif ( ! $isrentalline && substr($key,0,7) == 'rental_' ) $moreparam .= 'style="display: none;"';
							elseif ( $isrentalline && substr($key,0,7) != 'rental_' ) $moreparam .= 'style="display: none;"';
						}
					}
				}

				// Load language if required
				if (! empty($extrafields->attributes[$line->table_element]['langfile'][$key])) $langs->load($extrafields->attributes[$line->table_element]['langfile'][$key]);

				switch($mode) {
					case "view":
						$value=$line->array_options["options_".$key.$keysuffix];
						break;
					case "create":
					case "edit":
						$getposttemp = GETPOST($keyprefix.'options_'.$key.$keysuffix, 'none');				// GETPOST can get value from GET, POST or setup of default values.
						// GETPOST("options_" . $key) can be 'abc' or array(0=>'abc')
						if (is_array($getposttemp) || $getposttemp != '' || GETPOSTISSET($keyprefix.'options_'.$key.$keysuffix))
						{
							if (is_array($getposttemp)) {
								// $getposttemp is an array but following code expects a comma separated string
								$value = implode(",", $getposttemp);
							} else {
								$value = $getposttemp;
							}
						} else {
							$value = $line->array_options["options_" . $key];			// No GET, no POST, no default value, so we take value of object.
						}
						//var_dump($keyprefix.' - '.$key.' - '.$keysuffix.' - '.$keyprefix.'options_'.$key.$keysuffix.' - '.$line->array_options["options_".$key.$keysuffix].' - '.$getposttemp.' - '.$value);
						break;
				}

				if ($extrafields->attributes[$line->table_element]['type'][$key] == 'separate' || ! empty($extrafields->attributes[$object->table_element_line]['hidden'][$key]))
				{
					continue;
				}
				else
				{

					// Convert date into timestamp format (value in memory must be a timestamp)
					if (in_array($extrafields->attributes[$line->table_element]['type'][$key],array('date','datetime')))
					{
						$datenotinstring = $line->array_options['options_' . $key];
						if (! is_numeric($line->array_options['options_' . $key]))	// For backward compatibility
						{
							$datenotinstring = $line->db->jdate($datenotinstring);
						}
						$value = ($mode == 'edit' && GETPOSTISSET($keyprefix.'options_'.$key.$keysuffix))?dol_mktime(GETPOST($keyprefix.'options_'.$key.$keysuffix."hour", 'int', 3), GETPOST($keyprefix.'options_'.$key.$keysuffix."min",'int',3), 0, GETPOST($keyprefix.'options_'.$key.$keysuffix."month",'int',3), GETPOST($keyprefix.'options_'.$key.$keysuffix."day",'int',3), GETPOST($keyprefix.'options_'.$key.$keysuffix."year",'int',3)):$datenotinstring;
					}
					// Convert float submited string into real php numeric (value in memory must be a php numeric)
					if (in_array($extrafields->attributes[$line->table_element]['type'][$key],array('price','double')))
					{
						$value = ($mode == 'edit' && GETPOSTISSET($keyprefix.'options_'.$key.$keysuffix))?price2num(GETPOST($keyprefix.'options_'.$key.$keysuffix, 'alpha', 3)):$line->array_options['options_'.$key];
					}

					$html_id = !empty($line->id) ? $line->element.'_extras_'.$key.'_'.$line->id : '';
					$out .='<td id="'.$html_id.'" class="linecol'.$key.' '.$line->element.'_extras_'.$key.'" align="center" nowrap>';

					switch($mode) {
						case "view":
							$out .= $extrafields->showOutputField($key, $value);
							break;
						case "create":
						case "edit":
							$out .= $extrafields->showInputField($key, $value, $moreparam, $keysuffix, '', 0, $line->id);
							break;
					}
					$out .= '</td>';
					$e++;
				}
			}
			$out .= "\n";
			// Add code to manage list depending on others
			if (! empty($conf->use_javascript_ajax)) {
				$out .= '
				<script type="text/javascript">
				    jQuery(document).ready(function() {
				    	function showOptions(child_list, parent_list)
				    	{
				    		var val = $("select[name=\"options_"+parent_list+"\"]").val();
				    		var parentVal = parent_list + ":" + val;
							if(val > 0) {
					    		$("select[name=\""+child_list+"\"] option[parent]").hide();
					    		$("select[name=\""+child_list+"\"] option[parent=\""+parentVal+"\"]").show();
							} else {
								$("select[name=\""+child_list+"\"] option").show();
							}
				    	}
						function setListDependencies() {
					    	jQuery("select option[parent]").parent().each(function() {
					    		var child_list = $(this).attr("name");
								var parent = $(this).find("option[parent]:first").attr("parent");
								var infos = parent.split(":");
								var parent_list = infos[0];
								$("select[name=\""+parent_list+"\"]").change(function() {
									showOptions(child_list, parent_list);
								});
					    	});
						}

						setListDependencies();
				    });
				</script>'."\n";
				$out .= '<!-- /showOptionalsValues --> '."\n";
			}
		}
		print $out;
		return $e;
	}
