<?php

global $conf, $extrafields, $langs, $form, $user, $hookmanager, $object, $action, $db, $soc, $formproject, $formmargin, $formfile, $formactions, $drafteditable;

if (empty($drafteditable)) return 0;

// get json draft description (modules that overwrite desc must declare this into descriptor)
$dirdrafts=$conf->modules_parts['drafts'];
$draftdesc = '';
foreach($dirdrafts as $module => $reldir)
{
	if (!empty($module) && $module != 'dolitools')
	{
		$draftdesc = dol_buildpath($reldir.$object->element.'.json.php');
		break;
	}
}
if (empty($draftdesc)) $draftdesc = dol_buildpath('/dolitools/core/drafts/'.$object->element.'.json.php');

if (empty($conf->file->strict_mode)) {
	$jsondraft=@file_get_contents($draftdesc);
} else {
	$jsondraft=file_get_contents($draftdesc); // for debug
}

if ( ! $jsondraft) return 0;

$now = dol_now();

if ($object->element == 'commande') llxHeader('', $langs->trans('Order'), 'EN:Customers_Orders|FR:Commandes_Clients|ES:Pedidos de clientes');
elseif ($object->element == 'propal') llxHeader('', $langs->trans('Proposal'), 'EN:Commercial_Proposals|FR:Proposition_commerciale|ES:Presupuestos');

if ($object->id > 0) {

	print("<div id=\"draftwaiting\" style=\"position: fixed; top: 0px; left: 0px; width: 100%; height: 100%; opacity: 0.8; z-index: 1000; background-color: #CCC; padding: 10% 0 0 20%; font-size: 3em; font-weight: bold; color: #188BAF;\">".$langs->trans("LoadingEditableDraft")."</div>");

	$form = new Form($db);
	$formfile = new FormFile($db);
	$formmargin = new FormMargin($db);
	if (! empty($conf->projet->enabled)) { $formproject = new FormProjets($db); }

	$product_static = new Product($db);

	$soc = new Societe($db);
	$soc->fetch($object->socid);

	$author = new User($db);
	$author->fetch($object->user_author_id);

	$res = $object->fetch_optionals();

	print '<form id="draftedit" name="draftedit" data-changed="false" method="post" action="' . $_SERVER["PHP_SELF"] . '?id='.$object->id . '&action=draftedit">';
	print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
	print '<input type="hidden" name="action" value="draftupdate">';

	switch($object->element) {
		case 'commande':
			$head = commande_prepare_head($object);
			dol_fiche_head($head, 'order', $langs->trans("CustomerOrder"), -1, 'order');
			break;
		case 'propal':
			$head = propal_prepare_head($object);
			dol_fiche_head($head, 'comm', $langs->trans('Proposal'), -1, 'propal');
			break;
	}

	$draft = json_decode($jsondraft, true);

	// Order card
	$linkback = '<a href="./list.php?restore_lastsearch_values=1' . (! empty($socid) ? '&socid=' . $socid : '') . '">' . $langs->trans("BackToList") . '</a>';

	// Banner content
	$morehtmlref='<div class="refidno">';
	$morehtmlref.='<table>';
	$morehtmlref.= getFields($draft['banner']);
	$morehtmlref.='</table></div>';

	dol_banner_tab($object, 'ref', $linkback, 1, 'ref', 'ref', $morehtmlref);

	// card content
	print '<div class="fichecenter">';

	// left side
	print '<div class="fichehalfleft">';
	print '<div class="underbanner clearboth"></div>';
	print '<table class="border tableforfield centpercent">';
	getFields($draft['ficheleft']);
	print '</table>';
	print '</div>';

	// right side
	print '<div class="fichehalfright">';
	print '<div class="ficheaddleft">';
	print '<div class="underbanner clearboth"></div>';
	print '<table class="border tableforfield centpercent">';
	getFields($draft['ficheright']);
	print '</table>';
	print '</div>';
	print '</div>';

	print '</div>';	// Close fichecenter

	print '<div class="clearboth"></div><br>';

	if (! empty($conf->global->MAIN_DISABLE_CONTACTS_TAB)) {
		$blocname = 'contacts';
		$title = $langs->trans('ContactsAddresses');
		include DOL_DOCUMENT_ROOT . '/core/tpl/bloc_showhide.tpl.php';
	}

	if (! empty($conf->global->MAIN_DISABLE_NOTES_TAB)) {
		$blocname = 'notes';
		$title = $langs->trans('Notes');
		include DOL_DOCUMENT_ROOT . '/core/tpl/bloc_showhide.tpl.php';
	}

	/*
	 * Lines
	 */
	getFields($draft['lines']);

	$numlines = count($object->lines);

	dol_fiche_end();

	print "</form>\n";

	// boutons
		/*
		 *  UPDATE / CANCEL
		 */
		 print '<div class="tabsAction">';

			print '<a class="butAction draftchanged" id="draftupdate" onclick="return draft_update();" style="display: none;">'.$langs->trans('DraftUpdate').'</a>';
			print '<a class="butAction draftchanged" id = "draftcancel" onclick="return confirm_cancel();" style="display: none;">'.$langs->trans('DraftReset').'</a>';
			print '<a class="butAction" id="draftclose" onclick="return confirm_close(this);" href="'.$_SERVER["PHP_SELF"].'?action=draftclose&id='.$object->id.'">'.$langs->trans('DraftClose').'</a>

			</div>

			<!--Google material icons-->
			<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

			<link rel="stylesheet" type="text/css" href="'.dol_buildpath("/dolitools/js/html5-confirm_box/confirm.css",1).'">
			<script src="'.dol_buildpath("/dolitools/js/html5-confirm_box/confirm.js",1).'"></script>

			<script type="text/javascript">

				$(document).ready(function() {
					$("div#draftwaiting").hide();

					$("a:not(\'.butAction\')").click(function(e)
					{
						if ($(this).attr("href") == "#") return true;

						if ($(this).parents("table#tablelines").length > 0) return true;

						if ($(this).attr("target") != "_blank")
						{
							return confirm_close(this);
						}
					});

					$("form#draftedit :input").change(function() {
					   $("form#draftedit").data("changed",true);
					   $("a.draftchanged").show();
					});

					$(window).on("beforeunload", function(){
						  if ($("form#draftedit").data("changed")) return "Are you sure you want to leave?";
					});

				});

				function draft_update(href)
				{
					$("div#draftwaiting").html("'.$langs->trans("SaveInProgress").'").show();

					var param = "id='.$object->id.'&element='.$object->element.'&draftupdate=1&" + $("form#draftedit").serialize();

					$.post("'.dol_buildpath('/dolitools/ajax/draftupdate.php', 1).'", { "param64" : btoa(param) }, function(data64)
					{
						var errors = JSON.parse(atob(data64));
						if ($.isEmptyObject(errors))
						{
							$("form#draftedit").data("changed",false);
							$("a.draftchanged").hide();
							alert("'.$langs->transnoentities("DraftSaved").'");
							if (href) window.location = href;
							else window. location.reload();
						}
						else
						{
							alert(JSON.stringify(errors));
							$("div#draftwaiting").hide();
						}
					});
				}

				function confirm_cancel()
				{
					if ($("form#draftedit").data("changed"))
					{
						confirmThis("'.$langs->transnoentities("DraftChangesDetected").'", "'.$langs->transnoentities("DraftConfirmCancel").'","'.$langs->transnoentities("Yes").'", "'.$langs->transnoentities("No").'","",
						function(){
							$("form#draftedit").data("changed",false); // for skipping onbeforeunload
							location.reload();
						},function(){
							//no code here
						});
					}

					return false;
				}

				function confirm_close(that=null)
				{
					if ($("form#draftedit").data("changed"))
					{
						confirmThis("'.$langs->transnoentities("DraftChangesDetected").'", "'.$langs->transnoentities("DraftConfirmClose").'","'.$langs->transnoentities("Yes").'", "'.$langs->transnoentities("No").'","'.$langs->transnoentities("Cancel").'",
						function(){
							draft_update(that.href);
						},function(){
							//no code here
							$("form#draftedit").data("changed",false); // for skipping onbeforeunload
							window.location.href = $(that).attr("href");
						},function() {
							//cancel
						});
						return false;
					}
					else return true;
				}
			</script>';

}

// End of page
llxFooter();
$db->close();

function getFields($part)
{
	global $conf, $langs;

	$output = '';
	$dirdrafts=$conf->modules_parts['drafts'];

	foreach($part as $elem)
	{
		// get json draft description (modules that overwrite desc must declare this into descriptor)
		$script = '';
		foreach($dirdrafts as $module => $reldir)
		{
			if (!empty($module) && $module != 'dolitools')
			{
				$script = dol_buildpath($reldir.'/includes/'.$elem.'.inc.php');
				break;
			}
		}
		if (empty($script)) $script = dol_buildpath('/dolitools/core/drafts/includes/'.$elem.'.inc.php');

		$res=include($script);
	}

	return $output;
}
