<?php
/* Copyright (C) 2010-2013	Regis Houssin		<regis.houssin@inodbox.com>
 * Copyright (C) 2010-2011	Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2012-2013	Christophe Battarel	<christophe.battarel@altairis.fr>
 * Copyright (C) 2012       Cédric Salvador     <csalvador@gpcsolutions.fr>
 * Copyright (C) 2012-2014  Raphaël Doursenaud  <rdoursenaud@gpcsolutions.fr>
 * Copyright (C) 2013		Florian Henry		<florian.henry@open-concept.pro>
 * Copyright (C) 2017		Juanjo Menent		<jmenent@2byte.es>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Need to have following variables defined:
 * $object (invoice, order, ...)
 * $conf
 * $langs
 * $element     (used to test $user->rights->$element->creer)
 * $permtoedit  (used to replace test $user->rights->$element->creer)
 * $inputalsopricewithtax (0 by default, 1 to also show column with unit price including tax)
 * $outputalsopricetotalwithtax
 * $usemargins (0 to disable all margins columns, 1 to show according to margin setup)
 *
 * $type, $text, $description, $line
 */

// Protection to avoid direct call of template
if (empty($object) || ! is_object($object))
{
	print "Error, template page can't be called as URL";
	exit;
}
?>
<!-- BEGIN PHP TEMPLATE objectline_title.tpl.php -->
<?php

if (empty($conf->global->DOLITOOLS_USE_ALTATPL)) return;

if ( ! in_array($object->element, array('propal','supplier_proposal','facture','facturerec','invoice','commande','order','order_supplier','invoice_supplier')) ) return;

global $senderissupplier, $nbcolforsubtotallines, $rental_lines;

$nbcolforsubtotallines = 0;

$canupdatepricesoncreate = ! empty($conf->global->ALTATPL_MODIFY_PRICES_ON_CREATE);

$langs->load("altatpl@dolitools");
if ( ! empty($conf->global->USE_AVAILABLE_STOCK) ) $langs->load("availablestock@availablestock");

global $drafteditable;
$drafteditable = $drafteditable && in_array($object->element, array('facture','facturerec','propal','commande'));

// Title line
if (! $drafteditable || empty($createlinetitle))
{
	print "<thead>\n";
	print '<tr class="liste_titre nodrag nodrop">';
}
else
{
	print '<tr class="active liste_titre nodrag nodrop draftcreate'.($rental_lines?' rental':' sale').'" style="display: none;">';
}

// check box for sel all
if ( empty($createlinetitle) && $object->brouillon && ! empty($conf->global->DOLITOOLS_USE_DELETELINES) && $action != 'editline') print '<td class="liste_titre" align="center"><input name="selall" type="checkbox" onclick="check_all(this);"/></td>';

elseif( $drafteditable && $createlinetitle && $object->brouillon && ! empty($conf->global->DOLITOOLS_USE_DELETELINES)) print '<td></td>';

// Adds a line numbering column
if (! empty($conf->global->MAIN_VIEW_LINE_NUMBER) && !empty($object->lines)) print '<td class="linecolnum center">'.$langs->trans('Position').'</td>';

// Description
print '<td class="linecoldescription">'.$langs->trans('Description').'</td>';

// ref fourn
if  (empty($conf->global->ALTATPL_HIDE_REF_FOURN) && ($object->element == 'supplier_proposal' || $object->element == 'order_supplier' || $object->element == 'invoice_supplier'))
{
	print '<td class="linerefsupplier"><span id="title_fourn_ref">'.$langs->trans("SupplierRef").'</span></td>';
	$nbcolforsubtotallines++;
}

// Qty
print '<td class="linecolqty right">'.$langs->trans('Qty').'</td>';
$nbcolforsubtotallines++;

if($conf->global->PRODUCT_USE_UNITS)
{
	print '<td class="linecoluseunit left">'.$langs->trans('Unit').'</td>';
	$nbcolforsubtotallines++;
}

// Adds stock infos
if (! empty($conf->stock->enabled) && ! empty($conf->global->ALTATPL_STOCK_ON_LINES) && empty($senderissupplier))
{
	print '<td class="linecolstock center">'.$langs->trans(!empty($conf->global->USE_AVAILABLE_STOCK)?"AvailableStock":(!empty($conf->global->USE_VIRTUAL_STOCK)?"VirtualStock":"RealStock"));
	if (! empty($object->array_options['options_rental_doc']) && ! empty($conf->global->ALTATPL_RENTAL_STOCK_HIDDEN)) print '<br/><a href="#" onclick="show_all(); $(this).hide(); return false;">'.$langs->trans('ShowAll').'</a>';
	print '</td>';
	$nbcolforsubtotallines++;
}

// hook to complete line with other cells
$parameters = array('createlinetitle'=>$createlinetitle, 'num'=>$num,'i'=>$i,'dateSelector'=>$dateSelector,'seller'=>$seller,'buyer'=>$buyer,'selected'=>$selected, 'extrafieldsline'=>$extrafieldsline);
$reshook = $hookmanager->executeHooks('altatpl_completeObjectLineTitle', $parameters, $object, $action);    // Note that $action and $object may have been modified by some hooks
if (! empty($reshook)) { print '</tr></thead>'; return 1; }

// Add extrafields column labels
if ( ! empty($conf->global->ALTATPL_EXTRAFIELDS_IN_COLUMNS))
{
	include_once __DIR__ . '/../../lib/altatpl.lib.php';
	global $rental_lines;
	altatpl_showOptionalsLabels($object, $conf->global->RENTAL_DONTMIX_LINES && empty($rental_lines) && ! $createlinetitle, $createlinetitle?'create':'view');
}

// Price HT
print '<td class="linecoluht right" style="width: 80px"><span id="title_up_ht">'.$langs->trans('PriceUHT').'</span></td>';
$nbcolforsubtotallines++;

// Multicurrency
if (!empty($conf->multicurrency->enabled) && $object->multicurrency_code != $conf->currency) print '<td class="linecoluht_currency right" style="width: 80px"><span id="title_up_ht_currency">'.$langs->trans('PriceUHTCurrency', $object->multicurrency_code).'</span></td>';
$nbcolforsubtotallines++;

// VAT
print '<td class="linecolvat center" style="width: 80px"><span id="title_vat">'.$langs->trans('VAT').'</span></td>';
$nbcolforsubtotallines++;

if (  ! empty($conf->global->ALTATPL_SHOW_TTCPRICE) && (empty($createlinetitle) || ($canupdatepricesoncreate && ! empty(senderissupplier)) ))
{
	print '<td class="linecolttc right" style="width: 80px"><span id="title_up_ttc">'.$langs->trans('PriceUTTC').'</span></td>';
	$nbcolforsubtotallines++;
}

// Reduction short
print '<td class="linecoldiscount right">'.$langs->trans('ReductionShort').'</td>';
$nbcolforsubtotallines++;

// Price HT remisé
if (!empty($conf->global->ALTATPL_SHOW_DISCOUNTEDPRICE))
{
	print '<td class="linecoldiscountedprice right" width="80">'.$langs->trans('PriceWithDiscount').'</td>';
	$nbcolforsubtotallines++;
}

// Fields for situation invoice
if ($object->situation_cycle_ref) {
	print '<td class="linecolcycleref right">' . $langs->trans('Progress') . '</td>';
	$nbcolforsubtotallines++;
	print '<td class="linecolcycleref2 right">' . $form->textwithpicto($langs->trans('TotalHT100Short'), $langs->trans('UnitPriceXQtyLessDiscount')) . '</td>';
	$nbcolforsubtotallines++;
}

if ($usemargins && ! empty($conf->margin->enabled) && empty($user->societe_id))
{
	if (!empty($user->rights->margins->creer) && (empty($createlinetitle) || ! empty($conf->global->ALTATPL_SHOW_MARGIN_INFOS)))
	{
		if ($conf->global->MARGIN_TYPE == "1")
			print '<td class="linecolmargin1 margininfos right" style="width: 80px">'.$langs->trans('BuyingPrice').'</td>';
		else
			print '<td class="linecolmargin1 margininfos right" style="width: 80px">'.$langs->trans('CostPrice').'</td>';
		$nbcolforsubtotallines++;
	}
	elseif( $createlinetitle )
	{
		print '<td></td>'; // for hidden buying price
		$nbcolforsubtotallines++;
	}

	if (! empty($user->rights->margins->creer) && (empty($createlinetitle) || ! empty($conf->global->ALTATPL_SHOW_MARGIN_INFOS)))
	{
		if (! empty($conf->global->DISPLAY_MARGIN_RATES) && $user->rights->margins->liretous)
		{
			print '<td class="linecolmargin2 margininfos right" style="width: 50px">'.$langs->trans('MarginRate').'</td>';
			$nbcolforsubtotallines++;
		}
		if (! empty($conf->global->DISPLAY_MARK_RATES) && $user->rights->margins->liretous)
		{
			print '<td class="linecolmargin2 margininfos right" style="width: 50px">'.$langs->trans('MarkRate').'</td>';
			$nbcolforsubtotallines++;
		}
	}
}
elseif( $createlinetitle )
{
	//print '<td></td>'; // for hidden buying price
	$nbcolforsubtotallines++;
}

// Define colspan for the button 'Add'
$colspan = 2;	// col edit + col delete
// commented by christophe battarelif ( $action == 'editline' || ($createlinetitle)) $colspan++; // Col total ht
if ( in_array($object->element, array('propal','supplier_proposal','facture','facturerec','invoice','commande','order','order_supplier','invoice_supplier'))) $colspan++;	// With this, there is a column move button


// Total HT
if ( ( ! $createlinetitle && $action != 'editline' ) || $drafteditable )
{
	print '<td class="linecolht right">'.$langs->trans('TotalHTShort').'</td>';

	// Multicurrency
	if ( ! empty($conf->multicurrency->enabled) && $object->multicurrency_code != $conf->currency &&  ! $createlinetitle ) print '<td class="linecoltotalht_currency right">'.$langs->trans('TotalHTShortCurrency', $object->multicurrency_code).'</td>';

	if ($outputalsopricetotalwithtax && empty($createlinetitle)) print '<td class="right" style="width: 80px">'.$langs->trans('TotalTTCShort').'</td>';
}

print '<td colspan="'.$colspan.'" align="right" style="min-width:30px;">';
if ( ! $drafteditable && count($object->lines) > 3 && $object->brouillon)
{
	if (empty($createlinetitle)) print '<a class="butAction" href="#tableaddline" title="'.$langs->trans("Bottom").'">&darr;</a>';
	else print '<a class="butAction" href="#tablelines" title="'.$langs->trans("Top").'">&uarr;</a>';
}
elseif ($drafteditable && ! $createlinetitle)
{
	print '<a class="addline '.($rental_lines?'rental':'sale').'" href="#" onclick="addline(this); return false">';
	print '<span class="addline">'.img_edit_add().'</span>';
	print '</a>';
}
print '</td>';

if($action == 'selectlines')
{
	print '<td class="linecolcheckall center">';
	print '<input type="checkbox" class="linecheckboxtoggle" />';
	print '<script>$(document).ready(function() {$(".linecheckboxtoggle").click(function() {var checkBoxes = $(".linecheckbox");checkBoxes.prop("checked", this.checked);})});</script>';
	print '</td>';
}

print "</tr>\n";
if (! $drafteditable || empty($createlinetitle)) print "</thead>\n";
?>
<script type="text/javascript">
function show_all()
{
	$("a.show_dispo").click();
}
<?php
if (empty($conf->global->ALTATPL_RENTAL_STOCK_HIDDEN))
	print '$(document).ready(show_all);';
?>
</script>
<!-- END PHP TEMPLATE objectline_title.tpl.php -->
