<?php
/* Copyright (C) 2010-2012	Regis Houssin		<regis.houssin@inodbox.com>
 * Copyright (C) 2010-2014	Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2012-2013	Christophe Battarel	<christophe.battarel@altairis.fr>
 * Copyright (C) 2012       Cédric Salvador     <csalvador@gpcsolutions.fr>
 * Copyright (C) 2014		Florian Henry		<florian.henry@open-concept.pro>
 * Copyright (C) 2014       Raphaël Doursenaud  <rdoursenaud@gpcsolutions.fr>
 * Copyright (C) 2015-2016	Marcos García		<marcosgdf@gmail.com>
 * Copyright (C) 2018       Frédéric France         <frederic.france@netlogic.fr>
 * Copyright (C) 2018		Ferran Marcet		<fmarcet@2byte.es>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Need to have following variables defined:
 * $object (invoice, order, ...)
 * $conf
 * $langs
 * $dateSelector
 * $forceall (0 by default, 1 for supplier invoices/orders)
 * $senderissupplier (0 by default, 1 or 2 for supplier invoices/orders)
 * $inputalsopricewithtax (0 by default, 1 to also show column with unit price including tax)
 */

// Protection to avoid direct call of template
if (empty($object) || ! is_object($object)) {
    print "Error: this template page cannot be called directly as an URL";
    exit;
}

if (empty($conf->global->DOLITOOLS_USE_ALTATPL)) return;

if ( ! in_array($object->element, array('propal','supplier_proposal','facture','facturerec','invoice','commande','order','order_supplier','invoice_supplier')) ) return;

$canupdatepricesoncreate =  ! empty($conf->global->ALTATPL_MODIFY_PRICES_ON_CREATE);

$usemargins=0;
if (empty($senderissupplier) && ! empty($conf->margin->enabled) && ! empty($object->element) && in_array($object->element, array('facture','facturerec','propal','commande')))
{
    $usemargins=1;
}
$showmargins = $usemargins;// && (empty($conf->rental->enabled) || empty($object->array_options['options_rental_doc']));

if (! isset($dateSelector)) global $dateSelector;	// Take global var only if not already defined into function calling (for example formAddObjectLine)
global $forceall, $forcetoshowtitlelines, $senderissupplier, $inputalsopricewithtax;

if (! isset($dateSelector)) $dateSelector=1;    // For backward compatibility
elseif (empty($dateSelector)) $dateSelector=0;
if (empty($forceall)) $forceall=0;
if (empty($senderissupplier)) $senderissupplier=0;
if (empty($inputalsopricewithtax)) $inputalsopricewithtax=0;


// Define colspan for the button 'Add'
$colspan = 2;	// col edit + col delete
if ( ! $drafteditable && in_array($object->element, array('propal','supplier_proposal','facture','facturerec','invoice','commande','order','order_supplier','invoice_supplier'))) $colspan++;	// With this, there is a column move button

// Lines for extrafield
$objectline = null;
// for v11
if (empty($extrafieldsline) && ! empty($extrafields)) $extrafieldsline = $extrafields;
// end v11
if (!empty($extrafieldsline))
{
	if ($this->table_element_line=='commandedet') {
		$objectline = new OrderLine($this->db);
	}
	elseif ($this->table_element_line=='propaldet') {
		$objectline = new PropaleLigne($this->db);
	}
	elseif ($this->table_element_line=='supplier_proposaldet') {
		$objectline = new SupplierProposalLine($this->db);
	}
	elseif ($this->table_element_line=='facturedet') {
		$objectline = new FactureLigne($this->db);
	}
	elseif ($this->table_element_line=='contratdet') {
		$objectline = new ContratLigne($this->db);
	}
	elseif ($this->table_element_line=='commande_fournisseurdet') {
		$objectline = new CommandeFournisseurLigne($this->db);
	}
	elseif ($this->table_element_line=='facture_fourn_det') {
		$objectline = new SupplierInvoiceLine($this->db);
	}
	elseif ($this->table_element_line=='facturedet_rec') {
		$objectline = new FactureLigneRec($this->db);
	}
}


?>

<!-- BEGIN PHP TEMPLATE objectline_create.tpl.php -->

<?php
global $drafteditable;
$drafteditable = $drafteditable && in_array($object->element, array('facture','facturerec','propal','commande'));

if ( ! $drafteditable)
{
	print '</table>';
	print '<table class="noborder noshadow centpercent" id="tableaddline">';
}

// ligne de titre pour saisie nouvelle ligne
$createlinetitle = true; // important for objectline_title.tpl.php
$parameters = array('createlinetitle'=>true, 'num'=>$num,'i'=>$i,'dateSelector'=>$dateSelector,'seller'=>$seller,'buyer'=>$buyer,'selected'=>$selected, 'extrafieldsline'=>$extrafieldsline, 'usemargins'=>$showmargins, 'linecreate_title'=>1);
$reshook = $hookmanager->executeHooks('printObjectLineTitle', $parameters, $this, $action);
if (empty($reshook))
{
	// Output template part (modules that overwrite templates must declare this into descriptor)
	// Use global variables + $dateSelector + $seller and $buyer
	$dirtpls=array_merge($conf->modules_parts['tpl'], array($defaulttpldir));
	foreach($dirtpls as $module => $reldir)
	{
		if (!empty($module))
		{
			$tpl = dol_buildpath($reldir.'/objectline_title.tpl.php');
		}
		else
		{
			$tpl = DOL_DOCUMENT_ROOT.$reldir.'/objectline_title.tpl.php';
		}
		if (empty($conf->file->strict_mode)) {
			$res=@include $tpl;
		} else {
			$res=include $tpl; // for debug
		}
		if ($res) break;
	}
}

	if ( $drafteditable ) print '<tr class="highlight nodrag nodrop draftcreate'.(($nolinesbefore || $object->element=='contrat')?'':' liste_titre_create'). '" style="display: none;">';
	else print '<tr class="pair nodrag nodrop nohoverpair'.(($nolinesbefore || $object->element=='contrat')?'':' liste_titre_create'). '">';

?>
<?php
    $coldisplay=0;
	if ( $drafteditable )
	{
		print '<td></td>';
		$coldisplay++;
	}

    // Adds a line numbering column
    if (! empty($conf->global->MAIN_VIEW_LINE_NUMBER) && !empty($object->lines)) {
		$coldisplay++;
		echo '<td align="center">';
		echo '<input type="text" name="rank" id="rank" size="1" style="text-align:right" />';
		echo '</td>';
	}

    $coldisplay++;
    ?>
	<td class="nobottom linecoldescription minwidth300imp nowrap">

	<input type="hidden" id="product_type" name="type" value="">
	<input type="hidden" id="stock_available" name="stock_available" value="">
	<input type="hidden" id="onpurchase" name="onpurchase" value="">

	<?php
	$freelines = false;
	if (empty($conf->global->MAIN_DISABLE_FREE_LINES))
	{
		$freelines = true;
		$forceall=1;	// We always force all type for free lines (module product or service means we use predefined product or service)
		if ($object->element == 'contrat')
		{
			if (empty($conf->product->enabled) && empty($conf->service->enabled) && empty($conf->global->CONTRACT_SUPPORT_PRODUCTS)) $forceall=-1;	// With contract, by default, no choice at all, except if CONTRACT_SUPPORT_PRODUCTS is set
			elseif (empty($conf->global->CONTRACT_SUPPORT_PRODUCTS)) $forceall=3;
		}

		// Free line
		echo '<span class="prod_entry_mode_free">';
		// Show radio free line
		if ($forceall >= 0 && (! empty($conf->product->enabled) || ! empty($conf->service->enabled)))
		{
			echo '<label for="prod_entry_mode_free">';
			echo '<input type="radio" class="prod_entry_mode_free" name="prod_entry_mode" id="prod_entry_mode_free" value="free"';
			//echo (GETPOST('prod_entry_mode')=='free' ? ' checked' : ((empty($forceall) && (empty($conf->product->enabled) || empty($conf->service->enabled)))?' checked':'') );
			echo (GETPOST('prod_entry_mode')=='free' ? ' checked' : '');
			echo '> ';
			// Show type selector
			echo $langs->trans("FreeLineOfType");
			echo '</label>';
			echo ' ';
		}
		else
		{
			echo '<input type="hidden" id="prod_entry_mode_free" name="prod_entry_mode" value="free">';
			// Show type selector
			if ($forceall >= 0)
			{
			    if (empty($conf->product->enabled) || empty($conf->service->enabled)) echo $langs->trans("Type");
				else echo $langs->trans("FreeLineOfType");
				echo ' ';
			}
		}

		echo $form->select_type_of_lines(isset($_POST["type"])?GETPOST("type", 'alpha', 2):-1, 'type', 1, 1, $forceall);

		echo '</span>';
	}

	// Predefined product/service
	if (! empty($conf->product->enabled) || ! empty($conf->service->enabled))
	{
		if ($drafteditable) echo '<input type="hidden" id="prodlink" name="prodlink" />';

		if ($forceall >= 0 && $freelines) echo '<br>';
		echo '<span class="prod_entry_mode_predef">';
		echo '<label for="prod_entry_mode_predef">';
		echo '<input type="radio" class="prod_entry_mode_predef" name="prod_entry_mode" id="prod_entry_mode_predef" value="predef"'.(GETPOST('prod_entry_mode')=='predef'?' checked':'').'> ';
		if (empty($senderissupplier))
		{
			if (! empty($conf->product->enabled) && empty($conf->service->enabled)) echo $langs->trans('PredefinedProductsToSell');
			elseif ((empty($conf->product->enabled) && ! empty($conf->service->enabled)) || ($object->element == 'contrat' && empty($conf->global->CONTRACT_SUPPORT_PRODUCTS))) echo $langs->trans('PredefinedServicesToSell');
			else echo $langs->trans('PredefinedProductsAndServicesToSell');
		}
		else
		{
			if (! empty($conf->product->enabled) && empty($conf->service->enabled)) echo $langs->trans('PredefinedProductsToPurchase');
			elseif (empty($conf->product->enabled) && ! empty($conf->service->enabled)) echo $langs->trans('PredefinedServicesToPurchase');
			else echo $langs->trans('PredefinedProductsAndServicesToPurchase');
		}
		if (!empty($object->array_options['options_rental_doc'])) echo '<input type="hidden" name="product_label" id="product_label">';
		echo '</label>';
		echo ' ';

		$filtertype='';
		if (! empty($object->element) && $object->element == 'contrat' && empty($conf->global->CONTRACT_SUPPORT_PRODUCTS)) $filtertype='1';

		$forcecombo = $drafteditable;

		if (empty($senderissupplier))
		{
			$ajaxoptions = array(
				'update' => array('remise_percent' => 'discount', 'price_ht'=>'price_ht')//, 'tva_tx'=>'vat_rate')			// html id tags that will be edited with each ajax json response key
			);

			if (! empty($conf->global->ENTREPOT_EXTRA_STATUS))
			{
				// hide products in closed warehouse, but show products for internal transfer
				$form->select_produits(GETPOST('idprod'), 'idprod', $filtertype, $conf->product->limit_size, $buyer->price_level, 1, 2, '', 1, $ajaxoptions, $buyer->id, '1', $forcecombo, 'maxwidth300', 0, 'warehouseopen,warehouseinternal', GETPOST('combinations', 'array'));
			}
			else
			{
				$form->select_produits(GETPOST('idprod'), 'idprod', $filtertype, $conf->product->limit_size, $buyer->price_level, 1, 2, '', 1, $ajaxoptions, $buyer->id, '1', $forcecombo, 'maxwidth300', 0, '', GETPOST('combinations', 'array'));
			}

			// add a checkbox to select only available products
			if (! empty($conf->stock->enabled) && ! empty($conf->global->USE_AVAILABLE_STOCK) && $conf->rental->enabled /* because no hook in product/ajax/select_produits.php */ && empty($object->array_options['options_rental_doc']) /* for the moment limit to getsellproducts */) {
				echo '&emsp;<input type="checkbox" name="available" id="available"';
				if (GETPOST('available')) echo ' checked="checked"';
				echo ' title="'.$langs->trans('ShowOnlyAvailableProducts').'" />';
			}
		}
		else
		{
			// $senderissupplier=2 is the same as 1 but disables test on minimum qty and disable autofill qty with minimum
		    if ($senderissupplier != 2)
		    {
    			$ajaxoptions=array(
    				'update' => array('qty'=>'qty','remise_percent' => 'discount','idprod' => 'idprod', 'price_ht'=>'up'),// 'tva_tx'=>'vat_rate'),	// html id tags that will be edited with which ajax json response key
    				'option_disabled' => 'idthatdoesnotexists',					// html id to disable once select is done
    				'warning' => $langs->trans("NoPriceDefinedForThisSupplier") // translation of an error saved into var 'warning' (for example shown we select a disabled option into combo)
    			);
    			$alsoproductwithnosupplierprice=0;
		    }
		    else
		    {
		        $ajaxoptions = array(
                    'update' => array('remise_percent' => 'discount', 'price_ht'=>'up')//, 'tva_tx'=>'vat_rate')			// html id tags that will be edited with each ajax json response key
    			);
		        $alsoproductwithnosupplierprice=1;
		    }

		    $form->select_produits_fournisseurs($object->socid, GETPOST('idprodfournprice'), 'idprodfournprice', '', '', $ajaxoptions, 1, $alsoproductwithnosupplierprice, 'maxwidth300');
		    if (! empty($conf->global->MAIN_AUTO_OPEN_SELECT2_ON_FOCUS_FOR_SUPPLIER_PRODUCTS))
		    {
			    ?>
	            <script type="text/javascript">
	                $(document).ready(function(){
		                	// On first focus on a select2 combo, auto open the menu (this allow to use the keyboard only)
		                	$(document).on('focus', '.select2-selection.select2-selection--single', function (e) {
								//console.log('focus on a select2');
								if ($(this).attr('aria-labelledby') == 'select2-idprodfournprice-container')
								{
			                	  	$('#idprodfournprice').select2('open');
								}
		                	});
	                });
	            </script>
	            <?php
		    }
		}
		echo '<input type="hidden" name="pbq" id="pbq" value="">';
		echo '</span>';
	}

	if (is_object($hookmanager) && empty($senderissupplier))
	{
        $parameters=array('fk_parent_line'=>GETPOST('fk_parent_line', 'int'));
		$reshook=$hookmanager->executeHooks('formCreateProductOptions', $parameters, $object, $action);
		if (!empty($hookmanager->resPrint)) {
			print $hookmanager->resPrint;
		}
	}
	if (is_object($hookmanager) && ! empty($senderissupplier))
	{
		$parameters=array('htmlname'=>'addproduct');
		$reshook=$hookmanager->executeHooks('formCreateProductSupplierOptions', $parameters, $object, $action);
		if (!empty($hookmanager->resPrint)) {
			print $hookmanager->resPrint;
		}
	}


	if (! empty($conf->product->enabled) || ! empty($conf->service->enabled)) {

		if (!empty($conf->variants->enabled)) {
			echo '<div id="attributes_box"></div>';
		}

		echo '<br>';
	}

	// Editor wysiwyg
	require_once DOL_DOCUMENT_ROOT.'/core/class/doleditor.class.php';
	$nbrows=ROWS_2;
	$enabled=(! empty($conf->global->FCKEDITOR_ENABLE_DETAILS)?$conf->global->FCKEDITOR_ENABLE_DETAILS:0);
	if (! empty($conf->global->MAIN_INPUT_DESC_HEIGHT)) $nbrows=$conf->global->MAIN_INPUT_DESC_HEIGHT;
	$toolbarname='dolibarr_details';
	if (! empty($conf->global->FCKEDITOR_ENABLE_DETAILS_FULL)) $toolbarname='dolibarr_notes';
	$doleditor=new DolEditor('dp_desc', GETPOST('dp_desc', 'none'), '', (empty($conf->global->MAIN_DOLEDITOR_HEIGHT)?100:$conf->global->MAIN_DOLEDITOR_HEIGHT), $toolbarname, '', false, true, $enabled, $nbrows, '98%');
	$doleditor->Create();

	// Show autofill date for recurring invoices
	if (! empty($conf->service->enabled) && $object->element == 'facturerec')
	{
		echo '<div class="divlinefordates"><br>';
		echo $langs->trans('AutoFillDateFrom').' ';
		echo $form->selectyesno('date_start_fill', $line->date_start_fill, 1);
		echo ' - ';
		echo $langs->trans('AutoFillDateTo').' ';
		echo $form->selectyesno('date_end_fill', $line->date_end_fill, 1);
		echo '</div>';
	}
	echo '</td>';

	if  (empty($conf->global->ALTATPL_HIDE_REF_FOURN) && ($object->element == 'supplier_proposal' || $object->element == 'order_supplier' || $object->element == 'invoice_supplier'))	{
		$coldisplay++;
        ?>
		<td class="nobottom linecolresupplier"><input id="fourn_ref" name="fourn_ref" class="flat minwidth50 maxwidth150" value="<?php echo (isset($_POST["fourn_ref"])?GETPOST("fourn_ref", 'alpha', 2):''); ?>"></td>
	<?php }

	?>
	<td class="nobottom linecolqty right"><input type="text" size="1" name="qty" id="qty" class="flat right" value="<?php echo (isset($_POST["qty"])?GETPOST("qty", 'alpha', 2):1); ?>">
	</td>
	<?php
	if($conf->global->PRODUCT_USE_UNITS)
	{
	    $coldisplay++;
		print '<td class="nobottom linecoluseunit left">';
		print $form->selectUnits($line->fk_unit, "units", 0);
		print '</td>';
	}

	// Stock Infos
	if (! empty($conf->stock->enabled) && ! empty($conf->global->ALTATPL_STOCK_ON_LINES) && empty($senderissupplier))
	{
		print '<td class="nowrap"><div class="dispo"></div></td>';
		$coldisplay++;
	}

	// extrafields
	if (is_object($objectline) && ! empty($conf->global->ALTATPL_EXTRAFIELDS_IN_COLUMNS))
	{
		include_once __DIR__ . '/../../lib/altatpl.lib.php';
		$coldisplay += altatpl_showOptionalsValues($objectline, $extrafieldsline, 'create', true);
	}

	?>
	<td class="nobottom linecoluht right"><?php $coldisplay++; ?>
	<input type="text" size="5" name="price_ht" id="price_ht" class="flat right" style="<?php if (empty($canupdatepricesoncreate)) print 'display: none;'; ?>" value="<?php echo (isset($_POST["price_ht"])?GETPOST("price_ht", 'alpha', 2):''); ?>">
	</td>

	<?php if (!empty($conf->multicurrency->enabled) && $this->multicurrency_code != $conf->currency) {
	    $coldisplay++;
	?>
	<td class="nobottom linecoluht_currency right">
	<input type="text" size="5" name="multicurrency_price_ht" id="multicurrency_price_ht" class="flat right" style="<?php if (empty($canupdatepricesoncreate)) print 'display: none;'; ?>" value="<?php echo (isset($_POST["multicurrency_price_ht"])?GETPOST("multicurrency_price_ht", 'alpha', 2):''); ?>">
	</td>
	<?php } ?>

	<td class="nobottom linecolvat right"><?php
	$coldisplay++;
	if ($seller->tva_assuj == "0") echo '<input type="hidden" name="tva_tx" id="tva_tx" value="0">'.vatrate(0, true);
	else echo $form->load_tva('tva_tx', (isset($_POST["tva_tx"])?GETPOST("tva_tx", 'alpha', 2):-1), $seller, $buyer, 0, 0, '', false, 0);
	?>
	</td>

	<?php if ( ! empty($canupdatepricesoncreate)  && ! empty($conf->global->ALTATPL_SHOW_TTCPRICE) ) {
	   $coldisplay++;
	?>
	<td class="nobottom linecoluttc right">
	<input type="text" size="5" name="price_ttc" id="price_ttc" class="flat" value="<?php echo (isset($_POST["price_ttc"])?GETPOST("price_ttc", 'alpha', 2):''); ?>">
	</td>
	<?php }

	$coldisplay++;

	$remise_percent = $buyer->remise_percent;
	if($object->element == 'supplier_proposal' || $object->element == 'order_supplier' || $object->element == 'invoice_supplier')
	{
		$remise_percent = $seller->remise_supplier_percent;
	}

	$coldisplay++;

	if (empty($remise_percent) && ! empty($conf->global->DOLITOOLS_GLOBAL_DISCOUNT)) $remise_percent = $object->array_options['options_global_discount'];
	?>
	<td class="nobottom nowrap linecoldiscount right"><input type="text" size="1" name="remise_percent" id="remise_percent" class="flat right" value="<?php echo (isset($_POST["remise_percent"])?GETPOST("remise_percent", 'alpha', 2):$remise_percent); ?>"><span class="hideonsmartphone">%</span></td>

	<?php
	// discounted price TODO : remove rental stuff
	if (!empty($conf->global->ALTATPL_SHOW_DISCOUNTEDPRICE))
	{
		$coldisplay++;
		?>
		<td class="nobottom linecolpxrem right"><?php $coldisplay++; ?>
		<input type="text" size="5" name="discounted_price" id="discounted_price" class="flat right" style="<?php if (empty($canupdatepricesoncreate)) print 'display: none;'; ?>" value="<?php echo (isset($_POST["discounted_price"])?GETPOST("discounted_price", 'alpha', 2):''); ?>">
		</td>
	<?php
	}

	if ($this->situation_cycle_ref) {
		$coldisplay++;
		print '<td class="nobottom nowrap right"><input class="falt right" type="text" size="1" value="0" name="progress">%</td>';
		$coldisplay++;
		print '<td></td>';
	}

	$coldisplay++;
	if (empty($senderissupplier))
	{
	?>
	<td class="nobottom margininfos linecolmargin right">

		<?php if (! empty($conf->product->enabled) || ! empty($conf->service->enabled)) { ?>
		<select id="fournprice_predef" name="fournprice_predef" class="flat" style="display: none;"></select>
		<?php } ?>

		<?php if ( ! empty($conf->global->ALTATPL_SHOW_MARGIN_INFOS) && ! empty($user->rights->margins->creer))
		{
		?>
			<input type="text" size="5" id="buying_price" name="buying_price" class="flat right" value="<?php echo (isset($_POST["buying_price"])?GETPOST("buying_price", 'alpha', 2):''); ?>">
		<?php
		}
		else
		{
		?>
			<input type="hidden" id="buying_price" name="buying_price" value="<?php echo (isset($_POST["buying_price"])?GETPOST("buying_price", 'alpha', 2):''); ?>">
		<?php
		}
		?>
	</td>
	<?php
	}

	if (! empty($showmargins))
	{
		if ($user->rights->margins->creer && !empty($conf->global->ALTATPL_SHOW_MARGIN_INFOS))
		{
			if (! empty($conf->global->DISPLAY_MARGIN_RATES))
			{
				echo '<td class="nobottom nowrap margininfos right"><input class="flat right" type="text" size="2" id="np_marginRate" name="np_marginRate" value="'.(isset($_POST["np_marginRate"])?GETPOST("np_marginRate", 'alpha', 2):'').'"><span class="np_marginRate hideonsmartphone">%</span></td>';
				$coldisplay++;
			}
			if (! empty($conf->global->DISPLAY_MARK_RATES))
			{
				echo '<td class="nobottom nowrap margininfos right"><input class="flat right" type="text" size="2" id="np_markRate" name="np_markRate" value="'.(isset($_POST["np_markRate"])?GETPOST("np_markRate", 'alpha', 2):'').'"><span class="np_markRate hideonsmartphone">%</span></td>';
				$coldisplay++;
			}
		}
	}

	$coldisplay+=$colspan;

	if ($drafteditable)
	{
		$colspan++;
		if (!empty($conf->multicurrency->enabled) && $this->multicurrency_code != $conf->currency) {
			$colspan++;
		}
		if ($outputalsopricetotalwithtax)
		{
			$colspan++;
		}
		?>
	<?php
	}
	?>
	<td class="nobottom linecoledit center valignmiddle" colspan="<?php echo $colspan; ?>">
		<input type="submit" class="button" value="<?php echo $langs->trans('Add'); ?>" name="addline" id="addline" />
	<?php
		if ($drafteditable)
		{
		?>
		<br/><br/><input id="cancellinebutton" name="cancellinebutton" type="button" class="button" value="<?php echo $langs->trans('Cancel'); ?>" onclick="hidecreate(this);" />
		<?php
		}
		?>
	</td>
</tr>

<?php
if (is_object($objectline) && empty($conf->global->ALTATPL_EXTRAFIELDS_IN_COLUMNS))
{
	print $objectline->showOptionals($extrafieldsline, 'edit', array('style'=>$bcnd[$var], 'colspan'=>$coldisplay), '', '', 0);
}

if ((! empty($conf->service->enabled) || ($object->element == 'contrat')) && $dateSelector && GETPOST('type') != '0')	// We show date field if required
{
	?>

	<tr id="trlinefordates" <?php echo $bcnd[$var]; if ($drafteditable) echo ' class="draftcreate highlight" style="display: none;"'; ?>>
	<?php if (! empty($conf->global->MAIN_VIEW_LINE_NUMBER)) { print '<td></td>'; } ?>
	<td colspan="<?php echo $coldisplay; ?>">
	<?php
	$date_start=dol_mktime(GETPOST('date_starthour'), GETPOST('date_startmin'), 0, GETPOST('date_startmonth'), GETPOST('date_startday'), GETPOST('date_startyear'));
	$date_end=dol_mktime(GETPOST('date_starthour'), GETPOST('date_startmin'), 0, GETPOST('date_endmonth'), GETPOST('date_endday'), GETPOST('date_endyear'));
	if (! empty($object->element) && $object->element == 'contrat')
	{
		print $langs->trans("DateStartPlanned").' ';
		print $form->selectDate($date_start, "date_start", $usehm, $usehm, 1, "addproduct");
		print ' &nbsp; '.$langs->trans("DateEndPlanned").' ';
		print $form->selectDate($date_end, "date_end", $usehm, $usehm, 1, "addproduct");
	}
	else
	{
		echo $langs->trans('ServiceLimitedDuration').' '.$langs->trans('From').' ';
		print $form->selectDate($date_start, 'date_start', empty($conf->global->MAIN_USE_HOURMIN_IN_DATE_RANGE)?0:1, empty($conf->global->MAIN_USE_HOURMIN_IN_DATE_RANGE)?0:1, 1, "addproduct", 1, 0);
		echo ' '.$langs->trans('to').' ';
		print $form->selectDate($date_end, 'date_end', empty($conf->global->MAIN_USE_HOURMIN_IN_DATE_RANGE)?0:1, empty($conf->global->MAIN_USE_HOURMIN_IN_DATE_RANGE)?0:1, 1, "addproduct", 1, 0);
	};
	print '<script>';
	if (!$date_start) {
		if (isset($conf->global->MAIN_DEFAULT_DATE_START_HOUR)) {
			print '$("#date_starthour").val("'.$conf->global->MAIN_DEFAULT_DATE_START_HOUR.'");';
		}
		if (isset($conf->global->MAIN_DEFAULT_DATE_START_MIN)) {
			print '$("#date_startmin").val("'.$conf->global->MAIN_DEFAULT_DATE_START_MIN.'");';
		}
	}
	if (!$date_end) {
		if (isset($conf->global->MAIN_DEFAULT_DATE_END_HOUR)) {
			print '$("#date_endhour").val("'.$conf->global->MAIN_DEFAULT_DATE_END_HOUR.'");';
		}
		if (isset($conf->global->MAIN_DEFAULT_DATE_END_MIN)) {
			print '$("#date_endmin").val("'.$conf->global->MAIN_DEFAULT_DATE_END_MIN.'");';
		}
	}
	print '</script>'
	?>
	</td>
	</tr>
<?php
}
?>

<script type="text/javascript">

	var newid = 0;

	function hidecreate(elem)
	{
		$("tr.liste_titre, div.tabsAction").show();
		$("tr.draftcreate input").prop( "disabled", true );
		$("tr.draftcreate").hide().appendTo($(elem).parents("tbody:first")); // put back at the end of table to avoid dnd conflicts
	}

	function createline(tr)
	{
		if ( ! $("#prod_entry_mode_free").prop("checked") && $("#idprod", tr).val() == "") { alert("<?php echo dol_html_entity_decode($langs->trans("ProductMandatory"), ENT_QUOTES); ?>"); return false; }

		// we need to replace ckeditor when moving the row
		var use_ck;
		var ck_options = {};
		var ck_data;
		if(typeof CKEDITOR == "object" && typeof CKEDITOR.instances != "undefined" && typeof CKEDITOR.instances['dp_desc'] != 'undefined') {
			ck_data = CKEDITOR.instances['dp_desc'].getData();
			ck_options = CKEDITOR.instances['dp_desc'].config;
			CKEDITOR.instances['dp_desc'].destroy();
			use_ck = true;
		}

		newid++;
		var newtr = $(tr).clone();

		var tddel = '<td class="linecoldelete center">';
		tddel += '<div class="restore_line" style="display: none;"><?php echo $langs->trans("LineDeleted"); ?></div>';
		tddel += '<a class="delete" href="#" onclick="toggle_line(this); return false">';
		tddel += '<span class="delete_line"><?php echo img_delete(); ?></span>';
		tddel += '<div class="restore_line" style="display: none;"><?php echo $langs->trans("Restore"); ?></div>';
		tddel += '</a>';
		tddel += '</td>';

		var tdadd = '<td class="linecoladd center">';
		tdadd += '<a class="addline '+ ($(tr).hasClass('rental')?'rental':'sale') + '" href="#" onclick="addline(this); return false">';
		tdadd += '<span class="addline"><?php echo img_edit_add(); ?></span>';
		tdadd += '</a>';
		tdadd += '</td>';

		var tdmove = '';
		// dynamic created lines
		<?php
		if ($conf->browser->layout != 'phone' && ($object->situation_counter == 1 || !$object->situation_cycle_ref) && empty($disablemove)) { ?>
			tdmove += '<td class="linecolmove tdlineupdown center">';
			tdmove += '<a class="lineupdown" href="#">';
			tdmove += "<?php echo dol_escape_js(img_up('default', 0, 'imgupforline')); ?>";
			tdmove += '</a>';
			tdmove += '<a class="lineupdown" href="#">';
			tdmove += "<?php echo dol_escape_js(img_down('default', 0, 'imgdownforline')); ?>";
			tdmove += '</a>';
			tdmove += '</td>';
		<?php } else { ?>
			tdmove += '<td ';
			tdmove += <?php echo (($conf->browser->layout != 'phone' && empty($disablemove)) ?' class="linecolmove tdlineupdown center"':' class="linecolmove center"'); ?> + '></td>';
		<?php } ?>

		$(".tdlineupdown").hover( function() { $(this).addClass('showDragHandle'); },
			function() { $(this).removeClass('showDragHandle'); }
		);

		$('td.linecoledit', newtr).replaceWith(tdadd + tddel + tdmove);

		$(newtr).prop(
			{
				'id' : 'new_'+newid,
				'class':'oddeven drag drop newline ' + ($(tr).hasClass("rental")?'rental':'sale')
			});

		<?php
		if (! empty($conf->global->DOLITOOLS_USE_DELETELINES))
		{
		?>
			$('td:first', newtr).prop('align', 'center').append('<input id="sel" name="sel" type="checkbox" />');
		<?php
		}
		?>

		$('td.linecoldescription span', newtr).remove();
		$('td.linecoldescription script', newtr).remove();

		var idprod = $('#idprod', tr).val();
		var hidden_values = '<div id="row-new_'+newid + '"></div>';
		hidden_values += '<input type="hidden" id="lineid" name="lineid" value="new_'+newid + '">';
		hidden_values += '<input type="hidden" id="product_type" name="type" value="0">';
		hidden_values += '<input type="hidden" id="product_id" name="productid" value="'+idprod+'">';
		hidden_values += '<input type="hidden" id="special_code" name="special_code" value="0">';
		hidden_values += '<input type="hidden" id="fk_parent_line" name="fk_parent_line" value="">';

		$('td.linecoldescription', newtr).prepend(hidden_values + $('#prodlink', tr).val());

		$('input, select, textarea', newtr).each(function() {
			$(this).prop('id',$(this).prop('id')+ '_new_'+newid);
			$(this).prop('name',$(this).prop('name')+ '_new_'+newid);
		});

		$("tr.liste_titre, div.tabsAction").show();
		$("tr.draftcreate input, tr.draftcreate textarea").prop( "disabled", true );
		$("tr.draftcreate").hide().appendTo($(newtr).parents("tbody:first")); // put back at the end of table to avoid dnd conflicts

		$(newtr).insertBefore(tr);

		if (use_ck) CKEDITOR.replace("dp_desc_new_"+newid , ck_options);

		reorder_lines($(newtr).parents("tbody:first"));

		prepare_dnd($(newtr).parents("table:first"));

		$('input[name^=rank]' ,newtr).prop('disabled', false);

		return newid;
	}

<?php
if ($drafteditable)
{
?>
	function reorder_lines(tbodies, draftchanged = true)
	{
		$(tbodies).each(function()
		{
			$("input[name^=rank_]", this).each(function(i) { $(this).val(i+1); });
			$("form#draftedit").data("changed",draftchanged);
			if (draftchanged) $("a.draftchanged").show();
		});
	}

	$(document).ready(function()
	{
		$("input#addline").click(function()
		{
			var tr = $(this).parents("tr:first"); // important
			createline(tr);
			return false;
		});


		$("table").on("change", "[name^=rank]", function(event) {
			if ($(this).val() >= 0)
			{
				var tr = $(this).parents("tr:first");

				if ($(tr).hasClass("draftcreate")) return;

				var tbody = $(this).parents("tbody:first");

				var id = $(tr).attr("id").replace("row-", "");

				// we need to replace ckeditor when moving the row
				var use_ck;
				var ck_options = {};
				if(typeof CKEDITOR == "object" && typeof CKEDITOR.instances != "undefined" && typeof CKEDITOR.instances['product_desc_'+id] != 'undefined') {
					ck_options = CKEDITOR.instances['product_desc_'+id].config;
					CKEDITOR.instances['product_desc_'+id].updateElement();
					CKEDITOR.instances['product_desc_'+id].destroy();
					use_ck = true;
				}

				var lastrow = $("tr", tbody).length - 1;

				if ($(this).val() > lastrow)
				{
					$("tr:eq(" + lastrow + ")", tbody).after(tr);
				}
				else
				{	var index = $("tr", tbody).index(tr);
					if ($(this).val() > index) $("tr:eq(" + $(this).val() + ")", tbody).before(tr);
					else $("tr:eq(" + ($(this).val() - 1) + ")", tbody).before(tr);
				}

				// we need to replace ckeditor when moving the row
				if (use_ck) CKEDITOR.replace('product_desc_'+id, ck_options);

				reorder_lines(tbody);
			}
		});

		// init
		reorder_lines($("table.tablelines > tbody"), false);

	});
<?php
}

if (! empty($showmargins) && $user->rights->margins->creer)
{
?>

	/* Some js test when we click on button "Add" */
	$(document).ready(function() {
		<?php
		if (! empty($conf->global->DISPLAY_MARGIN_RATES)) { ?>
			$("input[name='np_marginRate']:first").change(function(e) {
				return checkFreeLine(e, "np_marginRate");
			});
		<?php
		}
		if (! empty($conf->global->DISPLAY_MARK_RATES)) { ?>
			$("input[name='np_markRate']:first").change(function(e) {
				return checkFreeLine(e, "np_markRate");
			});
		<?php
		}
		?>
	});

	/* TODO This does not work for number with thousand separator that is , */
	function checkFreeLine(e, npRate)
	{
		var buying_price = $("input[name='buying_price']:first");
		var remise = $("input[name='remise_percent']:first");

		var rate = $("input[name='"+npRate+"']:first");
		if (rate.val() == '')
			return true;

		if (! $.isNumeric(rate.val().replace(',','.')))
		{
			alert('<?php echo dol_escape_js($langs->trans("rateMustBeNumeric")); ?>');
			e.stopPropagation();
			setTimeout(function () { rate.focus() }, 50);
			return false;
		}
		if (npRate == "np_markRate" && rate.val() >= 100)
		{
			alert('<?php echo dol_escape_js($langs->trans("markRateShouldBeLesserThan100")); ?>');
			e.stopPropagation();
			setTimeout(function () { rate.focus() }, 50);
			return false;
		}

		var price = 0;
		remisejs=price2numjs(remise.val());

		if (remisejs != 100)	// If a discount not 100 or no discount
		{
			if (remisejs == '') remisejs=0;

			bpjs=price2numjs(buying_price.val());
			ratejs=price2numjs(rate.val());

			if (npRate == "np_marginRate")
				price = ((bpjs * (1 + ratejs / 100)) / (1 - remisejs / 100));
			else if (npRate == "np_markRate")
				price = ((bpjs / (1 - ratejs / 100)) / (1 - remisejs / 100));
		}

		$("input[name='price_ht']:first").val(price).change();	// TODO Must use a function like php price to have here a formated value

		return true;
	}

<?php
}
?>

/* JQuery for product free or predefined select */
$(document).ready(function() {

<?php
if ( ! $drafteditable )
{
?>
	$("#price_ht").change(function(event) {
		var tr = $(this).parents("tr:first");

		if ($(this).val() == '') return;

		if ($("input[name=options_rental_line]", tr).prop("checked")) return;
			var price_ht = price2numjs($(this).val());
			var tva_tx = price2numjs($("select[name^=tva_tx]", tr).val());
			$("input[name^=price_ttc]", tr).val(price_ht * (1 + tva_tx / 100));
			var remise_percent = price2numjs($("#remise_percent", tr).val());
			var discounted = price_ht * (1 - remise_percent / 100);
			$("input[name^=discounted_price]", tr).val(discounted);
			var qty = $("input[name^=qty]", tr).val();
			$("td.linecolht", tr).text(discounted * qty);
			$("#multicurrency_subprice", tr).val('');
	});
	$("#discounted_price").change(function(event) {
		var tr = $(this).parents("tr:first");
		if ($("input[name=options_rental_line]", tr).prop("checked")) return;
			var pxrem = price2numjs($(this).val());
			var price_ht = price2numjs($("#price_ht", tr).val());
			if (price_ht != 0) $("input[name^=remise_percent]", tr).val(((price_ht - pxrem) / price_ht) * 100);
			$("#multicurrency_subprice", tr).val('');
	});
	$("#remise_percent").change(function(event) {
		var tr = $(this).parents("tr:first");
		if ($("input[name=options_rental_line]", tr).prop("checked")) return;
			var remise_percent = price2numjs($(this).val());
			var price_ht = price2numjs($("#price_ht", tr).val());
			$("input[name^=discounted_price]", tr).val(price_ht * (1 - remise_percent / 100));
			$("#multicurrency_subprice", tr).val('');
	});
	$("tva_tx").change(function() {
		var tr = $(this).parents("tr:first");
			var price_ht = price2numjs($("#price_ht", tr).val());
			var tva_tx = price2numjs($(this).val());
			$("input[name^=price_ttc]", tr).val(price_ht * (1 + tva_tx / 100));
	});
	$("#price_ttc").change(function(event) {
		var tr = $(this).parents("tr:first", tr);
		// console.log(event.which);		// discard event tag and arrows
			var price_ttc = price2numjs($(this).val());
			var tva_tx = price2numjs($("select[name^=tva_tx]", tr).val());
			if (parseFloat(tva_tx) == 0) $("#price_ht", tr).val(price_ttc).change();
			else $("#price_ht", tr).val(price_ttc / (1 + tva_tx / 100)).change();
			$("#multicurrency_subprice", tr).val('');
	});
	$("#multicurrency_subprice").change(function(event) {
		var tr = $(this).parents("tr:first", tr);
		// console.log(event.which);		// discard event tag and arrows
			$("#price_ht", tr).val('');
			$("#price_ttc", tr).val('');
			$("#discounted_price", tr).val('');
	});
<?php
}
?>
	$("#prod_entry_mode_free").on( "click", function() {
		setforfree();
	});
	$("#select_type").change(function()
	{
		setforfree();
		if ($('#select_type').val() >= 0)
		{
			/* focus work on a standard textarea but not if field was replaced with CKEDITOR */
			$('#dp_desc').focus();
			/* focus if CKEDITOR */
			if (typeof CKEDITOR == "object" && typeof CKEDITOR.instances != "undefined")
			{
				var editor = CKEDITOR.instances['dp_desc'];
   				if (editor) { editor.focus(); }
			}
		}
		console.log("Hide/show date according to product type");
		if ($('#select_type').val() == '0')
		{
			$('#trlinefordates').hide();
			$('.divlinefordates').hide();
		}
		else
		{
			$('#trlinefordates').show();
			$('.divlinefordates').show();
		}
	});

	$("#prod_entry_mode_predef").on( "click", function() {
		console.log("click prod_entry_mode_predef");
		setforpredef();
		$('#trlinefordates').show();
	});

	<?php
	if(!$freelines) { ?>
		$("#prod_entry_mode_predef").click();
	<?php
	}
	?>

	/* When changing predefined product, we reload list of supplier prices required for margin combo */
	$("#idprod, #idprodfournprice").change(function()
	{
		var tr = $(this).parents("tr:first");
		if ($("input[name=options_rental_line]", tr).prop("checked")) return;

		console.log("#idprod, #idprodfournprice change triggered");

		setforpredef();		// TODO Keep vat combo visible and set it to first entry into list that match result of get_default_tva

		$('#trlinefordates').show();

		<?php
		if (! empty($showmargins) && $user->rights->margins->creer)
		{
			$langs->load('stocks');
			?>

    		/* Code for margin */
      		$("#fournprice_predef").find("option").remove();
    		$("#fournprice_predef").hide();
    		<?php
    		if (! empty($user->rights->margins->creer) && !empty($conf->global->ALTATPL_SHOW_MARGIN_INFOS))
    		{
			?>
				$("#buying_price").val("").show();
			<?php
			}
			?>
    		/* Call post to load content of combo list fournprice_predef */
      		$.post('<?php echo dol_buildpath('/fourn/ajax/getSupplierPrices.php', 1); ?>?bestpricefirst=1', { 'idprod': $(this).val() , 'element': "<?php echo $object->element; ?>" }, function(data) {
    	    	if (data && data.length > 0)
    	    	{
        	  		var options = ''; var defaultkey = ''; var defaultprice = ''; var bestpricefound = 0;

    	      		var bestpriceid = 0; var bestpricevalue = 0;
    	      		var pmppriceid = 0; var pmppricevalue = 0;
    	      		var costpriceid = 0; var costpricevalue = 0;

    				/* setup of margin calculation */
    	      		var defaultbuyprice = '<?php
    	      		if (isset($conf->global->MARGIN_TYPE))
    	      		{
    	      		    if ($conf->global->MARGIN_TYPE == '1')   print 'bestsupplierprice';
    	      		    if ($conf->global->MARGIN_TYPE == 'pmp') print 'pmp';
    	      		    if ($conf->global->MARGIN_TYPE == 'costprice') print 'costprice';
    	      		} ?>';
    	      		console.log("we will set the field for margin. defaultbuyprice="+defaultbuyprice);

    	      		var i = 0;
    	      		var defaultoption = '';
    	      		var myoption = '';

    	      		$(data).each(function() {

						var label = "";
						<?php
						if (!empty($conf->global->ALTATPL_FOURNREF_ON_PRICELIST))
						{ ?>
							label = this.label;
						<?php
						}
						else
						{ ?>
							var pos = this.label.indexOf(' (');
							if (pos > 0) label = this.label.substr(0,pos);
							else label = this.label;
						<?php
						} ?>

    	      			if (this.id != 'pmpprice' && this.id != 'costprice')
    		      		{
    		        		i++;
                            this.price = parseFloat(this.price); // to fix when this.price >0
    			      		// If margin is calculated on best supplier price, we set it by defaut (but only if value is not 0)
    		      			if (bestpricefound == 0 && this.price > 0) {
								defaultkey = this.id; defaultprice = this.price; bestpriceid = this.id; bestpricevalue = this.price; bestpricefound=1;
								defaultoption = '<option value="'+this.id+'" price="'+this.price+'" selected="selected">'+label+'</option>';
							}	// bestpricefound is used to take the first price > 0
    		      		}
    	      			if (this.id == 'pmpprice')
    	      			{
    	      				// If margin is calculated on PMP, we set it by defaut (but only if value is not 0)
    			      		//console.log("id="+this.id+"-price="+this.price);
    			      		if ('pmp' == defaultbuyprice || 'costprice' == defaultbuyprice)
    			      		{
    			      			if (this.price > 0) {
    				      			defaultkey = this.id; defaultprice = this.price; pmppriceid = this.id; pmppricevalue = this.price;
    				      			myoption = '<option value="'+this.id+'" price="'+this.price+'" selected="selected">'+label+'</option>';
    			      				//console.log("pmppricevalue="+pmppricevalue);
    			      			}
    			      		}
    	      			}
    	      			if (this.id == 'costprice')
    	      			{
    	      				// If margin is calculated on Cost price, we set it by defaut (but only if value is not 0)
    			      		//console.log("id="+this.id+"-price="+this.price+"-pmppricevalue="+pmppricevalue);
    			      		if ('costprice' == defaultbuyprice)
    			      		{
    		      				if (this.price > 0) {
									defaultkey = this.id; defaultprice = this.price; costpriceid = this.id; costpricevalue = this.price;
									myoption = '<option value="'+this.id+'" price="'+this.price+'" selected="selected">'+label+'</option>';
    		      				}
    			      		}
    	      			}
     	      		});

    	      		if (myoption == '') myoption = defaultoption;
    	      		if (defaultoption != '') options += myoption;
    	      		if (defaultkey != '') options += '<option value="inputprice" price="'+defaultprice+'"><?php echo dol_escape_js($langs->trans("InputPrice")); ?></option>';
    	      		else options += '<option value="inputprice" price="'+defaultprice+'" selected="selected"><?php echo dol_escape_js($langs->trans("InputPrice")); ?></option>';

    	      		$("#fournprice_predef").change(function() {
    		      		console.log("change on fournprice_predef");
    	      			/* Hide field buying_price according to choice into list (if 'inputprice' or not) */
    					var linevalue=$(this).find('option:selected').val();
    	        		var pricevalue = $(this).find('option:selected').attr("price");
    	        		if (linevalue != 'inputprice' && linevalue != 'pmpprice') {
    	          			$("#buying_price").val(pricevalue).hide();	/* We set value then hide field */
    	        		}
    	        		if (linevalue == 'inputprice') {
    		          		$('#buying_price').show();
    	        		}
    	        		if (linevalue == 'pmpprice') {
    	        			$("#buying_price").val(pricevalue);
    		          		$('#buying_price').hide();
    	        		}
    				});

    	      		/* At loading, no product are yet selected, so we hide field of buying_price */
    	      		$("#buying_price").hide();

    	      		/* Define default price at loading */
    	      		var defaultprice = $("#fournprice_predef").find('option:selected').attr("price");
    			    $("#buying_price").val(defaultprice);


					$("#fournprice_predef").html(options).change();

					<?php
					if (! empty($user->rights->margins->creer) && !empty($conf->global->ALTATPL_SHOW_MARGIN_INFOS))
					{
					?>
						$("#fournprice_predef").show();
					<?php
					}
					?>
    	      		if (defaultkey != '')
    				{
    		      		$("#fournprice_predef").val(defaultkey);
    		      	}

    	    	}
    	  	},
    	  	'json');

  		<?php
        }
        ?>

        /* To process customer price per quantity */
        var pbq = parseInt($('option:selected', this).attr('data-pbq'));
        var pbqqty = parseFloat($('option:selected', this).attr('data-pbqqty'));
        var pbqpercent = parseFloat($('option:selected', this).attr('data-pbqpercent'));

        if (($('#idprod').val() > 0 || $('#idprodfournprice').val()) && typeof pbq !== "undefined")
        {
            console.log("We choose a price by quanty price_by_qty id = "+pbq+" price_by_qty qty = "+pbqqty+" price_by_qty percent = "+pbqpercent);
            $("#pbq").val(pbq);
            if ($("#qty").val() < pbqqty)
            {
                    $("#qty").val(pbqqty);
            }
            if ($("#remise_percent").val() < pbqpercent)
            {
                    $("#remise_percent").val(pbqpercent);
            }
        }
        else
        {
            $("#pbq").val('');
        }

  		/* To set focus */
  		if ($('#idprod').val() > 0 || $('#idprodfournprice').val() > 0)
  	  	{
			/* focus work on a standard textarea but not if field was replaced with CKEDITOR */
			$('#dp_desc').focus();
			/* focus if CKEDITOR */
			if (typeof CKEDITOR == "object" && typeof CKEDITOR.instances != "undefined")
			{
				var editor = CKEDITOR.instances['dp_desc'];
   				if (editor) { editor.focus(); }
			}
  	  	}
	});

	<?php if (GETPOST('prod_entry_mode') == 'predef') { // When we submit with a predef product and it fails we must start with predef ?>
		setforpredef();
	<?php } ?>
});

/* Function to set fields from choice */
function setforfree() {
	console.log("Call setforfree. We show most fields");
	$("#idprodfournprice").val('0');	// Set cursor on not selected product
	$("#prod_entry_mode_free").prop('checked',true).change();
	$("#prod_entry_mode_predef").prop('checked',false).change();
	$("#search_idprod, #idprod, #search_idprodfournprice, #buying_price").val('');
	$("#price_ht, #multicurrency_price_ht, #price_ttc, #price_ttc, #fourn_ref, #title_fourn_ref, #tva_tx, #buying_price, #title_vat, #title_up_ht, #title_up_ht_currency, #title_up_ttc, #title_up_ttc_currency").show();
	<?php
	if (!empty($user->rights->margins->creer) && !empty($conf->global->ALTATPL_SHOW_MARGIN_INFOS))
	{
	?>
		$("#np_marginRate, #np_markRate, .np_marginRate, .np_markRate").show();
	<?php
	}
	?>
	<?php
	if (empty($senderissupplier))
	{
	?>
		$("#tva_tx").prop('disabled', false);
	<?php
	}
	else
	{
	?>
		$("#tva_tx, #title_vat").show();
	<?php
	}
	?>
	$("#units, #title_units").show();
	$("#fournprice_predef").hide();
}
function setforpredef() {
	console.log("Call setforpredef. We hide some fields and show dates");
	$("#select_type").val(-1);
	$("#prod_entry_mode_free").prop('checked',false).change();
	$("#prod_entry_mode_predef").prop('checked',true).change();
	$("#price_ht").val('');
	$("#fourn_ref, #title_fourn_ref").hide();
	<?php
	if (! $drafteditable)
	{
	?>
		$("#tva_tx").prop('disabled', true);
	<?php
	}

	if ( empty($canupdatepricesoncreate))
	{
	?>
		$("#price_ttc, #fourn_ref, #title_up_ttc, #title_up_ttc_currency").hide();
	<?php
	}
	if (! empty($user->rights->margins->creer) && !empty($conf->global->ALTATPL_SHOW_MARGIN_INFOS))
	{
	?>
		$("#np_marginRate, #np_markRate, .np_marginRate, .np_markRate").show();
	<?php
	}
	?>
	$("#units, #title_units").show();
	<?php
	if (! empty($user->rights->margins->creer) && !empty($conf->global->ALTATPL_SHOW_MARGIN_INFOS))
	{
	?>
		$("#buying_price").show();
	<?php
	}
	?>
	$('#trlinefordates, .divlinefordates').show();
}

<?php
if ($object->element == 'supplier_proposal' || $object->element == 'order_supplier' || $object->element == 'invoice_supplier')
{
}
elseif (empty($object->array_options['options_rental_doc']))
{
?>
	$(document).ready(function() {
		<?php
		if (empty($conf->global->PRODUIT_USE_SEARCH_TO_SELECT))
		{
		?>
			$("#idprod").change(function(e)
			{
				$.getJSON("<?php echo DOL_URL_ROOT; ?>/product/ajax/products.php", {"id" : $(this).val(), "action" : "fetch"}, function(data) {
					//alert(JSON.stringify(data));
					$("#price_ht").val(data.price_ht);
					$("#price_ttc").val(data.price_ttc);
					//$("#tva_tx option[value="+data.tva_tx+"]").attr("selected","selected");
				});
			});
		<?php
		}
		?>
		// commented by christophe battarel$("#price_ttc").change(function() {
			// commented by christophe battarelvar tva = $("#tva_tx").val();
			// commented by christophe battarelif (tva == 0) $("#price_ht").val($(this).val());
			// commented by christophe battarelelse {
				// commented by christophe battarelvar calc_arrondi = <?php print($conf->global->MAIN_MAX_DECIMALS_UNIT ? $conf->global->MAIN_MAX_DECIMALS_UNIT : 5);?> * 100;
				// commented by christophe battarel$("#price_ht").val(Math.round($(this).val() / (1 + tva/100) * calc_arrondi) / calc_arrondi);
			// commented by christophe battarel}
		// commented by christophe battarel});
		// commented by christophe battarel$("#price_ht").change(function() {
			// commented by christophe battarelvar tva = $("#tva_tx").val();
			// commented by christophe battarelif (tva == 0) $("#price_ttc").val($(this).val());
			// commented by christophe battarelelse {
				// commented by christophe battarelvar calc_arrondi = <?php print($conf->global->MAIN_MAX_DECIMALS_UNIT ? $conf->global->MAIN_MAX_DECIMALS_UNIT : 5);?> * 100;
				// commented by christophe battarel$("#price_ttc").val(Math.round($(this).val() * (1 + tva/100) * calc_arrondi) / calc_arrondi);
			// commented by christophe battarel}
		// commented by christophe battarel});
	});
<?php
}
if ( ! $drafteditable && ! empty($conf->stock->enabled) && empty($senderissupplier))
{ // ! $drafteditable because define in objectline_edit_once.tpl.php
?>
	// [name] is the name of the event "click", "mouseover", ..
	// same as you\'d pass it to bind()
	// [fn] is the handler function
	$.fn.bindFirst = function(name, fn) {
		// bind as you normally would
		// don\'t want to miss out on any jQuery magic
		this.on(name, fn);

		// Thanks to a comment by @Martin, adding support for
		// namespaced events too.
		this.each(function() {
			var handlers = $._data(this, "events")[name.split(".")[0]];
			// take out the handler we just inserted from the end
			var handler = handlers.pop();
			// move it at the beginning
			handlers.splice(0, 0, handler);
		});
	};

	function checkQtyStock(e)
	{
		var tr = $(this).parents("tr:first");

		if ( ! $("input[name^=options_rental_line]",tr).prop("checked")
			&& ( $(e.relatedTarget).parents("tr:first").is(tr)  || e.which == 1 )
			&& ( typeof $(e.relatedTarget).attr("name") == "undefined" || $(e.relatedTarget).attr("name") != 'search_idprod')
			&& ( typeof $(e.relatedTarget).attr("name") == "undefined" || ! $(e.relatedTarget).attr("name").startsWith('options_rental_line'))
			&& ( typeof $(e.relatedTarget).attr("name") == "undefined" || ! $(e.relatedTarget).attr("name").startsWith('options_used_line'))
			&& ($("select[name^=options_used_line]",tr).val() == "1"
				<?php
				if ( ! empty($conf->global->DOLITOOLS_CHECK_QTY_IN_STOCK) ) {
				?>
					|| $("input[name^=onpurchase]",tr).val() == "0"
				<?php
				}
				?>
				)
			&& $("input[name^=qty]",tr).val() * 1 > 0
			&& $("input[name^=qty]",tr).val() * 1 > $("input[name^=stock_available]",tr).val() * 1
			<?php
			if ( empty($conf->global->STOCK_SUPPORTS_SERVICES) ) {
			?>
					&& $("input[name^=type]",tr).val() == 0
			<?php
			}
			?>
		)
		{
			e.stopImmediatePropagation();

			$("input[name^=qty]",tr).focus().select();

			alert("<?php echo $langs->trans("QtyNotInStock"); ?>");

			return false;
		}
	}

		$(document).ready(function()
		{
			$("table input[name^=qty]").bindFirst("blur", checkQtyStock);
			$("input#addline").bindFirst("click", checkQtyStock);
		});
<?php
}

?>

</script>

<!-- END PHP TEMPLATE objectline_create.tpl.php -->
