<?php
/* Copyright (C) 2012	Christophe Battarel	<christophe.battarel@altairis.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**     \defgroup   price     Module Dolitools
 *      \brief      Module to manage dolitools
 *      \file       htdocs/includes/modules/modDolitools.class.php
 *      \ingroup    dolitools
 *      \brief      Description and activation file for module Dolitools
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';

/**
 * 	Class to describe module
 */
class modDolitools extends DolibarrModules
{
	/**
	 * 	Constructor
	 *
	 * 	@param	DoliDB	$db		Database handler
	 */
	function __construct($db)
	{
		global $conf;

		$this->db = $db;

		// Id for module (must be unique).
		// Use here a free id (See in Home -> System information -> Dolibarr for list of used modules id).
		$this->numero = 140191;
		// Key text used to identify module (for permissions, menus, etc...)
		$this->rights_class = 'dolitools';

		$this->editor_name = 'Altairis';
		$this->editor_url = 'http://altairis.fr';

		// Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
		// It is used to group modules in module setup page
		$this->family = "Altairis";
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i','',get_class($this));
		// Module description, used if translation string 'ModuleXXXDesc' not found (where XXX is value of numeric property 'numero' of module)
		$this->description = "Dolitools";
		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = '2021.05.27';
		// Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		// Where to store the module in setup page (0=common,1=interface,2=other)
		$this->special = 2;
		// Name of png file (without png) used for this module.
		// Png file must be in theme/yourtheme/img directory under name object_pictovalue.png.
		$this->picto='altairis@dolitools';

		// Data directories to create when module is enabled.
		$this->dirs = array();

		// Config pages. Put here list of php page names stored in admin directory used to setup module.
		$this->config_page_url = array('setup.php@dolitools');

		// Dependencies
		$this->depends = array();		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();				// List of modules id to disable if this one is disabled
		$this->phpmin = array(5,1);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(10,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("dolitools@dolitools", "altatpl@dolitools", "deletelines@dolitools", "updatelines@dolitools", "customref@dolitools", "availablestock@dolitools");

		// Constants
		$this->const = array(
		);

		// New pages on tabs
		$this->tabs = array(
		);

		// hooks
		$this->module_parts = array(
			'hooks' => array('demo', 'toprightmenu', 'propalcard','ordercard','invoicecard','supplier_proposalcard','ordersuppliercard','expeditioncard','invoicesuppliercard','stockproductcard','productservicelist','createfromclone'),
			'tpl' => 1,
			'triggers' => 1,
			'js'=>array('/dolitools/js/altatheme.js.php'),
			'css'=>array('/dolitools/css/altatheme.css.php', '/dolitools/css/altatpl.css', '/dolitools/css/customref.css'),
			'drafts' => 1
		);

		// Boxes
		$this->boxes = array();			// List of boxes
		$r=0;

		// Imports
		//--------
		$r=0;

		// Permissions
		$this->rights = array();		// Permission array used by this module

		$r=0;
        $r++;
        $this->rights[$r][0] = 14001911;
        $this->rights[$r][1] = 'Rafraichir les prix sur les propales';
        $this->rights[$r][2] = 'w';
        $this->rights[$r][3] = 0;
        $this->rights[$r][4] = 'updatelines';
        $this->rights[$r][5] = 'propale';

        $r++;
        $this->rights[$r][0] = 14001912;
        $this->rights[$r][1] = 'Rafraichir les prix sur les commandes';
        $this->rights[$r][2] = 'w';
        $this->rights[$r][3] = 0;
        $this->rights[$r][4] = 'updatelines';
        $this->rights[$r][5] = 'order';

        $r++;
        $this->rights[$r][0] = 14001913;
        $this->rights[$r][1] = 'Rafraichir les prix sur les factures';
        $this->rights[$r][2] = 'w';
        $this->rights[$r][3] = 0;
        $this->rights[$r][4] = 'updatelines';
        $this->rights[$r][5] = 'invoice';

		// Main menu entries
		$this->menu = array();			// List of menus to add
		$r = 0;

	}

	/**
     *	Function called when module is enabled.
     *	The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
     *	It also creates data directories.
     *
     *	@return     int             1 if OK, 0 if KO
     */
	function init($options = '')
  	{
		global $conf, $db, $langs;

        // Create extrafields during init
        include_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
        $extrafields = new ExtraFields($this->db);
        $result1=$extrafields->addExtraField('stock_available', "AvailableStock", 'real', 1,  null, 'product',   0, 0, 0, '', 0, '', 2, '', '', '', 'availablestock@dolitools', '$conf->dolitools->enabled && $conf->global->USE_AVAILABLE_STOCK'); // attention definition fausse modifiée dans sql/available/stock/llx_extrafields MAIS LAISSER LA LIGNE POUR PREDEF

        $result=$this->_load_tables('/dolitools/sql/availablestock/');
        if ($result < 0) return -1;

		$sql = array();

    	return $this->_init($sql);
  	}

	/**
	 *	Function called when module is disabled.
	 *	Remove from database constants, boxes and permissions from Dolibarr database.
	 *	Data directories are not deleted.
	 *
	 *	@return     int             1 if OK, 0 if KO
 	 */
	function remove($options = '')
	{
    	$sql = array();

    	return $this->_remove($sql);
  	}


	/**
	 * 	Create tables and keys required by module
	 * 	Files mymodule.sql and mymodule.key.sql with create table and create keys
	 * 	commands must be stored in directory /mymodule/sql/
	 * 	This function is called by this->init.
	 *
	 * 	@return		int		<=0 if KO, >0 if OK
	 */
  	function load_tables()
	{
		  return 0;
	}

}

?>
