<?php
/*
 * checkRef.php
 *
 * Copyright 2015 Christophe Battarel <christophe.battarel@altairis.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */
if (! defined('NOTOKENRENEWAL')) define('NOTOKENRENEWAL', '1'); // Disables token renewal

$res=@include("../../main.inc.php");					// For root directory
if (! $res) $res=@include("../../../main.inc.php");		// For "custom" directory

$attr = GETPOST('attr');
$value = GETPOST('value');
switch($attr)
{
	case 'ref_client':
		echo '<input type="text" name="'.$attr.'" value="'.addslashes($value).'" />';
		break;

	case 'fk_projet':
		$socid = GETPOST('socid', 'int');
		require_once DOL_DOCUMENT_ROOT . '/core/class/html.formprojet.class.php';
		$formproject = new FormProjets($db);
		$formproject->select_projects(($socid > 0 ? $socid : -1), $value, 'projectid', 0, 0, 1, 0, 0, 0, 0, '', 0, 0);
		//print ' &nbsp; <a href="'.DOL_URL_ROOT.'/projet/card.php?socid=' . $socid . '&action=create&status=1&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create&socid='.$socid).'"><span class="valignmiddle text-plus-circle">' . $langs->trans("AddProject") . '</span><span class="fa fa-plus-circle valignmiddle"></span></a>';
		break;

	case 'date_livraison':
	case 'fin_validite':
	case 'invoicedate':
		$form = new Form($db);
		echo $form->selectDate ($value, $attr);
		break;

	case 'shipping_method_id':
		$form = new Form($db);
		echo $form->selectShippingMethod ($value, $attr, '', 1);
		break;

	case 'cond_reglement_id':
		$form = new Form($db);
		$form->select_conditions_paiements ($value, $attr, - 1, 1);
		break;

	case 'mode_reglement_id':
		$form = new Form($db);
		$form->select_types_paiements ($value, $attr);
		break;

	case 'availability_id':
		$form = new Form($db);
		$form->selectAvailabilityDelay($value, $attr, '', 1);
		break;

	case 'demand_reason_id':
		$form = new Form($db);
		$form->selectInputReason ($value, $attr);
		break;

	case 'incoterm_id':
		$form = new Form($db);
		echo $form->select_incoterms ($value, $attr);
		break;

	case 'date_lim_reglement':
		$form = new Form($db);
		$form->select_types_paiements ($value, $attr, 'CRDT');
		break;

	case 'fk_account':
		$form = new Form($db);
		$form->select_comptes($value, $attr, 0, '', 1);
		break;

	case 'multicurrency_code':
		$form = new Form($db);
		$form->selectMultiCurrency($value, $attr);
		break;

	default :
		$form = new Form($db);
		echo $form->{'select_'.$attr} ($value, $attr);

}
?>
