<?php
/* Copyright (C) 2004-2010 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2009 Regis Houssin        <regis.houssin@capnetworks.com>
 * Copyright (C) 2006      Andre Cianfarani     <acianfa@free.fr>
 * Copyright (C) 2011 	   Juanjo Menent		<jmenent@2byte.es>
 * Copyright (C) 2014		Christophe Battarel	<christophe.battarel@altairis.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	    \file       htdocs/admin/customref.php
 *		\ingroup    produit
 *		\brief      Page to setup sending module
 */

$res=@include("../../main.inc.php");					// For root directory
if (! $res) $res=@include("../../../main.inc.php");		// For "custom" directory
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once '../lib/dolitools.lib.php';

$langs->loadLangs(array("admin", "customref@dolitools", "dolitools@dolitools"));

if (!$user->admin)
  accessforbidden();

$action=GETPOST('action','alpha');

$elems= array('propale','commande','facture','shipping');


foreach($elems as $elem)
{
	// no PROV
	if ($action == 'activate_noprov_on_'.$elem)
	{
		dolibarr_set_const($db, "CUSTOMREF_".strtoupper($elem)."_NOPROV", "1",'chaine',0,'',$conf->entity);
		header("Location: customref.php");
		exit;
	}else if ($action == 'disable_noprov_on_'.$elem)
	{
		dolibarr_del_const($db, "CUSTOMREF_".strtoupper($elem)."_NOPROV",$conf->entity);
		header("Location: customref.php");
		exit;
	}
	// suffix on create
	if ($action == 'activate_suffix_on_'.$elem.'_create')
	{
		dolibarr_set_const($db, "CUSTOMREF_".strtoupper($elem)."_SUFFIX_ON_CREATE", "1",'chaine',0,'',$conf->entity);
		header("Location: customref.php");
		exit;
	}else if ($action == 'disable_suffix_on_'.$elem.'_create')
	{
		dolibarr_del_const($db, "CUSTOMREF_".strtoupper($elem)."_SUFFIX_ON_CREATE",$conf->entity);
		header("Location: customref.php");
		exit;
	}
	// suffix on clone
	if ($action == 'activate_suffix_on_'.$elem.'_clone')
	{
		dolibarr_set_const($db, "CUSTOMREF_".strtoupper($elem)."_SUFFIX_ON_CLONE", "1",'chaine',0,'',$conf->entity);
		header("Location: customref.php");
		exit;
	}else if ($action == 'disable_suffix_on_'.$elem.'_clone')
	{
		dolibarr_del_const($db, "CUSTOMREF_".strtoupper($elem)."_SUFFIX_ON_CLONE",$conf->entity);
		header("Location: customref.php");
		exit;
	}
	// keep suffix on workflow
	if ($action == 'activate_keep_suffix_on_'.$elem.'_workflow')
	{
		dolibarr_set_const($db, "CUSTOMREF_".strtoupper($elem)."_KEEP_SUFFIX_ON_WORKFLOW", "1",'chaine',0,'',$conf->entity);
		header("Location: customref.php");
		exit;
	}else if ($action == 'disable_keep_suffix_on_'.$elem.'_workflow')
	{
		dolibarr_del_const($db, "CUSTOMREF_".strtoupper($elem)."_KEEP_SUFFIX_ON_WORKFLOW",$conf->entity);
		header("Location: customref.php");
		exit;
	}
}

/*
 * Affiche page
 */
$form=new Form($db);

$page_name = "DolitoolsSetup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="'.($backtopage?$backtopage:DOL_URL_ROOT.'/admin/modules.php?restore_lastsearch_values=1').'">'.$langs->trans("BackToModuleList").'</a>';

print load_fiche_titre($langs->trans($page_name), $linkback, 'object_altairis@dolitools');

// Configuration header
$head = dolitoolsAdminPrepareHead();
dol_fiche_head($head, 'customref', '', 0, 'dolitools@dolitools');

// Setup page goes here
echo '<span class="opacitymedium">'.$langs->trans("CustomRefSetupPage").'</span><br><br>';

/*
 * Formulaire parametres divers
 */

$var=true;
foreach($elems as $elem)
{
	print '<table class="noborder" width="100%">';
	print '<tr class="liste_titre">';
	print '<td>'.$langs->trans($elem."RefSetup").'</td>';
	print '<td align="center" width="20">&nbsp;</td>';
	print '<td align="center" width="100">'.$langs->trans("Status").'</td>';
	print '</tr>'."\n";

	// No Prov
	$var=!$var;
	print '<tr '.$bc[$var].'>';
	print '<td>'.$langs->trans("NoProv").'</td>';
	print '<td align="center" width="20">';
	print '</td>';
	print '<td align="center" width="100">';
	$glovar = "CUSTOMREF_".strtoupper($elem)."_NOPROV";
	if(empty($conf->global->$glovar))
	{
		print '<a href="customref.php?action=activate_noprov_on_'.$elem.'">'.img_picto($langs->trans("Disabled"),'switch_off').'</a>';
	}
	else
	{
		print '<a href="customref.php?action=disable_noprov_on_'.$elem.'">'.img_picto($langs->trans("Enabled"),'switch_on').'</a>';
	}
	print '</td>';
	print '</tr>';

	// Suffix on create
	$var=!$var;
	print '<tr '.$bc[$var].'>';
	print '<td>'.$langs->trans("SuffixOnCreate").'</td>';
	print '<td align="center" width="20">';
	print '</td>';
	print '<td align="center" width="100">';
	$glovar = "CUSTOMREF_".strtoupper($elem)."_SUFFIX_ON_CREATE";
	if(empty($conf->global->$glovar))
	{
		print '<a href="customref.php?action=activate_suffix_on_'.$elem.'_create">'.img_picto($langs->trans("Disabled"),'switch_off').'</a>';
	}
	else
	{
		print '<a href="customref.php?action=disable_suffix_on_'.$elem.'_create">'.img_picto($langs->trans("Enabled"),'switch_on').'</a>';
	}
	print '</td>';
	print '</tr>';
	// Suffix on clone
	if ($elem != 'shipping')
	{
		$var=!$var;
		print '<tr '.$bc[$var].'>';
		print '<td>'.$langs->trans("SuffixOnClone").'</td>';
		print '<td align="center" width="20">';
		print '</td>';
		print '<td align="center" width="100">';
		$glovar = "CUSTOMREF_".strtoupper($elem)."_SUFFIX_ON_CLONE";
		if(empty($conf->global->$glovar))
		{
			print '<a href="customref.php?action=activate_suffix_on_'.$elem.'_clone">'.img_picto($langs->trans("Disabled"),'switch_off').'</a>';
		}
		else
		{
			print '<a href="customref.php?action=disable_suffix_on_'.$elem.'_clone">'.img_picto($langs->trans("Enabled"),'switch_on').'</a>';
		}
		print '</td>';
		print '</tr>';
	}
	// Keep Suffix on workflow
	if ($elem != 'propale')
	{
		$var=!$var;
		print '<tr '.$bc[$var].'>';
		print '<td>'.$langs->trans("KeepSuffixOnCreateFrom").'</td>';
		print '<td align="center" width="20">';
		print '</td>';
		print '<td align="center" width="100">';
		$glovar = "CUSTOMREF_".strtoupper($elem)."_KEEP_SUFFIX_ON_WORKFLOW";
		if(empty($conf->global->$glovar))
		{
			print '<a href="customref.php?action=activate_keep_suffix_on_'.$elem.'_workflow">'.img_picto($langs->trans("Disabled"),'switch_off').'</a>';
		}
		else
		{
			print '<a href="customref.php?action=disable_keep_suffix_on_'.$elem.'_workflow">'.img_picto($langs->trans("Enabled"),'switch_on').'</a>';
		}
		print '</td>';
		print '</tr>';
	}

	print '</table>';
}
print '</div>';

$db->close();

llxFooter();
?>
