<?php
/* Copyright (C) 2004-2017 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2019 Alice Adminson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    dolitools/admin/setup.php
 * \ingroup dolitools
 * \brief   Dolitools setup page.
 */

// Load Dolibarr environment
$res=0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (! $res && ! empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) $res=@include $_SERVER["CONTEXT_DOCUMENT_ROOT"]."/main.inc.php";
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp=empty($_SERVER['SCRIPT_FILENAME'])?'':$_SERVER['SCRIPT_FILENAME'];$tmp2=realpath(__FILE__); $i=strlen($tmp)-1; $j=strlen($tmp2)-1;
while($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i]==$tmp2[$j]) { $i--; $j--; }
if (! $res && $i > 0 && file_exists(substr($tmp, 0, ($i+1))."/main.inc.php")) $res=@include substr($tmp, 0, ($i+1))."/main.inc.php";
if (! $res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i+1)))."/main.inc.php")) $res=@include dirname(substr($tmp, 0, ($i+1)))."/main.inc.php";
// Try main.inc.php using relative path
if (! $res && file_exists("../../main.inc.php")) $res=@include "../../main.inc.php";
if (! $res && file_exists("../../../main.inc.php")) $res=@include "../../../main.inc.php";
if (! $res) die("Include of main fails");

global $langs, $user;

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once '../lib/dolitools.lib.php';
//require_once "../class/myclass.class.php";

// Translations
$langs->loadLangs(array("admin", "altatheme@dolitools", "dolitools@dolitools"));

// Access control
if (! $user->admin) accessforbidden();

// Parameters
$action = GETPOST('action', 'alpha');
$var = GETPOST('var', 'alpha');
$value = GETPOST($var, 'alpha');

$backtopage = GETPOST('backtopage', 'alpha');

$altathemedesclink = (DOL_VERSION < 13) ? '<a href="'.DOL_URL_ROOT.'/admin/ihm.php" target="_blank">'.$langs->trans("GUISetup").'</a>' : '__taga__href=__quot__'.DOL_URL_ROOT.'/admin/ihm.php__quot__ target=__quot___blank__quot____gt__'.$langs->trans("GUISetup").'__tagaend__';

$arrayofparameters=array(
	'ALTATHEME_DONT_CHANGE_COLORS' => array('type' => 'bool', 'desclink' =>  $altathemedesclink),
	'ALTATHEME_USE_STICKY_HEADER' => array('type' => 'bool'),
	'ALTATHEME_USE_STICKY_BUTTON_TAB' => array('type' => 'bool'),
	'ALTATHEME_FIX_CARD_HEADER' => array('type' => 'bool'),
	'ALTATHEME_FIX_TABLE_HEADERS' => array('type' => 'bool'),
	'THIRD_PRIVATE_NOTES_ON_CARDS' => array('type' => 'bool'),
	'ALTATHEME_COLORIZE_SELECTED_LINES' => array('type' => 'bool', 'desclink' =>  $altathemedesclink),
	'MAIN_MAXTABS_IN_CARD' => array('type' => 'int', 'default' => 3),
	'ADD_UNSPLASH_LOGIN_BACKGROUND' => array('type' => 'string', 'default' => 'https://source.unsplash.com/random'),
);

if ($conf->theme == 'eldy') $arrayofparameters['ALTATHEME_DONT_AERATE']  = array('type' => 'bool');

$defaultvalue = $arrayofparameters[$var]['default'];

/*
 * Actions
 */

if ($action == 'activate') dolibarr_set_const($db, $var, "1", 'chaine', 0, '', $conf->entity);
elseif ($action == 'disable') dolibarr_del_const($db, $var, $conf->entity);
elseif ($action == 'set') dolibarr_set_const($db, $var, $value, 'chaine', 0, '', $conf->entity);
elseif ($action == 'reset') dolibarr_set_const($db, $var, $defaultvalue, 'chaine', 0, '', $conf->entity);

/*
 * View
 */

$page_name = "DolitoolsSetup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="'.($backtopage?$backtopage:DOL_URL_ROOT.'/admin/modules.php?restore_lastsearch_values=1').'">'.$langs->trans("BackToModuleList").'</a>';

print load_fiche_titre($langs->trans($page_name), $linkback, 'object_altairis@dolitools');

// Configuration header
$head = dolitoolsAdminPrepareHead();
print dol_get_fiche_head($head, 'altatheme', '', -1, "dolitools@dolitools");

// Setup page goes here
echo '<span class="opacitymedium">'.$langs->trans("AltathemeSetupPage").'</span><br><br>';

if (! empty($arrayofparameters))
{

	print '<table class="noborder" width="100%">';
	print '<tr class="liste_titre"><td >'.$langs->trans("Parameter").'</td><td>'.$langs->trans("Value").'</td></tr>';

	foreach($arrayofparameters as $key => $desc)
	{
		switch ($desc['type'])
		{
			case 'bool' :
				print '<tr class="oddeven">';
				print '<td>';
				print $langs->trans($key);
				print '</td>';
				print '<td>';
				if(empty($conf->global->$key))
				{
					print '<a href="'.$_SERVER['PHP_SELF'].'?action=activate&var='.$key.'">'.img_picto($langs->trans("Disabled"),'switch_off').'</a>';
				}
				else
				{
					print '<a href="'.$_SERVER['PHP_SELF'].'?action=disable&var='.$key.'">'.img_picto($langs->trans("Enabled"),'switch_on').'</a>';
				}
				print '&emsp;'.$langs->trans($key.'Desc', $desc['desclink']);
				print '</td>';
				break;

			default :
				print '<tr class="oddeven"><td>';
				print $form->textwithpicto($langs->trans($key), $langs->trans($key.'Tooltip'));
				print '</td>';

				print '<td>';
				print '<form method="post" action="'.$_SERVER['PHP_SELF'].'" style="display: inline;">';
				print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
				print '<input type="hidden" name="action" value="set" />';
				print '<input type="hidden" name="var" value="'.$key.'" />';
				print '<input type="integer" name="'.$key.'" value="'.$conf->global->$key.'" />';
				print '&emsp;';
				print '<input type="submit" class="button" value="'.$langs->trans("Update").'" />';
				print '</form>';
				print '<form method="post" action="'.$_SERVER['PHP_SELF'].'" style="display: inline;">';
				print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
				print '<input type="hidden" name="action" value="reset" />';
				print '<input type="hidden" name="var" value="'.$key.'" />';
				print '&emsp;';
				print '<input type="submit" class="button" value="'.$langs->trans("SetDefault").'" />';
				print '</form>';
				print '</td>';
		}

		print '</tr>';
	}
	print '</table>';

	print '<br>';
}
else
{
	print '<br>'.$langs->trans("NothingToSetup");
}


// Page end
print dol_get_fiche_end();

llxFooter();
$db->close();
