<?php

/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file		class/echeancier.class.php
 * 	\ingroup	echeancier
 * 	\brief
 *
 *
 */

/**
 * Put your class' description here
 */
class echeancier extends CommonObject {

    
    public $error;
    public $errors = array();
    public $element = 'echeancier';
    public $table_element = 'echeancier';
    public $table_element_line = 'echeance';
    public $fk_element = 'echeancier';
    var $id;
    var $type;
    var $montant;
    var $nombre_echeance;
    var $id_element;
    var $ref_element;
    var $ref;
    var $id_client;
    var $deja_paye;
    var $date_debut;
    var $count_paye;
    var $echeances = array();
    var $echeancier = array();
    var $num;

    /**
     * Constructor
     *
     * 	@param	DoliDb		$db		Database handler
     */
    //
    public function echeancier($db) {
        global $conf;
        $this -> db = $db;

        return 1;
    }

    //     function __construct($db) {
    //        global $conf;
    //        $this->db = $db;
    //
    //        return 1;
    //    }

    /**
     * Load object in memory from database
     *
     * 	@param		int		$id	Id object
     * 	@return		int			<0 if KO, >0 if OK
     */
    public function fetch($id) {
        global $langs;
        $sql = "SELECT e.id,e.type,e.montant,e.nombre,e.id_element,e.id_client,e.num,e.date_debut,fact.ref AS facnumber,prop.`ref`, ";
        $sql .= "(select sum(amount) from " . MAIN_DB_PREFIX . "paiement_facture where fk_facture =e.id_element) as deja_paye ,";
        $sql .= "(select sum(paye) from " . MAIN_DB_PREFIX . "echeance where fk_echeancier=e.id) as count_paye ";
        $sql .= " FROM " . MAIN_DB_PREFIX . "echeancier as e ";
        $sql .= "left outer join " . MAIN_DB_PREFIX . "facture as fact on e.id_element = fact.rowid ";
        $sql .= "left outer join " . MAIN_DB_PREFIX . "propal as prop on e.id_element = prop.rowid ";
        $sql .= " WHERE id = " . $id;
        dol_syslog(get_class($this) . "::fetch sql=" . $sql, LOG_DEBUG);

        $resql = $this -> db -> query($sql);
        if ($resql) {
            if ($this -> db -> num_rows($resql)) {
                $obj = $this -> db -> fetch_object($resql);

                $this -> id = $obj -> id;
                $this -> type = $obj -> type;
                $this -> montant = $obj -> montant;
                $this -> deja_paye = $obj -> deja_paye;
                $this -> count_paye = $obj -> count_paye;
                $this -> nombre_echeance = $obj -> nombre;
                $this -> id_element = $obj -> id_element;
                $this -> id_client = $obj -> id_client;
                $this -> date_debut = $obj -> date_debut;
                $this -> ref_element = $obj -> facnumber;
                $this -> ref = $obj -> ref;
                $this -> num = $obj -> num;
                $echeance = new echeance($this -> db);
                $this -> echeances = $echeance->GetEcheances($this -> id);
                
            }

            return 1;
        } else {
            $this -> error = "Error " . $this -> db -> lasterror();

            dol_syslog(get_class($this) . "::fetch " . $this -> error, LOG_ERR);

            return -1;
        }
    }

    //
    //    /**
    //     * Update object into database
    //     *
    //     * 	@param		User	$user		User that modify
    //     * 	@param		int		$notrigger	0=launch triggers after, 1=disable triggers
    //     * 	@return		int					<0 if KO, >0 if OK
    //     */
    //    public function update($user = 0, $notrigger = 0) {
    //        global $conf, $langs;
    //        $error = 0;
    //
    //        // Clean parameters
    //        if (isset($this->prop1)) {
    //            $this->prop1 = trim($this->prop1);
    //        }
    //        if (isset($this->prop2)) {
    //            $this->prop2 = trim($this->prop2);
    //        }
    //
    //        // Check parameters
    //        // Put here code to add control on parameters values
    //        // Update request
    //        $sql = "UPDATE " . MAIN_DB_PREFIX . "mytable SET";
    //        $sql.= " field1=" . (isset($this->field1) ? "'" . $this->db->escape($this->field1) . "'" : "null") . ",";
    //        $sql.= " field2=" . (isset($this->field2) ? "'" . $this->db->escape($this->field2) . "'" : "null") . "";
    //
    //        $sql.= " WHERE rowid=" . $this->id;
    //
    //        $this->db->begin();
    //
    //        dol_syslog(get_class($this) . "::update sql=" . $sql, LOG_DEBUG);
    //        $resql = $this->db->query($sql);
    //        if (!$resql) {
    //            $error++;
    //            $this->errors[] = "Error " . $this->db->lasterror();
    //        }
    //
    //        if (!$error) {
    //            if (!$notrigger) {
    //                // Uncomment this and change MYOBJECT to your own tag if you
    //                // want this action call a trigger.
    //                //// Call triggers
    //                //include_once DOL_DOCUMENT_ROOT . "/core/class/interfaces.class.php";
    //                //$interface=new Interfaces($this->db);
    //                //$result=$interface->run_triggers('MYOBJECT_MODIFY',$this,$user,$langs,$conf);
    //                //if ($result < 0) { $error++; $this->errors=$interface->errors; }
    //                //// End call triggers
    //            }
    //        }
    //
    //        // Commit or rollback
    //        if ($error) {
    //            foreach ($this->errors as $errmsg) {
    //                dol_syslog(get_class($this) . "::update " . $errmsg, LOG_ERR);
    //                $this->error.=($this->error ? ', ' . $errmsg : $errmsg);
    //            }
    //            $this->db->rollback();
    //
    //            return -1 * $error;
    //        } else {
    //            $this->db->commit();
    //
    //            return 1;
    //        }
    //    }
    //
    //    /**
    //     * Delete object in database
    //     *
    //     * 	@param		User	$user		User that delete
    //     * 	@param		int		$notrigger	0=launch triggers after, 1=disable triggers
    //     * 	@return		int					<0 if KO, >0 if OK
    //     */
    public function delete($id) {
        global $conf, $langs;
        $error = 0;

        $this -> db -> begin();

        // Commit or rollback
        if ($error) {
            foreach ($this->errors as $errmsg) {
                dol_syslog(get_class($this) . "::delete " . $errmsg, LOG_ERR);
                $this -> error .= ($this -> error ? ', ' . $errmsg : $errmsg);
            }
            $this -> db -> rollback();

            return -1 * $error;
        } else {
            $this -> db -> commit();

            return 1;
        }
    }

    public function GetEcheancesFromClient($id) {
        global $langs;
        $sql = "SELECT id";
        $sql .= " FROM " . MAIN_DB_PREFIX . "echeancier ";
        $sql .= " WHERE id_client = " . $id;
        $result = $this -> db -> query($sql);

        // dol_syslog('.......' . get_class($this) . "::fetch sql=" . $sql, LOG_DEBUG);
        if ($result) {
            $num = $this -> db -> num_rows($result);
            $i = 0;
            while ($i < $num) {
                $obj = $this -> db -> fetch_object($resql);
                $echeancier[$i] = $obj -> id;

                $i++;
            }

            return $echeancier;
        } else {
            $this -> error = "Error " . $this -> db -> lasterror();
            dol_syslog(get_class($this) . "::fetch " . $this -> error, LOG_ERR);

            return -1;
        }
    }

    public function GetEcheancesFromFacture($id, $type = 2) {
        global $langs;
        $sql = "SELECT id";
        $sql .= " FROM " . MAIN_DB_PREFIX . "echeancier ";
        $sql .= " WHERE id_element = " . $id . " and type=" . $type;
        $resql = $this -> db -> query($sql);
        dol_syslog(get_class($this) . "::GetFromFacture " . $sql, LOG_DEBUG);
        if ($resql) {
            if ($this -> db -> num_rows($resql)) {
                $obj = $this -> db -> fetch_object($resql);

                $this -> id = $obj -> id;
                return 1;
                //...
            } else {
                return 0;
            }
            $this -> db -> free($resql);
        } else {
            $this -> error = "Error " . $this -> db -> lasterror();
            dol_syslog(get_class($this) . "::fetch " . $this -> error, LOG_ERR);

            return -1;
        }
    }

}

class echeance extends CommonObject {

    
    //!< To store db handler
    public $error;
    //!< To return error code (or message)
    public $errors = array();
    //!< To return several error codes (or messages)
    var $id;
    var $type;
    var $montant;
    var $nombre_echeance;
    var $id_element;
    var $id_client;
    var $date_debut;
    var $count_paye;
    var $echeancier;
    var $date_reglement;
    var $acompte;
    var $paye;
    var $count;

    /**
     * Constructor
     *
     * 	@param	DoliDb		$db		Database handler
     */
    //    public function __construct($db) {
    //        $this->db = $db;
    //
    //        return 1;
    //    }
    public function echeance($db) {
        global $conf;
        $this -> db = $db;

        return 1;
    }

    /**
     * Load object in memory from database
     *
     * 	@param		int		$id	Id object
     * 	@return		int			<0 if KO, >0 if OK
     */
    //    public function fetch($id) {
    //        global $langs;
    //        $sql = "SELECT";
    //        $sql.= " t.rowid,";
    //        $sql.= " t.field1,";
    //        $sql.= " t.field2";
    //        //...
    //        $sql.= " FROM " . MAIN_DB_PREFIX . "mytable as t";
    //        $sql.= " WHERE t.rowid = " . $id;
    //
    //        dol_syslog(get_class($this) . "::fetch sql=" . $sql, LOG_DEBUG);
    //        $resql = $this->db->query($sql);
    //        if ($resql) {
    //            if ($this->db->num_rows($resql)) {
    //                $obj = $this->db->fetch_object($resql);
    //
    //                $this->id = $obj->rowid;
    //                $this->prop1 = $obj->field1;
    //                $this->prop2 = $obj->field2;
    //                //...
    //            }
    //            $this->db->free($resql);
    //
    //            return 1;
    //        } else {
    //            $this->error = "Error " . $this->db->lasterror();
    //            dol_syslog(get_class($this) . "::fetch " . $this->error, LOG_ERR);
    //
    //            return -1;
    //        }
    //    }
    //
    //    /**
    //     * Update object into database
    //     *
    //     * 	@param		User	$user		User that modify
    //     * 	@param		int		$notrigger	0=launch triggers after, 1=disable triggers
    //     * 	@return		int					<0 if KO, >0 if OK
    //     */
    //    public function update($user = 0, $notrigger = 0) {
    //        global $conf, $langs;
    //        $error = 0;
    //
    //        // Clean parameters
    //        if (isset($this->prop1)) {
    //            $this->prop1 = trim($this->prop1);
    //        }
    //        if (isset($this->prop2)) {
    //            $this->prop2 = trim($this->prop2);
    //        }
    //
    //        // Check parameters
    //        // Put here code to add control on parameters values
    //        // Update request
    //        $sql = "UPDATE " . MAIN_DB_PREFIX . "mytable SET";
    //        $sql.= " field1=" . (isset($this->field1) ? "'" . $this->db->escape($this->field1) . "'" : "null") . ",";
    //        $sql.= " field2=" . (isset($this->field2) ? "'" . $this->db->escape($this->field2) . "'" : "null") . "";
    //
    //        $sql.= " WHERE rowid=" . $this->id;
    //
    //        $this->db->begin();
    //
    //        dol_syslog(get_class($this) . "::update sql=" . $sql, LOG_DEBUG);
    //        $resql = $this->db->query($sql);
    //        if (!$resql) {
    //            $error++;
    //            $this->errors[] = "Error " . $this->db->lasterror();
    //        }
    //
    //        if (!$error) {
    //            if (!$notrigger) {
    //                // Uncomment this and change MYOBJECT to your own tag if you
    //                // want this action call a trigger.
    //                //// Call triggers
    //                //include_once DOL_DOCUMENT_ROOT . "/core/class/interfaces.class.php";
    //                //$interface=new Interfaces($this->db);
    //                //$result=$interface->run_triggers('MYOBJECT_MODIFY',$this,$user,$langs,$conf);
    //                //if ($result < 0) { $error++; $this->errors=$interface->errors; }
    //                //// End call triggers
    //            }
    //        }
    //
    //        // Commit or rollback
    //        if ($error) {
    //            foreach ($this->errors as $errmsg) {
    //                dol_syslog(get_class($this) . "::update " . $errmsg, LOG_ERR);
    //                $this->error.=($this->error ? ', ' . $errmsg : $errmsg);
    //            }
    //            $this->db->rollback();
    //
    //            return -1 * $error;
    //        } else {
    //            $this->db->commit();
    //
    //            return 1;
    //        }
    //    }
    //
    //    /**
    //     * Delete object in database
    //     *
    //     * 	@param		User	$user		User that delete
    //     * 	@param		int		$notrigger	0=launch triggers after, 1=disable triggers
    //     * 	@return		int					<0 if KO, >0 if OK
    //     */
    //    public function delete($user, $notrigger = 0) {
    //        global $conf, $langs;
    //        $error = 0;
    //
    //        $this->db->begin();
    //
    //
    //
    //
    //
    //        // Commit or rollback
    //        if ($error) {
    //            foreach ($this->errors as $errmsg) {
    //                dol_syslog(get_class($this) . "::delete " . $errmsg, LOG_ERR);
    //                $this->error.=($this->error ? ', ' . $errmsg : $errmsg);
    //            }
    //            $this->db->rollback();
    //
    //            return -1 * $error;
    //        } else {
    //            $this->db->commit();
    //
    //            return 1;
    //        }
    //    }

    public function GetEcheances($echeancier) {
        global $conf, $langs;
        $sql = "SELECT e.rowid,fk_facture,date_reglement,montant,acompte,ecart,montant_paye,paye,b.num_chq,p.rowid as paiement_id ";
        $sql .= " FROM " . MAIN_DB_PREFIX . "echeance as e";
        $sql .= " left outer join " . MAIN_DB_PREFIX . "paiement as p on e.fk_bank=p.rowid ";
        $sql .= " left outer join " . MAIN_DB_PREFIX . "bank as b on p.fk_bank = b.rowid ";
        $sql .= " WHERE fk_echeancier = " . $echeancier;
        $sql .= " order by date_reglement asc";
        dol_syslog(get_class($this) . "::Getecheance sql=" . $sql, LOG_DEBUG);
        $result = $this -> db -> query($sql);
        $echeance = array();
        $list = array();

        if ($result) {
            $num = $this -> db -> num_rows($result);
            $i = 0;
            while ($i < $num) {
                $objp = $this -> db -> fetch_object($result);

                $echeance['id'] = $objp -> rowid;
                $echeance['id_facture'] = $objp -> fk_facture;
                $echeance['date_reglement'] = $objp -> date_reglement;
                $echeance['montant'] = $objp -> montant;
                $echeance['acompte'] = $objp -> acompte;
                $echeance['paye'] = $objp -> paye;
                $echeance['num_chq'] = $objp -> num_chq;
                $echeance['paiement_id'] = $objp -> paiement_id;
                $echeance['montant_paye'] = price2num($objp -> montant_paye);
                $echeance['ecart'] = $objp -> ecart;
                

                $list[] = $echeance;
                $i++;
            }
        }
        return $list;
    }

    public function GetEcheanceFromDate($start, $end, $echeancier = 0, $sort = 'asc') {
        global $conf, $langs;
        $sql = "SELECT e.rowid,e.fk_facture,e.date_reglement,e.montant,e.montant_paye,e.ecart,e.acompte,e.paye,f.facnumber,s.nom,e.type ";
        $sql .= " FROM " . MAIN_DB_PREFIX . "echeance as e ";
        $sql .= " left outer join " . MAIN_DB_PREFIX . "facture as f on f.rowid = e.fk_facture ";
        $sql .= " left outer join " . MAIN_DB_PREFIX . "societe as s on s.rowid = f.fk_soc ";
        $sql .= " WHERE date_reglement >= '" . $start . "' and date_reglement <= '" . $end . "'  and e.paye=false and e.`type`=2 and e.montant > 0";
        if ($echeancier > 0)
            $sql .= " and fk_echeancier=" . $echeancier;
        $sql .= " order by e.date_reglement " . $sort;
        $result = $this -> db -> query($sql);
        dol_syslog(get_class($this) . "::fetchFromDate " . $sql, LOG_DEBUG);
        $echeance = array();
        $list = array();

        if ($result) {
            $num = $this -> db -> num_rows($result);
            $i = 0;
            while ($i < $num) {
                $objp = $this -> db -> fetch_object($result);

                $echeance['id'] = $objp -> rowid;
                $echeance['id_facture'] = $objp -> fk_facture;
                $echeance['date_reglement'] = $objp -> date_reglement;
                $echeance['montant'] = $objp -> montant;
                $echeance['montant_paye'] = $objp -> montant_paye;
                $echeance['ecart'] = $objp -> ecart;
                $echeance['acompte'] = $objp -> acompte;
                $echeance['paye'] = $objp -> paye;
                $echeance['nom'] = $objp -> nom;
                $echeance['facnumber'] = $objp -> facnumber;
                $echeance['type'] = $objp -> type;

                $list[] = $echeance;
                $i++;
            }
        }
        return $list;
    }

    public function GetFuturePaiement($month, $year) {
        global $conf;
        $mois = date($month);
        $annee = date($year);
        $lastday = strftime("%Y-%m-%d", mktime(0, 0, 0, $mois + 1, 0, $annee));
        $firstday = strftime("%Y-%m-%d", mktime(0, 0, 0, $mois, 1, $annee));

        $sql = "select sum(e.montant) as montant, count(*) as count from " . MAIN_DB_PREFIX . "echeance as e 
            where e.paye=0 and e.date_reglement>='" . $firstday . "' and e.date_reglement <='" . $lastday . "'";

        dol_syslog(get_class($this) . "::fetch " . $sql, LOG_DEBUG);
        $echeance = array();
        $resql = $this -> db -> query($sql);
        if ($resql) {
            if ($this -> db -> num_rows($resql)) {
                $obj = $this -> db -> fetch_object($resql);

                $echeance['montant'] = $obj -> montant;
                $echeance['count'] = $obj -> count;
            }
        }
        return $echeance;
    }

    public function GetEcheanceForPaiement($id) {
        global $conf, $langs;
        $sql = "SELECT e.rowid as erowid ,e.fk_facture,e.date_reglement,e.montant,e.acompte,e.paye,e.fk_echeancier,ec.num,ec.id as id_ech,f.facnumber,f.rowid,s.nom,f.total_ttc, ";
        $sql .= " (select sum(amount) from " . MAIN_DB_PREFIX . "paiement_facture where fk_facture =e.fk_facture) as deja_paye";
        $sql .= " FROM " . MAIN_DB_PREFIX . "echeance as e ";
        $sql .= " left outer join " . MAIN_DB_PREFIX . "facture as f on f.rowid = e.fk_facture ";
        $sql .= " left outer join " . MAIN_DB_PREFIX . "societe as s on s.rowid = f.fk_soc ";
        $sql .= " left outer join " . MAIN_DB_PREFIX . "echeancier as ec on ec.id = e.fk_echeancier ";
        $sql .= " WHERE e.rowid=" . $id;
        dol_syslog(get_class($this) . "::fetchForPaiement " . $sql, LOG_DEBUG);
        $echeance = array();
        $resql = $this -> db -> query($sql);
        if ($resql) {
            if ($this -> db -> num_rows($resql)) {
                $obj = $this -> db -> fetch_object($resql);

                $echeance['id'] = $obj -> erowid;
                $echeance['id_facture'] = $obj -> fk_facture;
                $echeance['date_reglement'] = $obj -> date_reglement;
                $echeance['montant'] = $obj -> montant;
                $echeance['acompte'] = $obj -> acompte;
                $echeance['paye'] = $obj -> paye;
                $echeance['nom'] = $obj -> nom;
                $echeance['num'] = $obj -> num;
                $echeance['facnumber'] = $obj -> facnumber;
                $echeance['rowid'] = $obj -> rowid;
                $echeance['id_ech'] = $obj -> id_ech;
                $echeance['deja_paye'] = $obj -> deja_paye;
                $echeance['total_ttc'] = $obj -> total_ttc;
            }
        }
        return $echeance;
    }

}
